/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.RemoteiSCSINamesCallback;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class AuthorizedPrivilegeInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    public static final UnsignedInteger16[] CPV_ACTIVITIES = new UnsignedInteger16[]{ProviderConstants.UINT16_FIVE, ProviderConstants.UINT16_SIX};
    public static final Boolean CPV_PRIVILEGEGRANTED = Boolean.TRUE;

    public static String createInstanceID(ISCSITargetPort.ISCSITarget target, String hostWWN) throws WBEMException {
        short ctrlID = PortandHostGroupInfo.getCtrIDUsingPortID((short)target.getPortID(), target.getSerialNumber());
        StringBuffer instID = new StringBuffer(RMIObjectMapping.getRMIObjectMapping(target.getSerialNumber()).getStorageSystemName());
        instID.append(".");
        instID.append(ctrlID);
        instID.append(".");
        instID.append(target.getPortID());
        instID.append(".");
        instID.append(target.getId());
        instID.append(".");
        instID.append(hostWWN);
        return instID.toString();
    }

    public static String createInstanceID(PortandHostGroupInfo hostGroup, String hostWWN) {
        StringBuffer instID = new StringBuffer(hostGroup.getSystemName());
        instID.append(".");
        instID.append(hostGroup.getCtrlID());
        instID.append(".");
        instID.append(hostGroup.getPortID());
        instID.append(".");
        instID.append(hostGroup.getHostgroupID());
        instID.append(".");
        instID.append(hostWWN);
        return instID.toString();
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListen4InstAdd()) {
            try {
                IndicationHelper helper = new IndicationHelper(mHandle);
                PortandHostGroupInfo phgi = (PortandHostGroupInfo)pObj;
                HashSet<String> hostWWNs = new HashSet<String>(Arrays.asList(phgi.getHostWWNs()));
                this.processIndication(phgi, hostWWNs, helper, true);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_AuthorizedPrivilege added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListen4InstDel()) {
            try {
                IndicationHelper helper = new IndicationHelper(mHandle);
                PortandHostGroupInfo phgi = (PortandHostGroupInfo)pObj;
                HashSet<String> hostWWNs = new HashSet<String>(Arrays.asList(phgi.getHostWWNs()));
                this.processIndication(phgi, hostWWNs, helper, false);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_AuthorizedPrivilege deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                PortandHostGroupInfo prevPHGI = (PortandHostGroupInfo)pObj;
                PortandHostGroupInfo newPHGI = PortandHostGroupInfo.find(prevPHGI.getSerialNumber(), prevPHGI.getSystemName(), String.valueOf(prevPHGI.getCtrlID()), String.valueOf(prevPHGI.getPortID()), String.valueOf(prevPHGI.getHostgroupID()), null, false, null);
                if (null == newPHGI) {
                    mLogger.log(Level.SEVERE, "Unable to find a PHGI {0}", prevPHGI);
                    return;
                }
                IndicationHelper helper = new IndicationHelper(mHandle);
                HashSet<String> prevHostWWNs = new HashSet<String>(Arrays.asList(prevPHGI.getHostWWNs()));
                HashSet<String> newHostWWNs = new HashSet<String>(Arrays.asList(newPHGI.getHostWWNs()));
                HashSet<String> tmp = new HashSet<String>(newHostWWNs);
                tmp.removeAll(prevHostWWNs);
                if (!tmp.isEmpty()) {
                    this.processIndication(newPHGI, tmp, helper, true);
                }
                tmp.clear();
                tmp.addAll(prevHostWWNs);
                tmp.removeAll(newHostWWNs);
                if (!tmp.isEmpty()) {
                    this.processIndication(newPHGI, tmp, helper, false);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_AuthorizedPrivilege modified indication instance", t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"ElementName", "SystemName"});
            String clientType = null;
            String hostID = null;
            String ctrID = null;
            String portID = null;
            String domainID = null;
            if (null != expectedValues) {
                if (1 != devices.size()) {
                    mLogger.log(Level.SEVERE, "{0} called with parameters for an association call, no device infoavailable. expValues: {1}, devices found: {2}", new Object[]{"HITACHI_StorageVolume", expectedValues, devices.size()});
                    if (null != iter) {
                        iter.done();
                    }
                    return;
                }
                ctrID = (String)expectedValues.get("CtrID");
                portID = (String)expectedValues.get("PortID");
                domainID = (String)expectedValues.get("DomainID");
                clientType = (String)expectedValues.get("ClientType");
                hostID = (String)expectedValues.get("HostWWN");
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                this.getHostGroupInfo(device, deviceIter, isObjectPath, refInfo, op, propertyList, hostID, ctrID, portID, domainID, clientType, continueOnError);
                this.getISCSITargets(device, op, propertyList, deviceIter, isObjectPath, refInfo, hostID, ctrID, portID, domainID, clientType, continueOnError);
            }
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        String instID = (String)keys[0].getValue();
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("PrivilegeGranted", CIMDataType.BOOLEAN_T, (Object)CPV_PRIVILEGEGRANTED, false), new CIMProperty("Activities", CIMDataType.UINT16_ARRAY_T, (Object)CPV_ACTIVITIES, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)instID, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)instID, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)instID, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        String instID;
        try {
            ProviderLibs.validateVARArgs(new Class[]{PortandHostGroupInfo.class, String.class}, o, "HITACHI_AuthorizedPrivilege");
            PortandHostGroupInfo hostGroup = (PortandHostGroupInfo)o[0];
            String hostWWN = (String)o[1];
            instID = AuthorizedPrivilegeInstrumentation.createInstanceID(hostGroup, hostWWN);
        }
        catch (IllegalArgumentException iae) {
            ProviderLibs.validateVARArgs(new Class[]{ISCSITargetPort.ISCSITarget.class, String.class}, o, "HITACHI_AuthorizedPrivilege");
            ISCSITargetPort.ISCSITarget target = (ISCSITargetPort.ISCSITarget)o[0];
            String hostWWN = (String)o[1];
            instID = AuthorizedPrivilegeInstrumentation.createInstanceID(target, hostWWN);
        }
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instID, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_AuthorizedPrivilege", keys, op.getXmlSchemaName());
    }

    private void getHostGroupInfo(RMIObjectMapping device, PassthruIterator<?> deviceIter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, String hostWWN, String ctrID, String portID, String domainID, String clientType, boolean continueOnError) throws WBEMException {
        CallbackHandler<PortandHostGroupInfo> callback = new CallbackHandler<PortandHostGroupInfo>(deviceIter, isObjectPath, refInfo, op, propertyList, hostWWN);
        PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), callback, device.getStorageSystemName(), ctrID, portID, domainID, hostWWN, false, clientType, continueOnError);
    }

    private AbstractBaseCommonObject getHostGrpObj(RMIObjectMapping device, String portID, String domainID, String hostWWN, String ctrID, String systemName) {
        AbstractBaseCommonObject hostGrpObj = null;
        try {
            FCPort port = FCPort.find(Short.parseShort(portID), FCPort.PortTypeRequested.ALL, device.getRMIObject());
            if (null != port) {
                mLogger.log(Level.FINE, "Getting HostGroup info for port {0}", port);
                if (!port.isRequestedType(FCPort.PortTypeRequested.iSCSI)) {
                    hostGrpObj = PortandHostGroupInfo.find(device.getSerialNumber(), systemName, ctrID, portID, domainID, hostWWN, true, null);
                } else {
                    ISCSITargetPort iPort = ISCSITargetPort.find(device.getRMIObject(), Integer.parseInt(portID));
                    hostGrpObj = iPort.getTarget(Short.parseShort(domainID));
                }
            }
        }
        catch (WBEMException we) {
            mLogger.log(Level.FINE, "Error trying to find port for hostgroup", we);
        }
        return hostGrpObj;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String ctrID;
            String hostWWN;
            String domainID;
            String portID;
            AbstractBaseCommonObject hostGrpObj;
            String[] instVals;
            String systemName;
            String cvInstanceID;
            CIMProperty cpInstanceID = op.getKey("InstanceID");
            String string = cvInstanceID = null != cpInstanceID ? (String)cpInstanceID.getValue() : null;
            if (null != cvInstanceID && null != (systemName = (instVals = PortandHostGroupInfo.parseInstanceID(cvInstanceID))[0]) && systemName.equals(device.getStorageSystemName()) && null != (hostGrpObj = this.getHostGrpObj(device, portID = instVals[2], domainID = instVals[3], hostWWN = instVals[4], ctrID = instVals[1], systemName))) {
                return this.generateInstance(op, propertyList, hostGrpObj, hostWWN);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private void getISCSITargets(RMIObjectMapping device, CIMObjectPath op, String[] propertyList, PassthruIterator<?> deviceIter, boolean isObjectPath, ReferenceInfo refInfo, String expHostID, String expCtrID, String expPortID, String expDomainID, String expClientType, boolean continueOnError) throws WBEMException {
        RemoteiSCSINamesCallback<ISCSITargetPort> iSCSIcb = new RemoteiSCSINamesCallback<ISCSITargetPort>(deviceIter, isObjectPath, refInfo, op, propertyList, expClientType, expHostID, expCtrID, expDomainID, this);
        ISCSITargetPort.getISCSIPorts(device.getRMIObject(), iSCSIcb, null == expPortID ? -1 : Integer.parseInt(expPortID));
    }

    private void processIndication(PortandHostGroupInfo phgi, Set<String> hostWWNs, IndicationHelper helper, boolean isCreateInd) {
        CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_AuthorizedPrivilege", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
        for (String item2Process : hostWWNs) {
            try {
                CIMInstance instAuthorizedPrivilege = this.generateInstance(op, null, phgi, item2Process);
                CIMInstance indication = isCreateInd ? helper.createInstCreationInstance(instAuthorizedPrivilege) : helper.createInstDeletionInstance(instAuthorizedPrivilege);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable th) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate an HITACHI_AuthorizedSubject deleted indication instance", th);
            }
        }
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM HITACHI_InstCreation WHERE SourceInstance ISA HITACHI_AuthorizedPrivilege".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM HITACHI_InstDeletion WHERE SourceInstance ISA HITACHI_AuthorizedPrivilege".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM HITACHI_InstModification WHERE SourceInstance ISA HITACHI_AuthorizedPrivilege".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, null);
        }
    }

    private class CallbackHandler<E extends PortandHostGroupInfo>
    extends IteratorCallbackIMPL<E> {
        String mExpWWN;

        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, String expWWN) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.mExpWWN = expWWN;
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (!this.mIter.isClosed()) {
                try {
                    String[] hostWWNs;
                    E hostGroupInfo = item;
                    for (String hostWWN : hostWWNs = ((PortandHostGroupInfo)hostGroupInfo).getHostWWNs()) {
                        if (null != this.mExpWWN && !this.mExpWWN.equalsIgnoreCase(hostWWN)) continue;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, AuthorizedPrivilegeInstrumentation.this.generateObjectPath(this.mOP, hostGroupInfo, hostWWN));
                            continue;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(AuthorizedPrivilegeInstrumentation.this.generateObjectPath(this.mOP, hostGroupInfo, hostWWN));
                            continue;
                        }
                        this.mIter.add(AuthorizedPrivilegeInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, hostGroupInfo, hostWWN));
                    }
                }
                catch (WBEMException we) {
                    this.mIter.setException(we);
                    this.mIter.close();
                }
                catch (Throwable thrown) {
                    WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            } else {
                ret = false;
            }
            return ret;
        }
    }
}

