/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.VDEVStats;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class BlockStatisticalDataArrayGroupInstrumentation
extends BaseInstrumentation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        block22: {
            try {
                List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
                String expInstID = null != expectedValues ? (String)expectedValues.get("InstanceID") : null;
                ChassisArrayGroup cag = null;
                if (null != expInstID) {
                    if (devices.size() == 1) {
                        Integer[] ret;
                        RMIObjectCache rmiObj = devices.get(0).getRMIObject();
                        cag = ChassisArrayGroup.find(rmiObj, null, (ret = ProviderLibs.getStoragePoolChassisAndArrayGroup(expInstID))[0], ret[1], isObjectPath);
                        if (null == cag) {
                            throw new WBEMException(1, "unable to locate required array group: " + expInstID);
                        }
                    } else {
                        throw new WBEMException("Association data passed but incorrect number of devices: " + devices.size());
                    }
                }
                for (RMIObjectMapping device : devices) {
                    CIMInstance newInst;
                    RMIObjectCache rmiObj = device.getRMIObject();
                    if (null == cag) {
                        CloseableAddableIterator statIter = new CloseableAddableIterator();
                        VDEVStats.getAllStats(rmiObj, (CloseableAddableIterator<VDEVStats>)statIter);
                        while (statIter.hasNext()) {
                            newInst = this.generateInstance(op, propertyList, statIter.next(), device.getRMIObject());
                            if (null == refInfo) {
                                if (isObjectPath) {
                                    iter.add(newInst.getObjectPath());
                                    continue;
                                }
                                iter.add(newInst);
                                continue;
                            }
                            refInfo.addReference(iter, newInst.getObjectPath());
                        }
                        continue;
                    }
                    VDEVStats stat = VDEVStats.getVDEVStats(rmiObj, cag);
                    newInst = this.generateInstance(op, propertyList, stat, device.getRMIObject());
                    if (null == refInfo) {
                        if (isObjectPath) {
                            iter.add(newInst.getObjectPath());
                            continue;
                        }
                        iter.add(newInst);
                        continue;
                    }
                    refInfo.addReference(iter, newInst.getObjectPath());
                }
            }
            catch (WBEMException we) {
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
            catch (Throwable th) {
                if (th instanceof WBEMException) {
                    WBEMException we = (WBEMException)th;
                    break block22;
                }
                Throwable t = th;
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                WBEMException we = new WBEMException(1, t.toString(), null, t);
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
            finally {
                if (null != iter && !iter.isClosed()) {
                    iter.done();
                }
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws WBEMException {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        VDEVStats stats = (VDEVStats)o[0];
        stats.getArrayGroup();
        try {
            ArrayList props = new ArrayList();
            ProviderLibs.addKeysToProperties(retOP.getKeys(), props);
            props.add(new CIMProperty("ElementType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_NINE, false));
            props.add(new CIMProperty("TotalIOs", CIMDataType.UINT64_T, (Object)stats.getGetTotalIOs(), false));
            UnsignedInteger64 volumeTotalIOs = new UnsignedInteger64(stats.getReadTransRateStatistic().bigIntegerValue().add(stats.getWriteTransRateStatistic().bigIntegerValue()));
            props.add(new CIMProperty("KBytesTransferred", CIMDataType.UINT64_T, (Object)volumeTotalIOs, false));
            props.add(new CIMProperty("ReadIOs", CIMDataType.UINT64_T, (Object)stats.getReadIOStatistic(), false));
            props.add(new CIMProperty("ReadHitIOs", CIMDataType.UINT64_T, (Object)stats.getReadHitStatistic(), false));
            props.add(new CIMProperty("WriteIOs", CIMDataType.UINT64_T, (Object)stats.getWriteIOStatistic(), false));
            props.add(new CIMProperty("WriteHitIOs", CIMDataType.UINT64_T, (Object)stats.getWriteHitStatistic(), false));
            BigInteger kbWrite = stats.getWriteTransRateStatistic().bigIntegerValue();
            BigInteger kbRead = stats.getReadTransRateStatistic().bigIntegerValue();
            props.add(new CIMProperty("KBytesRead", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(kbRead)));
            props.add(new CIMProperty("KBytesWritten", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(kbWrite)));
            BigInteger totalHitIOs = stats.getWriteHitStatistic().bigIntegerValue();
            totalHitIOs = totalHitIOs.add(stats.getReadHitStatistic().bigIntegerValue());
            props.add(new CIMProperty("TotalHitIOs", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(totalHitIOs)));
            Calendar cal = Calendar.getInstance();
            Date date = null == stats.getTargetTime() ? new Date(0L) : stats.getTargetTime();
            cal.setTime(date);
            props.add(new CIMProperty("StatisticTime", CIMDataType.DATETIME_T, (Object)new CIMDateTimeAbsolute(cal), false));
            props.add(new CIMProperty("SampleInterval", CIMDataType.DATETIME_T, (Object)new CIMDateTimeInterval("00000000000500.000000:000"), false));
            props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticalDataArrayGroup", false));
            props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticalDataArrayGroup", false));
            props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticalDataArrayGroup", false));
            return new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propertyList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{VDEVStats.class, RMIObjectCache.class}, o, "HITACHI_BlockStatisticalDataArrayGroup");
        VDEVStats statObj = (VDEVStats)o[0];
        RMIObjectCache rmiObj = (RMIObjectCache)o[1];
        CIMObjectPath ret = null;
        if (null != op && null != statObj) {
            String systemName;
            try {
                systemName = rmiObj.getSMISMappingContainer().getStorageSystemName();
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
            String name = systemName + "." + statObj.getFb4() + "." + statObj.getArrayGroup();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)name, true)};
            ret = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_BlockStatisticalDataArrayGroup", keys, op.getXmlSchemaName());
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            VDEVStats stat;
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == instID) {
                throw new WBEMException(6, op.toString());
            }
            Integer[] fbag = ProviderLibs.getStoragePoolChassisAndArrayGroup(instID);
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
            RMIObjectCache rmiObj = device.getRMIObject();
            ChassisArrayGroup cag = ChassisArrayGroup.find(rmiObj, null, fbag[0], fbag[1], false);
            if (cag != null && null != (stat = VDEVStats.getVDEVStats(rmiObj, cag))) {
                CIMInstance ci = this.generateInstance(op, propertyList, stat, rmiObj);
                return ci;
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

