/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class BlockStatisticsManifestInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
            for (RMIObjectMapping device : devices) {
                for (int index = 0; index < ProviderConstants.BLOCKSTATISTICS_SUPPORTED.length; ++index) {
                    CIMObjectPath obj;
                    if (null != refInfo) {
                        obj = this.generateObjectPath(op, ProviderConstants.BLOCKSTATISTICS_SUPPORTED[index], new Long(index), device.getRMIObject());
                        refInfo.addReference(iter, obj);
                        continue;
                    }
                    if (isObjectPath) {
                        obj = this.generateObjectPath(op, ProviderConstants.BLOCKSTATISTICS_SUPPORTED[index], new Long(index), device.getRMIObject());
                        iter.add(obj);
                        continue;
                    }
                    CIMInstance ci = this.generateInstance(op, propertyList, ProviderConstants.BLOCKSTATISTICS_SUPPORTED[index], new Long(index), device.getRMIObject());
                    iter.add(ci);
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws WBEMException {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        UnsignedInteger16 elementType = (UnsignedInteger16)o[0];
        Boolean elType2or8or9 = elementType.intValue() == 8 ? true : (elementType.intValue() == 9 ? true : elementType.intValue() == 2);
        try {
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("ElementType", CIMDataType.UINT16_T, (Object)elementType, false), new CIMProperty("IncludeStartStatisticTime", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("IncludeStatisticTime", CIMDataType.BOOLEAN_T, (Object)true, false), new CIMProperty("IncludeTotalIOs", CIMDataType.BOOLEAN_T, (Object)true, false), new CIMProperty("IncludeTotalHitIOs", CIMDataType.BOOLEAN_T, (Object)(elementType.intValue() == 8 || elementType.intValue() == 9 ? 1 : 0), false), new CIMProperty("IncludeKBytesTransferred", CIMDataType.BOOLEAN_T, (Object)true, false), new CIMProperty("IncludeIOTimeCounter", CIMDataType.BOOLEAN_T, (Object)this.includeIOTimeCounter(elementType.intValue()), false), new CIMProperty("IncludeReadIOs", CIMDataType.BOOLEAN_T, (Object)elType2or8or9, false), new CIMProperty("IncludeReadHitIOs", CIMDataType.BOOLEAN_T, (Object)elType2or8or9, false), new CIMProperty("IncludeReadIOTimeCounter", CIMDataType.BOOLEAN_T, (Object)(elementType.intValue() == 8 ? 1 : 0), false), new CIMProperty("IncludeReadHitIOTimeCounter", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("IncludeKBytesRead", CIMDataType.BOOLEAN_T, (Object)elType2or8or9, false), new CIMProperty("IncludeWriteIOs", CIMDataType.BOOLEAN_T, (Object)elType2or8or9, false), new CIMProperty("IncludeWriteHitIOs", CIMDataType.BOOLEAN_T, (Object)elType2or8or9, false), new CIMProperty("IncludeWriteIOTimeCounter", CIMDataType.BOOLEAN_T, (Object)(elementType.intValue() == 8 ? 1 : 0), false), new CIMProperty("IncludeWriteHitIOTimeCounter", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("IncludeKBytesWritten", CIMDataType.BOOLEAN_T, (Object)elType2or8or9, false), new CIMProperty("IncludeIdleTimeCounter", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("IncludeMaintOp", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("IncludeMaintTimeCounter", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticsManifest", false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticsManifest", false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticsManifest", false), new CIMProperty("CSVSequence", CIMDataType.STRING_ARRAY_T, null, false)};
            return new CIMInstance(retOP, props).filterProperties(propertyList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{UnsignedInteger16.class, Long.class, RMIObjectCache.class}, o, "HITACHI_BlockStatisticsManifest");
        String name = null;
        UnsignedInteger16 elementType = (UnsignedInteger16)o[0];
        Long id = (Long)o[1];
        RMIObjectCache rmiObj = (RMIObjectCache)o[2];
        try {
            StringBuilder tmp = new StringBuilder(rmiObj.getSMISMappingContainer().getStorageSystemName());
            tmp.append(".");
            tmp.append(id);
            tmp.append(".");
            tmp.append(elementType.longValue());
            name = tmp.toString();
        }
        catch (Exception e) {
            throw new WBEMException(1, "Unable to get storage system name!", null, (Throwable)e);
        }
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)name, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_BlockStatisticsManifest", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            String instIDVal;
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
            String name = device.getStorageSystemName();
            CIMProperty cpInstID = op.getKey("InstanceID");
            String string = instIDVal = null != cpInstID ? (String)cpInstID.getValue() : null;
            if (null == instIDVal) {
                throw new WBEMException(6, "InstanceID property not found: " + (op != null ? op.toString() : null));
            }
            if (!instIDVal.startsWith(name)) {
                throw new WBEMException(6, "System name invalid: " + (op != null ? op.toString() : null));
            }
            String elTypeStr = ProviderLibs.getEndString(instIDVal, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            UnsignedInteger16 elementType = new UnsignedInteger16(elTypeStr);
            String idStr = ProviderLibs.getAllButEndString(instIDVal.substring(name.length() + 1), ProviderConstants.ID_SEPERATOR_AS_CHAR);
            int id = Integer.parseInt(idStr);
            if (ProviderConstants.BLOCKSTATISTICS_SUPPORTED[id].longValue() == elementType.longValue()) {
                return this.generateInstance(op, propertyList, elementType, new Long(id), device.getRMIObject());
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op != null ? op.toString() : null);
    }

    private Boolean includeIOTimeCounter(int type) {
        boolean ret = 6 == type || 7 == type || 32768 == type || 32769 == type;
        return ret;
    }
}

