/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class CompositeLDEVExtentInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                DeviceNumber dn = (DeviceNumber)pObj;
                if (dn.getSLUSEElmCount() > 0) {
                    CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_CompositeLDEVExtent", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                    CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_CompositeLDEVExtent added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                DeviceNumber dn = (DeviceNumber)pObj;
                if (dn.getSLUSEElmCount() > 0) {
                    CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_CompositeLDEVExtent", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                    CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_CompositeLDEVExtent deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                DeviceNumber dn = (DeviceNumber)pObj;
                DeviceNumber newDN = DeviceNumber.find(dn.getDNAsString(), RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getRMIObject());
                if (newDN != null) {
                    if (dn.getSLUSEElmCount() > 0 || newDN.getSLUSEElmCount() > 0) {
                        CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_CompositeLDEVExtent", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                        CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                        CIMInstance sourceInstance = this.generateInstance(op, null, newDN);
                        IndicationHelper helper = new IndicationHelper(mHandle);
                        CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                        mHandle.deliverEvent(indication, null);
                    }
                } else {
                    mLogger.severe("Unable to find a volume that with Device ID: " + dn.getDNAsString());
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_CompositeLDEVExtent modified indication instance", t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        try {
            String expInstID = null;
            String expDevID = null;
            String expPoolID = null;
            ChassisArrayGroup cag = null;
            if (expectedValues != null) {
                expDevID = (String)expectedValues.get("DeviceID");
                expPoolID = (String)expectedValues.get("PoolID");
                expInstID = (String)expectedValues.get("InstanceID");
                if (expInstID != null && expDevID == null && expPoolID == null) {
                    Integer[] rets = ProviderLibs.getStoragePoolChassisAndArrayGroup(expInstID);
                    int fb4 = rets[0];
                    int ag = rets[1];
                    if (1 == devices.size()) {
                        cag = ChassisArrayGroup.find(devices.get(0).getRMIObject(), null, fb4, ag, isObjectPath);
                        if (cag == null) {
                            mLogger.log(Level.WARNING, "Failed to find cag with FB4: {0}, AG: {1} on {2}", new Object[]{fb4, ag, devices.get(0)});
                            iter.done();
                            return;
                        }
                    } else {
                        mLogger.log(Level.SEVERE, "{0} called with parameters for an association call, no device infoavailable. expValues: {1}, devices found: {2}", new Object[]{"HITACHI_CompositeLDEVExtent", expectedValues, devices.size()});
                        if (null != iter) {
                            iter.done();
                        }
                        return;
                    }
                }
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                LDEVCallback<DeviceNumber> callback = new LDEVCallback<DeviceNumber>(deviceIter, device.getStorageSystemName(), isObjectPath, refInfo, op, propertyList);
                if (expPoolID == null) {
                    DeviceNumber.getDNs(device.getRMIObject(), callback, isObjectPath, null == propertyList || propertyList.length > 0, expDevID, cag == null ? -1 : cag.getFb4(), cag == null ? -1 : cag.getPg(), cag == null ? -1 : cag.getVdev(), true);
                    continue;
                }
                short poolID = Short.parseShort(expPoolID);
                DeviceNumber.getDNs(device.getRMIObject(), callback, poolID, true, VolumeTypeEnum.AOUVOL);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        DeviceNumber dn = (DeviceNumber)o[0];
        CIMInstance ret = null;
        try {
            if (null != op && null != dn) {
                UnsignedInteger64 consumable;
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber());
                CIMProperty[] keys = retOP.getKeys();
                UnsignedInteger64 blocks = dn.getNumOfBlocks();
                if (dn.isAOUPoolVol() || dn.isQSPoolVol()) {
                    ThinPool tp = ThinPool.find(device.getRMIObject(), dn.getSPoolID(), ThinPool.ThinPoolType.ALL);
                    if (null != tp) {
                        BigInteger pages = BigInteger.valueOf(tp.getPageSize());
                        pages = dn.isMFVolume() ? pages.multiply(BigInteger.valueOf(39911424L)) : pages.multiply(BigInteger.valueOf(ProviderConstants.THINPOOL_METADATASPACE_CONSTANT));
                        pages = pages.divide(BigInteger.valueOf(dn.getBlockSize().longValue()));
                        consumable = new UnsignedInteger64(pages);
                    } else {
                        consumable = ProviderConstants.UINT64_ZED;
                        mLogger.log(Level.SEVERE, "DN {0} indicates it is a pool vol for pool {1} but that pool could not be found", new Object[]{dn.getDNAsString(), dn.getThinPoolID()});
                    }
                } else {
                    consumable = blocks;
                }
                UnsignedInteger16 cvConsistsOf = dn.getConsistsOf(null);
                String elName = "CompositeLDEVExtent:" + dn.getDNAsString();
                UnsignedInteger16[] extentStatusvalue = new UnsignedInteger16[]{ProviderConstants.UINT16_SIX};
                String[] extentDiscriminator = dn.isVolumeIsPool() ? (dn.getUsageValue().compareTo(ProviderConstants.UINT16_ONE) == 0 ? new String[]{"SNIA:Composite", "SNIA:Intermediate", "SNIA:Reserved"} : new String[]{"SNIA:Pool Component", "SNIA:Composite"}) : new String[]{"SNIA:Composite", "SNIA:Intermediate"};
                CIMProperty[] retProps = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("ConsistsOf", CIMDataType.UINT16_T, (Object)cvConsistsOf, false), new CIMProperty("NumberOfBlocks", CIMDataType.UINT64_T, (Object)blocks, false), new CIMProperty("ExtentStripeLength", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ONE, false), new CIMProperty("IsConcatenated", CIMDataType.BOOLEAN_T, (Object)Boolean.TRUE, false), new CIMProperty("BlockSize", CIMDataType.UINT64_T, (Object)dn.getBlockSize(), false), new CIMProperty("ConsumableBlocks", CIMDataType.UINT64_T, (Object)consumable, false), new CIMProperty("IsBasedOnUnderlyingRedundancy", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("ExtentStatus", CIMDataType.UINT16_ARRAY_T, (Object)extentStatusvalue, false), new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("DataRedundancy", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(1), false), new CIMProperty("PackageRedundancy", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(0), false), new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("Name", CIMDataType.STRING_T, (Object)dn.getDNAsString(), false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(ProviderConstants.OP_STATUS_INDEX.OK.getStatusValue())}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(2), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)dn.getDNAsString(), false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)dn.getDNAsString(), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)elName, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{"OK"}, false), new CIMProperty("ExtentDiscriminator", CIMDataType.STRING_ARRAY_T, (Object)extentDiscriminator, false)};
                ret = new CIMInstance(retOP, retProps);
                ret = ret.filterProperties(propertyList);
            }
            return ret;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{DeviceNumber.class}, o, "HITACHI_CompositeLDEVExtent");
        DeviceNumber dn = (DeviceNumber)o[0];
        String deviceID = dn.getDNAsString();
        CIMObjectPath ret = null;
        if (null != op && null != deviceID) {
            String systemName;
            try {
                systemName = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getStorageSystemName();
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_CompositeLDEVExtent", true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)deviceID, true)};
            ret = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_CompositeLDEVExtent", keys, op.getXmlSchemaName());
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String sysNameKeyVal;
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String deviceIDKeyVal = null != op.getKey("DeviceID") ? (String)op.getKey("DeviceID").getValue() : null;
            String string = sysNameKeyVal = null != op.getKey("SystemName") ? (String)op.getKey("SystemName").getValue() : null;
            if (null == deviceIDKeyVal || null == sysNameKeyVal || null == ccName || !ccName.equals("HITACHI_CompositeLDEVExtent") || null == sccName || !sccName.equals("HITACHI_StorageSystem")) {
                throw new WBEMException(6, op.toString());
            }
            DeviceNumber data = DeviceNumber.find(deviceIDKeyVal, true, device.getRMIObject());
            if (data != null) {
                return this.generateInstance(op, propertyList, data);
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM HITACHI_InstCreation WHERE SourceInstance ISA HITACHI_CompositeLDEVExtent".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM HITACHI_InstDeletion WHERE SourceInstance ISA HITACHI_CompositeLDEVExtent".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM HITACHI_InstModification WHERE SourceInstance ISA HITACHI_CompositeLDEVExtent".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.LDEV, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.LDEV, this, null);
        }
    }

    private class LDEVCallback<E extends DeviceNumber>
    extends IteratorCallbackIMPL<E> {
        protected LDEVCallback(CustomCloseableIterator<?> iter, String sysName, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (this.mIter.isClosed()) {
                ret = false;
            } else {
                try {
                    if (null != this.mRefInfo) {
                        this.mRefInfo.addReference(this.mIter, CompositeLDEVExtentInstrumentation.this.generateObjectPath(this.mOP, item));
                    } else if (this.mIsObjectPath) {
                        this.mIter.add(CompositeLDEVExtentInstrumentation.this.generateObjectPath(this.mOP, item));
                    } else {
                        this.mIter.add(CompositeLDEVExtentInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, item));
                    }
                }
                catch (Exception e) {
                    WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            }
            return ret;
        }
    }
}

