/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ChassisInfo;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class DKCChassisInstrumentation
extends BaseInstrumentation {
    protected static String createTag(String dkID, String model, String serial) throws WBEMException {
        StringBuffer ret = new StringBuffer();
        ret.append(model);
        ret.append(ProviderConstants.ID_SEPERATOR_AS_CHAR);
        ret.append(serial);
        ret.append(ProviderConstants.ID_SEPERATOR_AS_CHAR);
        ret.append(dkID);
        return ret.toString();
    }

    protected static String[] decodeTag(String tagValue) {
        String[] ret = null;
        if (null != tagValue) {
            ret = new String[]{ProviderLibs.getAllButEndString(tagValue, ProviderConstants.ID_SEPERATOR_AS_CHAR), ProviderLibs.getEndString(tagValue, ProviderConstants.ID_SEPERATOR_AS_CHAR)};
        }
        return ret;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<Object> devices = new ArrayList(0);
        try {
            String expTag;
            String expDKCID = null;
            String string = expTag = null != expectedValues ? (String)expectedValues.get("Tag") : null;
            if (null != expTag) {
                String[] tagValues = DKCChassisInstrumentation.decodeTag(expTag);
                if (null != tagValues) {
                    expDKCID = tagValues[1];
                    devices = ProviderLibs.getManagedDevices(op, "Tag", expectedValues, "Tag");
                    if (1 != devices.size()) {
                        mLogger.log(Level.SEVERE, "Found {0} managed devices from values {1}, expected 1", new Object[]{devices.size(), expectedValues});
                        iter.done();
                        return;
                    }
                }
                if (null == expDKCID) {
                    mLogger.log(Level.SEVERE, "Can not determine managed device from values {0}", expectedValues);
                    iter.done();
                    return;
                }
            } else {
                devices = ProviderLibs.getManagedDevices(op, "Tag", expectedValues, new String[]{"SystemName", "Tag"});
            }
            for (RMIObjectMapping rMIObjectMapping : devices) {
                String[] chassisIDs;
                ChassisInfo info = ChassisInfo.getChassisInfo(rMIObjectMapping.getSerialNumber());
                for (String chassisID : chassisIDs = info.getDKCIDs()) {
                    if (null != expDKCID && !expDKCID.equals(chassisID)) continue;
                    if (null != refInfo) {
                        refInfo.addReference(iter, this.generateObjectPath(op, chassisID, rMIObjectMapping.getRMIObject()));
                        continue;
                    }
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, chassisID, rMIObjectMapping.getRMIObject()));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, chassisID, rMIObjectMapping.getRMIObject()));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        String dkcID = (String)o[0];
        RMIObjectCache rmiObj = (RMIObjectCache)o[1];
        String model = rmiObj.getSMISMappingContainer().getModel();
        String serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
        String tag = DKCChassisInstrumentation.createTag(dkcID, model, serialNum);
        try {
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] retProps = new CIMProperty[]{keys[0], keys[1], new CIMProperty("ChassisTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(17)}, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)tag, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)tag, false), new CIMProperty("Manufacturer", CIMDataType.STRING_T, (Object)"HITACHI", false), new CIMProperty("Model", CIMDataType.STRING_T, (Object)model, false), new CIMProperty("SerialNumber", CIMDataType.STRING_T, (Object)serialNum, false), new CIMProperty("Name", CIMDataType.STRING_T, (Object)tag, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(2)}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)tag, false)};
            return new CIMInstance(retOP, retProps).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{String.class, RMIObjectCache.class}, o, "HITACHI_DKCChassis");
        String dkcID = (String)o[0];
        RMIObjectCache rmiObj = (RMIObjectCache)o[1];
        String model = rmiObj.getSMISMappingContainer().getModel();
        String serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
        String tag = DKCChassisInstrumentation.createTag(dkcID, model, serialNum);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_DKCChassis", true), new CIMProperty("Tag", CIMDataType.STRING_T, (Object)tag, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_DKCChassis", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "Tag");
        try {
            String tagKeyValue;
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String string = tagKeyValue = null != op.getKey("Tag") ? (String)op.getKey("Tag").getValue() : null;
            if (null == ccName || !ccName.equals("HITACHI_DKCChassis") || null == tagKeyValue) {
                throw new WBEMException(6, op.toString());
            }
            String[] vals = DKCChassisInstrumentation.decodeTag(tagKeyValue);
            String ssKeyValue = vals[0];
            String dkcLocation = vals[1];
            ChassisInfo info = ChassisInfo.getChassisInfo(device.getSerialNumber());
            if (info.isValidDKCLocation(dkcLocation)) {
                String ssName = device.getStorageSystemName();
                if (null != ssKeyValue && ssKeyValue.equals(ssName)) {
                    return this.generateInstance(op, propertyList, dkcLocation, device.getRMIObject());
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

