/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ChassisInfo;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class DKCLocationInstrumentation
extends BaseInstrumentation {
    protected static String createName(String chassisID, String model, String serial) throws WBEMException {
        StringBuffer ret = new StringBuffer();
        ret.append(model);
        ret.append(ProviderConstants.ID_SEPERATOR_AS_CHAR);
        ret.append(serial);
        ret.append(ProviderConstants.ID_SEPERATOR_AS_CHAR);
        ret.append(chassisID);
        return ret.toString();
    }

    protected static String[] decodeName(String nameValue) {
        String[] ret = null;
        if (null != nameValue) {
            ret = new String[]{ProviderLibs.getAllButEndString(nameValue, ProviderConstants.ID_SEPERATOR_AS_CHAR), ProviderLibs.getEndString(nameValue, ProviderConstants.ID_SEPERATOR_AS_CHAR)};
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices;
            String expDKCID = null;
            if (null != expectedValues) {
                String expName = (String)expectedValues.get("Name");
                String[] expNameValues = DKCLocationInstrumentation.decodeName(expName);
                if (null == expNameValues || null == expNameValues[0] || null == expNameValues[1]) throw new WBEMException("Association call did not provide device data");
                String serial = ProviderLibs.getSerialFromString(expNameValues[0]);
                if (null == serial) throw new WBEMException("Could not decode Name: " + expName);
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serial);
                if (null == device) throw new WBEMException("Could not find managed device, serial: " + serial + ", Name: " + expName);
                devices = new ArrayList<RMIObjectMapping>(1);
                devices.add(device);
                expDKCID = expNameValues[1];
            } else {
                devices = ProviderLibs.getManagedDevices(op, "Name", expectedValues);
            }
            for (RMIObjectMapping device : devices) {
                String[] chassisIDs;
                ChassisInfo info = ChassisInfo.getChassisInfo(device.getSerialNumber());
                for (String chassisID : chassisIDs = info.getDKCIDs()) {
                    if (null != expDKCID && !expDKCID.equals(chassisID)) continue;
                    if (null != refInfo) {
                        refInfo.addReference(iter, this.generateObjectPath(op, chassisID, device.getRMIObject()));
                        continue;
                    }
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, chassisID, device.getRMIObject()));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, chassisID, device.getRMIObject()));
                }
            }
            if (null == iter) return;
            iter.done();
            return;
        }
        catch (WBEMException we) {
            if (null == iter) throw we;
            iter.setException(we);
            iter.close();
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null == iter) throw we;
            iter.setException(we);
            iter.close();
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        try {
            String dkcID = (String)o[0];
            CIMProperty[] keys = retOP.getKeys();
            String name = (String)keys[0].getValue();
            CIMProperty[] retProps = new CIMProperty[]{keys[0], keys[1], new CIMProperty("Caption", CIMDataType.STRING_T, (Object)dkcID, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)name, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)dkcID, false)};
            return new CIMInstance(retOP, retProps).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{String.class, RMIObjectCache.class}, o, "HITACHI_DKCLocation");
        String chassisID = (String)o[0];
        RMIObjectCache rmiObj = (RMIObjectCache)o[1];
        RMIObjectMapping device = rmiObj.getSMISMappingContainer();
        String name = DKCLocationInstrumentation.createName(chassisID, device.getModel(), device.getSerialNumber());
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("Name", CIMDataType.STRING_T, (Object)name, true), new CIMProperty("PhysicalPosition", CIMDataType.STRING_T, (Object)chassisID, false)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_DKCLocation", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "Name");
            String positionKeyValue = null != op.getKey("PhysicalPosition") ? (String)op.getKey("PhysicalPosition").getValue() : null;
            String nameKeyValue = null != op.getKey("Name") ? (String)op.getKey("Name").getValue() : null;
            String[] nameValues = DKCLocationInstrumentation.decodeName(nameKeyValue);
            if (null != positionKeyValue && null != nameValues) {
                String systemName = nameValues[0];
                String chassisID = nameValues[1];
                ChassisInfo info = ChassisInfo.getChassisInfo(device.getSerialNumber());
                if (null != chassisID && chassisID.equals(positionKeyValue) && info.isValidDKCLocation(chassisID) && device.getStorageSystemName().equals(systemName)) {
                    return this.generateInstance(op, propertyList, chassisID, device.getRMIObject());
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

