/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CHAInfo;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class DKCProcessorCardInChassisInstrumentation
extends BaseAssocInstrumentation {
    private static final Map<String, Map<String, String>> deviceMap = new HashMap<String, Map<String, String>>();
    private final String ID_DKC0 = "DKC-0";
    private final String ID_DKC1 = "DKC-1";

    protected DKCProcessorCardInChassisInstrumentation() {
        super("HITACHI_DKCProcessorCardInChassis", "HITACHI_DKCChassis", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DKCChassisInstrumentation"), "HITACHI_StorageProcessorCard", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProcessorCardInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_DKCProcessorCardInChassis".equalsIgnoreCase(assocName.getObjectName())) {
                String tag;
                Boolean retDKC = null;
                String searchVal = "";
                RMIObjectMapping device = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("GroupComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("PartComponent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                    tag = null != objectName.getKey("Tag") ? (String)objectName.getKey("Tag").getValue() : null;
                    searchVal = ProviderLibs.getEndString(tag, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    if (searchVal.equals("DKC-0") || searchVal.equals("DKC-1")) {
                        retDKC = Boolean.FALSE;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("PartComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("GroupComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                    tag = null != objectName.getKey("Tag") ? (String)objectName.getKey("Tag").getValue() : null;
                    searchVal = ProviderLibs.getEndString(tag, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    retDKC = Boolean.TRUE;
                }
                if (null != retDKC && searchVal.length() > 0) {
                    Map<String, String> dkcHash = this.getDKCHash(device);
                    CommonClassAsList<CHAInfo> callback = new CommonClassAsList<CHAInfo>();
                    CHAInfo.getCHAInfoByChaNum(device.getRMIObject(), callback, (short)-1);
                    LinkedList<CHAInfo> chaInfoList = callback.getReturnValue();
                    callback = null;
                    CHAInfo chaInfo = chaInfoList.poll();
                    while (chaInfo != null) {
                        String ctrID = String.valueOf(chaInfo.getCtrID());
                        String pcInfo = chaInfo.getDisplayName() + " - " + chaInfo.getChaNum();
                        String chassisID = dkcHash.get(pcInfo);
                        if (null != chassisID) {
                            if (Boolean.TRUE == retDKC) {
                                if (searchVal.equalsIgnoreCase(ctrID)) {
                                    if (isObjectPath) {
                                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, chassisID, device.getRMIObject()));
                                        break;
                                    }
                                    iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, chassisID, device.getRMIObject()));
                                    break;
                                }
                            } else if (searchVal.equalsIgnoreCase(chassisID)) {
                                if (isObjectPath) {
                                    iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, chaInfo));
                                } else {
                                    iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, chaInfo));
                                }
                            }
                        }
                        chaInfo = chaInfoList.poll();
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                CHAInfo chaInfo;
                CommonClassAsList<CHAInfo> callback = new CommonClassAsList<CHAInfo>();
                CHAInfo.getCHAInfoByCtrID(device.getRMIObject(), callback, -1);
                LinkedList<CHAInfo> chaInfoList = callback.getReturnValue();
                callback = null;
                Map<String, String> dkcHash = this.getDKCHash(device);
                while (null != (chaInfo = chaInfoList.poll())) {
                    String pcInfo = chaInfo.getDisplayName() + " - " + chaInfo.getChaNum();
                    String chassisID = dkcHash.get(pcInfo);
                    if (null == chassisID) continue;
                    CIMObjectPath opDKCChassis = this.getReference1Instrumentation().generateObjectPath(op, chassisID, device.getRMIObject());
                    CIMObjectPath opProcessorCard = this.getReference2Instrumentation().generateObjectPath(op, chaInfo);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, opDKCChassis, opProcessorCard));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, opDKCChassis, opProcessorCard));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> getDKCHash(RMIObjectMapping device) throws WBEMException {
        Map<String, String> dkcHash = deviceMap.get(device.getSerialNumber());
        if (null == dkcHash) {
            Map<String, Map<String, String>> map = deviceMap;
            synchronized (map) {
                dkcHash = deviceMap.get(device.getSerialNumber());
                if (null == dkcHash) {
                    dkcHash = new HashMap<String, String>();
                    String modelName = device.getRMIObject().getSMIHm8XXModelName();
                    if (modelName.contains("100") || modelName.contains("200")) {
                        dkcHash.put("CHB-1A - 0", "DKC-0");
                        dkcHash.put("CHB-1B - 1", "DKC-0");
                        dkcHash.put("CHB-2A - 2", "DKC-0");
                        dkcHash.put("CHB-2B - 3", "DKC-0");
                    } else if (modelName.contains("400") || modelName.contains("600")) {
                        dkcHash.put("CHB-1A - 0", "DKC-0");
                        dkcHash.put("CHB-1B - 1", "DKC-0");
                        dkcHash.put("CHB-1C - 2", "DKC-0");
                        dkcHash.put("CHB-1D - 3", "DKC-0");
                        dkcHash.put("CHB-1E - 4", "DKC-0");
                        dkcHash.put("CHB-1F - 5", "DKC-0");
                        dkcHash.put("CHB-1G - 6", "DKC-0");
                        dkcHash.put("CHB-1H - 7", "DKC-0");
                        dkcHash.put("CHB-2A - 8", "DKC-0");
                        dkcHash.put("CHB-2B - 9", "DKC-0");
                        dkcHash.put("CHB-2C - 10", "DKC-0");
                        dkcHash.put("CHB-2D - 11", "DKC-0");
                        dkcHash.put("CHB-2E - 12", "DKC-0");
                        dkcHash.put("CHB-2F - 13", "DKC-0");
                        dkcHash.put("CHB-2G - 14", "DKC-0");
                        dkcHash.put("CHB-2H - 15", "DKC-0");
                    } else if (modelName.contains("800")) {
                        dkcHash.put("CHB-1A - 0", "DKC-0");
                        dkcHash.put("CHB-1B - 1", "DKC-0");
                        dkcHash.put("CHB-1C - 2", "DKC-0");
                        dkcHash.put("CHB-1D - 3", "DKC-0");
                        dkcHash.put("CHB-1E - 4", "DKC-0");
                        dkcHash.put("CHB-1F - 5", "DKC-0");
                        dkcHash.put("CHB-1G - 6", "DKC-0");
                        dkcHash.put("CHB-1H - 7", "DKC-0");
                        dkcHash.put("CHB-1J - 8", "DKC-0");
                        dkcHash.put("CHB-1K - 9", "DKC-0");
                        dkcHash.put("CHB-1L - 10", "DKC-0");
                        dkcHash.put("CHB-1M - 11", "DKC-0");
                        dkcHash.put("CHB-1N - 12", "DKC-0");
                        dkcHash.put("CHB-1P - 13", "DKC-0");
                        dkcHash.put("CHB-1Q - 14", "DKC-0");
                        dkcHash.put("CHB-1R - 15", "DKC-0");
                        dkcHash.put("CHB-2A - 16", "DKC-0");
                        dkcHash.put("CHB-2B - 17", "DKC-0");
                        dkcHash.put("CHB-2C - 18", "DKC-0");
                        dkcHash.put("CHB-2D - 19", "DKC-0");
                        dkcHash.put("CHB-2E - 20", "DKC-0");
                        dkcHash.put("CHB-2F - 21", "DKC-0");
                        dkcHash.put("CHB-2G - 22", "DKC-0");
                        dkcHash.put("CHB-2H - 23", "DKC-0");
                        dkcHash.put("CHB-2J - 24", "DKC-0");
                        dkcHash.put("CHB-2K - 25", "DKC-0");
                        dkcHash.put("CHB-2L - 26", "DKC-0");
                        dkcHash.put("CHB-2M - 27", "DKC-0");
                        dkcHash.put("CHB-2N - 28", "DKC-0");
                        dkcHash.put("CHB-2P - 29", "DKC-0");
                        dkcHash.put("CHB-2Q - 30", "DKC-0");
                        dkcHash.put("CHB-2R - 31", "DKC-0");
                    } else if (modelName.contains("130")) {
                        dkcHash.put("CHB-1A - 0", "DKC-0");
                        dkcHash.put("CHB-2A - 1", "DKC-0");
                    } else if (modelName.contains("150") || modelName.contains("350")) {
                        dkcHash.put("CHB-1A - 0", "DKC-0");
                        dkcHash.put("CHB-1B - 1", "DKC-0");
                        dkcHash.put("CHB-2A - 2", "DKC-0");
                        dkcHash.put("CHB-2B - 3", "DKC-0");
                    } else if (modelName.contains("370")) {
                        dkcHash.put("CHB-1A - 0", "DKC-0");
                        dkcHash.put("CHB-1B - 1", "DKC-0");
                        dkcHash.put("CHB-2A - 16", "DKC-0");
                        dkcHash.put("CHB-2B - 17", "DKC-0");
                    } else if (modelName.contains("700")) {
                        dkcHash.put("CHB-1A - 0", "DKC-0");
                        dkcHash.put("CHB-1B - 1", "DKC-0");
                        dkcHash.put("CHB-1C - 2", "DKC-0");
                        dkcHash.put("CHB-1D - 3", "DKC-0");
                        dkcHash.put("CHB-1E - 4", "DKC-0");
                        dkcHash.put("CHB-1F - 5", "DKC-0");
                        dkcHash.put("CHB-1G - 6", "DKC-0");
                        dkcHash.put("CHB-1H - 7", "DKC-0");
                        dkcHash.put("CHB-1J - 8", "DKC-0");
                        dkcHash.put("CHB-2A - 16", "DKC-0");
                        dkcHash.put("CHB-2B - 17", "DKC-0");
                        dkcHash.put("CHB-2C - 18", "DKC-0");
                        dkcHash.put("CHB-2D - 19", "DKC-0");
                        dkcHash.put("CHB-2E - 20", "DKC-0");
                        dkcHash.put("CHB-2F - 21", "DKC-0");
                        dkcHash.put("CHB-2G - 22", "DKC-0");
                        dkcHash.put("CHB-2H - 23", "DKC-0");
                        dkcHash.put("CHB-2J - 24", "DKC-0");
                    } else if (modelName.contains("700")) {
                        dkcHash.put("CHB-1A - 0", "DKC-0");
                        dkcHash.put("CHB-1B - 1", "DKC-0");
                        dkcHash.put("CHB-1C - 2", "DKC-0");
                        dkcHash.put("CHB-1D - 3", "DKC-0");
                        dkcHash.put("CHB-1E - 4", "DKC-0");
                        dkcHash.put("CHB-1F - 5", "DKC-0");
                        dkcHash.put("CHB-1G - 6", "DKC-0");
                        dkcHash.put("CHB-1H - 7", "DKC-0");
                        dkcHash.put("CHB-1J - 8", "DKC-0");
                        dkcHash.put("CHB-1K - 9", "DKC-0");
                        dkcHash.put("CHB-1L - 10", "DKC-0");
                        dkcHash.put("CHB-1M - 11", "DKC-0");
                        dkcHash.put("CHB-2A - 16", "DKC-0");
                        dkcHash.put("CHB-2B - 17", "DKC-0");
                        dkcHash.put("CHB-2C - 18", "DKC-0");
                        dkcHash.put("CHB-2D - 19", "DKC-0");
                        dkcHash.put("CHB-2E - 20", "DKC-0");
                        dkcHash.put("CHB-2F - 21", "DKC-0");
                        dkcHash.put("CHB-2G - 22", "DKC-0");
                        dkcHash.put("CHB-2H - 23", "DKC-0");
                        dkcHash.put("CHB-2J - 24", "DKC-0");
                        dkcHash.put("CHB-2K - 25", "DKC-0");
                        dkcHash.put("CHB-2L - 26", "DKC-0");
                        dkcHash.put("CHB-2M - 27", "DKC-0");
                    } else {
                        mLogger.log(Level.SEVERE, "Unrecognized model {0}", device.getRMIObject().getSMIHm8XXModelName());
                    }
                    deviceMap.put(device.getSerialNumber(), dkcHash);
                }
            }
        }
        return dkcHash;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_DKCProcessorCardInChassis".equalsIgnoreCase(assocName.getObjectName())) {
                String tag;
                Boolean retDKC = null;
                String searchVal = "";
                RMIObjectMapping device = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("GroupComponent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                    tag = null != objectName.getKey("Tag") ? (String)objectName.getKey("Tag").getValue() : null;
                    searchVal = ProviderLibs.getEndString(tag, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    if (searchVal.equals("DKC-0") || searchVal.equals("DKC-1")) {
                        retDKC = Boolean.FALSE;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("PartComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                    tag = null != objectName.getKey("Tag") ? (String)objectName.getKey("Tag").getValue() : null;
                    searchVal = ProviderLibs.getEndString(tag, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    retDKC = Boolean.TRUE;
                }
                if (null != retDKC && searchVal.length() > 0) {
                    CHAInfo chaInfo;
                    Map<String, String> dkcHash = this.getDKCHash(device);
                    CommonClassAsList<CHAInfo> callback = new CommonClassAsList<CHAInfo>();
                    CHAInfo.getCHAInfoByCtrID(device.getRMIObject(), callback, -1);
                    LinkedList<CHAInfo> chaInfoList = callback.getReturnValue();
                    callback = null;
                    while (null != (chaInfo = chaInfoList.poll())) {
                        if (iter.isClosed()) {
                            chaInfoList.clear();
                            return;
                        }
                        String pcInfo = chaInfo.getDisplayName() + " - " + chaInfo.getChaNum();
                        String chassisID = dkcHash.get(pcInfo);
                        String ctrID = String.valueOf(chaInfo.getCtrID());
                        if (null == chassisID) continue;
                        if (Boolean.TRUE == retDKC) {
                            if (!searchVal.equalsIgnoreCase(ctrID)) continue;
                            CIMObjectPath opProcessorCard = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_StorageProcessorCard", objectName.getKeys(), objectName.getXmlSchemaName());
                            CIMObjectPath opDKCChassis = this.getReference1Instrumentation().generateObjectPath(objectName, chassisID, device.getRMIObject());
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, opDKCChassis, opProcessorCard));
                                break;
                            }
                            iter.add(this.generateInstance(objectName, propertyList, opDKCChassis, opProcessorCard));
                            break;
                        }
                        if (!searchVal.equalsIgnoreCase(chassisID)) continue;
                        CIMObjectPath opDKCChassis = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_DKCChassis", objectName.getKeys(), objectName.getXmlSchemaName());
                        CIMObjectPath opProcessorCard = this.getReference2Instrumentation().generateObjectPath(objectName, chaInfo);
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, opDKCChassis, opProcessorCard));
                            continue;
                        }
                        iter.add(this.generateInstance(objectName, propertyList, opDKCChassis, opProcessorCard));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

