/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class DKULocationInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            String expName;
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "Name", expectedValues, new String[]{"SystemName", "Name"});
            String expDKUID = null;
            String string = expName = null != expectedValues ? (String)expectedValues.get("Name") : null;
            if (null != expName) {
                expDKUID = ProviderLibs.getEndString(expName, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            }
            for (RMIObjectMapping device : devices) {
                Iterator<String> dkuIter = PDEVInfoEntry.getDKUChassisLocations(device.getSerialNumber());
                while (dkuIter.hasNext()) {
                    String dkuID = dkuIter.next();
                    if (null != expDKUID && !expDKUID.equals(dkuID)) continue;
                    if (null != refInfo) {
                        refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject(), dkuID));
                        continue;
                    }
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, device.getRMIObject(), dkuID));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, device.getRMIObject(), dkuID));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        try {
            CIMProperty[] keys = retOP.getKeys();
            String name = (String)keys[0].getValue();
            CIMProperty[] retProps = new CIMProperty[]{keys[0], keys[1], new CIMProperty("Caption", CIMDataType.STRING_T, (Object)name, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)name, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)name, false)};
            return new CIMInstance(retOP, retProps).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class, String.class}, o, "HITACHI_DKULocation");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String dkuID = (String)o[1];
        String name = rmiObj.getSMISMappingContainer().getStorageSystemName() + "." + dkuID;
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("Name", CIMDataType.STRING_T, (Object)name, true), new CIMProperty("PhysicalPosition", CIMDataType.STRING_T, (Object)name, false)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_DKULocation", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "Name");
        try {
            String nameKeyValue;
            String positionKeyValue = null != op.getKey("PhysicalPosition") ? (String)op.getKey("PhysicalPosition").getValue() : null;
            String string = nameKeyValue = null != op.getKey("Name") ? (String)op.getKey("Name").getValue() : null;
            if (null != positionKeyValue && null != nameKeyValue && positionKeyValue.equals(nameKeyValue)) {
                String dkuID = ProviderLibs.getEndString(nameKeyValue, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                if (PDEVInfoEntry.dkuChassExists(device.getSerialNumber(), dkuID)) {
                    return this.generateInstance(op, propertyList, device.getRMIObject(), dkuID);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

