/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DiskDriveStatus;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class DiskDriveInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    private static final String CPV_RANDOM_ACCESS = "Random Access";
    private static final String CPV_SUPPORTS_WRITING = "Supports Writing";

    protected static UnsignedInteger16 getDiskTypeAsUINT16(PDEVInfoEntry infoEntry) {
        int diskType = infoEntry.getDriveType() == 5 ? 3 : 2;
        return new UnsignedInteger16(diskType);
    }

    protected static UnsignedInteger16 getEncryptionAsUINT16(PDEVInfoEntry infoEntry) {
        return new UnsignedInteger16(infoEntry.getHddEncryption());
    }

    protected static UnsignedInteger16 getFormFactorAsUINT16(PDEVInfoEntry infoEntry) {
        return infoEntry.getHddDrivePhysicalSize();
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_DiskDrive", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_DiskDrive added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_DiskDrive", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_DiskDrive deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_DiskDrive", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                PDEVInfoEntry oldInfoEntry = (PDEVInfoEntry)pObj;
                PDEVInfoEntry newInfoEntry = PDEVInfoEntry.find(RMIObjectMapping.getRMIObjectMapping(oldInfoEntry.getSerialNumber()).getRMIObject(), oldInfoEntry.getCdev(), oldInfoEntry.getRdev());
                if (newInfoEntry != null) {
                    CIMInstance newInstance = this.generateInstance(op, null, newInfoEntry);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstModificationInstance(newInstance, prevInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_DiskDrive deleted indication instance", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        try {
            int expCDevNum = -1;
            int expRDevNum = -1;
            if (null != expectedValues) {
                Integer iRDevNum;
                Integer iCDevNum;
                if (1 != devices.size()) {
                    throw new WBEMException("Found " + devices.size() + " managed devices, expected 1: " + op);
                }
                Integer n = iCDevNum = null != expectedValues ? (Integer)expectedValues.get("CDevNum") : null;
                if (null != iCDevNum) {
                    expCDevNum = iCDevNum;
                }
                Integer n2 = iRDevNum = null != expectedValues ? (Integer)expectedValues.get("RDevNum") : null;
                if (null != iRDevNum) {
                    expRDevNum = iRDevNum;
                }
            }
            for (RMIObjectMapping device : devices) {
                ClosableAddableIteratorCB<PDEVInfoEntry> callback = new ClosableAddableIteratorCB<PDEVInfoEntry>();
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, expCDevNum, expRDevNum);
                CloseableAddableIterator<PDEVInfoEntry> pdevIter = callback.getWrappedCloseableAddableIter();
                while (pdevIter.hasNext()) {
                    CIMObjectPath retOP;
                    PDEVInfoEntry pdev = (PDEVInfoEntry)pdevIter.next();
                    if (null != refInfo) {
                        retOP = this.generateObjectPath(op, pdev);
                        refInfo.addReference(iter, retOP);
                        continue;
                    }
                    if (isObjectPath) {
                        retOP = this.generateObjectPath(op, pdev);
                        iter.add(retOP);
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, pdev));
                }
            }
        }
        catch (WBEMException we) {
            iter.setException(we);
            iter.close();
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, "Exception during enum operation: " + th, null, th);
            iter.setException(we);
            iter.close();
        }
        finally {
            if (iter != null && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        PDEVInfoEntry infoEntry = (PDEVInfoEntry)o[0];
        try {
            String deviceID = infoEntry.getDeviceID();
            String elementName = infoEntry.getHddLocation() + ":" + infoEntry.getCdev() + ":" + infoEntry.getRdev();
            CIMProperty[] keys = retOP.getKeys();
            DiskDriveStatus status = DiskDriveStatus.getStatus(infoEntry.getHddStatus());
            CIMProperty[] retProps = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("CDevNumber", CIMDataType.STRING_T, (Object)String.valueOf(infoEntry.getCdev()), false), new CIMProperty("RDevNumber", CIMDataType.STRING_T, (Object)String.valueOf(infoEntry.getRdev()), false), new CIMProperty("Location", CIMDataType.STRING_T, (Object)infoEntry.getHddLocation(), false), new CIMProperty("DiskType", CIMDataType.UINT16_T, (Object)DiskDriveInstrumentation.getDiskTypeAsUINT16(infoEntry), false), new CIMProperty("Capabilities", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_THREE, ProviderConstants.UINT16_FOUR}, false), new CIMProperty("CapabilityDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{CPV_RANDOM_ACCESS, CPV_SUPPORTS_WRITING}, false), new CIMProperty("MountCount", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false), new CIMProperty("TotalMountTime", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("Name", CIMDataType.STRING_T, (Object)deviceID, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(status.getOpStatus())}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{status.getStatusDescr()}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(status.getHealth()), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)elementName, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)elementName, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)(infoEntry.getFb4() + "." + infoEntry.getPg()), false), new CIMProperty("RPM", CIMDataType.UINT32_T, (Object)new UnsignedInteger32((long)infoEntry.getHddRPM()), false), new CIMProperty("FormFactor", CIMDataType.UINT16_T, (Object)DiskDriveInstrumentation.getFormFactorAsUINT16(infoEntry), false), new CIMProperty("Encryption", CIMDataType.UINT16_T, (Object)DiskDriveInstrumentation.getEncryptionAsUINT16(infoEntry), false), new CIMProperty("MaxMediaSize", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(infoEntry.getHddDiskCapacityInKBytes()), false)};
            return new CIMInstance(retOP, retProps).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{PDEVInfoEntry.class}, o, "HITACHI_DiskDrive");
        PDEVInfoEntry infoEntry = (PDEVInfoEntry)o[0];
        String systemName = RMIObjectMapping.getRMIObjectMapping(infoEntry.getSerialNumber()).getStorageSystemName();
        String deviceID = infoEntry.getDeviceID();
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_DiskDrive", true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)deviceID, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_DiskDrive", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            int[] deviceIDValues;
            String ssName;
            CIMProperty cpDeviceID = op.getKey("DeviceID");
            String cvDeviceID = (String)(cpDeviceID != null ? cpDeviceID.getValue() : null);
            CIMProperty cpCCN = op.getKey("CreationClassName");
            String cvCCN = (String)(cpCCN != null ? cpCCN.getValue() : null);
            CIMProperty cpSCCN = op.getKey("SystemCreationClassName");
            String cvSCCN = (String)(cpSCCN != null ? cpSCCN.getValue() : null);
            CIMProperty cpSystemName = op.getKey("SystemName");
            String cvSystemName = (String)(cpSystemName != null ? cpSystemName.getValue() : null);
            if (null != cvDeviceID && null != cvCCN && null != cvSCCN && null != cvSystemName && cvSystemName.equals(ssName = device.getStorageSystemName()) && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID(cvDeviceID))) {
                PDEVInfoEntry infoEntry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1]);
                return this.generateInstance(op, propertyList, infoEntry);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op != null ? op.toString() : null);
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_DiskDrive".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_DiskDrive".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM HITACHI_InstDeletion WHERE SourceInstance ISA HITACHI_DiskDrive".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM HITACHI_InstCreation WHERE SourceInstance ISA HITACHI_DiskDrive".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_DiskDrive".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM HITACHI_InstModification WHERE SourceInstance ISA HITACHI_DiskDrive".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.PDEVINFOENTRY, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.PDEVINFOENTRY, this, null);
        }
    }
}

