/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageCapabilitiesIMPL;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public final class ElementConfigurationCapabilitiesPrimordialPoolInstrumentation
extends BaseAssocInstrumentation {
    public ElementConfigurationCapabilitiesPrimordialPoolInstrumentation() {
        super("HITACHI_ElementConfigurationCapabilitiesPrimordialPool", "HITACHI_StoragePoolPrimordial", "ManagedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StoragePoolPrimordialInstrumentation"), "HITACHI_StorageConfigurationCapabilitiesOfPrimordialPool", "Capabilities", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageConfigurationCapabilitiesOfPrimordialPoolInstrumentation"));
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                CustomCloseableIterator<CIMObjectPath> ant;
                if (null != refInfo) {
                    throw new WBEMException("Association info not supported");
                }
                if (isObjectPath) {
                    ant = new CustomCloseableIterator<CIMObjectPath>();
                    this.getReference1Instrumentation().enumerate(ant, new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference1ClassName(), null), null, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, null, null);
                    this.getObjPath(ant, continueOnError, op, iter, device);
                    continue;
                }
                ant = new CustomCloseableIterator();
                this.getReference1Instrumentation().enumerate(ant, new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference1ClassName(), null), null, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, null, null);
                this.getInstance(ant, continueOnError, op, propertyList, iter, device);
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    private StorageCapabilitiesIMPL getCapabilities(String instID, String systemName, boolean isObjectPath) throws WBEMException {
        if (instID != null && instID.endsWith("Primordial")) {
            StorageCapabilitiesIMPL cap = StorageCapabilitiesIMPL.getPrimordialCaps(systemName);
            return cap;
        }
        throw new WBEMException(1, "InstanceID (" + instID + ") is invalid for " + this.getReference1ClassName());
    }

    private void getInstance(CustomCloseableIterator<CIMInstance> ants, boolean continueOnError, CIMObjectPath op, String[] propertyList, CustomCloseableIterator<?> result, RMIObjectMapping device) throws Exception {
        while (ants.hasNext()) {
            CIMInstance antInst = (CIMInstance)ants.next();
            CIMObjectPath depObj = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
            CIMInstance ret = this.generateInstance(op, propertyList, antInst.getObjectPath(), depObj);
            if (ret == null) continue;
            result.add(ret);
        }
    }

    private void getObjPath(CustomCloseableIterator<CIMObjectPath> ants, boolean continueOnError, CIMObjectPath op, CustomCloseableIterator<?> result, RMIObjectMapping device) throws Exception {
        String sysName = null;
        try {
            sysName = device.getStorageSystemName();
        }
        catch (Exception e) {
            throw new WBEMException(1, "Unable to get system name!", null, (Throwable)e);
        }
        while (ants.hasNext()) {
            CIMObjectPath antObj = (CIMObjectPath)ants.next();
            String instID = (String)antObj.getKey("InstanceID").getValue();
            StorageCapabilitiesIMPL cap = this.getCapabilities(instID, sysName, true);
            CIMObjectPath depObj = this.getReference2Instrumentation().generateObjectPath(op, cap);
            CIMObjectPath retOP = this.generateObjectPath(op, antObj, depObj);
            if (retOP == null) continue;
            result.add(retOP);
        }
    }
}

