/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class ElementStorageClientSettingDataStorageSystemInstrumentation
extends BaseAssocInstrumentation {
    protected ElementStorageClientSettingDataStorageSystemInstrumentation() {
        super("HITACHI_ElementStorageClientSettingDataStorageSystem", "HITACHI_StorageSystem", "ManagedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"), "HITACHI_StorageClientSettingData", "SettingData", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageClientSettingDataInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_ElementStorageClientSettingDataStorageSystem".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, this.createExpectedValues(device), null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    private Hashtable<String, Object> createExpectedValues(RMIObjectMapping device) throws WBEMException {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        ret.put("ElementName", device.getStorageSystemName());
        return ret;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath opStorageClientSettingData = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference2ClassName(), null);
                CustomCloseableIterator instIter = new CustomCloseableIterator();
                this.getReference2Instrumentation().enumerate(instIter, opStorageClientSettingData, new String[]{"ClientTypes"}, null, null, continueOnError, false, this.createExpectedValues(device), null);
                while (instIter.hasNext()) {
                    CIMInstance instStorageClientSetttingData = (CIMInstance)instIter.next();
                    if (null == instStorageClientSetttingData) continue;
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, opStorageSystem, instStorageClientSetttingData.getObjectPath()));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, opStorageSystem, instStorageClientSetttingData));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{CIMObjectPath.class, CIMInstance.class}, o, "HITACHI_ElementStorageClientSettingDataStorageSystem");
        CIMObjectPath opStorageSystem = (CIMObjectPath)o[0];
        CIMInstance instStorageClientSettingData = (CIMInstance)o[1];
        CIMObjectPath opAssoc = this.generateObjectPath(op, opStorageSystem, instStorageClientSettingData.getObjectPath());
        CIMProperty key1 = opAssoc.getKey(this.getReference1PropertyName());
        CIMProperty key2 = opAssoc.getKey(this.getReference2PropertyName());
        UnsignedInteger16[] clientTypes = null != instStorageClientSettingData.getPropertyValue("ClientTypes") ? (UnsignedInteger16[])instStorageClientSettingData.getPropertyValue("ClientTypes") : null;
        int isDefault = ProviderLibs.valueExist(clientTypes, 2) ? 1 : 2;
        CIMProperty[] props = new CIMProperty[]{key1, key2, new CIMProperty("IsDefault", CIMDataType.UINT16_T, (Object)(isDefault == 1 ? ProviderConstants.UINT16_ONE : ProviderConstants.UINT16_TWO), false), new CIMProperty("IsCurrent", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false)};
        return new CIMInstance(opAssoc, props).filterProperties(propList);
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opStorageClientSettingData;
            String cpnStorageSystem = this.getReference1PropertyName();
            CIMObjectPath opStorageSystem = op.getKey(cpnStorageSystem) != null ? (CIMObjectPath)op.getKey(cpnStorageSystem).getValue() : null;
            String cpnStorageClientSettingData = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opStorageClientSettingData = op.getKey(cpnStorageClientSettingData) != null ? (CIMObjectPath)op.getKey(cpnStorageClientSettingData).getValue() : null;
            if (null != opStorageClientSettingData && null != opStorageSystem) {
                String nameStorageSystem = opStorageSystem.getKey("Name") != null && opStorageSystem.getKey("Name").getValue() != null ? (String)opStorageSystem.getKey("Name").getValue() : null;
                String instIDStorageClientSettingData = opStorageClientSettingData.getKey("InstanceID") != null && opStorageClientSettingData.getKey("InstanceID").getValue() != null ? (String)opStorageClientSettingData.getKey("InstanceID").getValue() : null;
                String ssNameStorageClientSettingData = ProviderLibs.getAllButEndString(instIDStorageClientSettingData, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                if (null != nameStorageSystem && null != instIDStorageClientSettingData) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageSystem, "Name");
                    if (nameStorageSystem.equals(ssNameStorageClientSettingData) && nameStorageSystem.equals(device.getStorageSystemName())) {
                        CIMInstance instStorageClientSettingData = this.getReference2Instrumentation().getInstance(opStorageClientSettingData, null);
                        return this.generateInstance(op, propertyList, opStorageSystem, instStorageClientSettingData);
                    }
                }
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ElementStorageClientSettingDataStorageSystem".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMObjectPath opStorageClientSettingData = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                    CustomCloseableIterator instIter = new CustomCloseableIterator();
                    this.getReference2Instrumentation().enumerate(instIter, opStorageClientSettingData, new String[]{"ClientTypes"}, null, null, continueOnError, false, this.createExpectedValues(device), null);
                    while (instIter.hasNext()) {
                        CIMInstance instStorageClientSetttingData = (CIMInstance)instIter.next();
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, opStorageSystem, instStorageClientSetttingData.getObjectPath()));
                            continue;
                        }
                        iter.add(this.generateInstance(objectName, propertyList, opStorageSystem, instStorageClientSetttingData));
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMInstance instStorageClientSettingData = this.getReference2Instrumentation().getInstance(objectName, null);
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opStorageSystem, instStorageClientSettingData.getObjectPath()));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, opStorageSystem, instStorageClientSettingData));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

