/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class PhysicalDiskMediaRealizesDiskExtentInstrumentation
extends BaseAssocInstrumentation {
    protected PhysicalDiskMediaRealizesDiskExtentInstrumentation() {
        super("HITACHI_PhysicalDiskMediaRealizesDiskExtent", "HITACHI_PhysicalDiskMedia", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.PhysicalDiskMediaInstrumentation"), "HITACHI_DiskExtent", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskExtentInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_PhysicalDiskMediaRealizesDiskExtent".equalsIgnoreCase(assocName.getObjectName())) {
                PDEVInfoEntry infoEntry;
                int[] deviceIDVals = null;
                String sysName = null;
                boolean returnPhysicalDiskMedia = false;
                RMIObjectMapping device = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent")) && (null == resultRole || resultRole.equalsIgnoreCase("Dependent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        String cvTag;
                        device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                        CIMProperty cpTag = objectName.getKey("Tag");
                        String string = cvTag = cpTag != null ? (String)cpTag.getValue() : null;
                        if (null != cvTag) {
                            String[] retSysName = new String[1];
                            deviceIDVals = PDEVInfoEntry.parseTag(cvTag, retSysName);
                            sysName = retSysName[0];
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                    CIMProperty cpSystemName = objectName.getKey("SystemName");
                    String deviceID = cpDeviceID != null ? (String)cpDeviceID.getValue() : null;
                    deviceIDVals = PDEVInfoEntry.parseDeviceID(deviceID);
                    sysName = cpSystemName != null ? (String)cpSystemName.getValue() : null;
                    returnPhysicalDiskMedia = true;
                }
                if (null != device && null != deviceIDVals && null != sysName && sysName.equals(device.getStorageSystemName()) && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), (int)deviceIDVals[0], (int)deviceIDVals[1])) != null) {
                    if (returnPhysicalDiskMedia) {
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, infoEntry));
                        } else {
                            CIMInstance instPhysicalDiskMedia = this.getReference1Instrumentation().generateInstance(objectName, propertyList, infoEntry);
                            iter.add(instPhysicalDiskMedia.filterProperties(propertyList));
                        }
                    } else if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, infoEntry));
                    } else {
                        CIMInstance instDiskExtent = this.getReference2Instrumentation().generateInstance(objectName, propertyList, infoEntry);
                        iter.add(instDiskExtent.filterProperties(propertyList));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackIMPL<PDEVInfoEntry> callback = new CallbackIMPL<PDEVInfoEntry>(deviceIter, isObjectPath, refInfo, op, propertyList);
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opDiskExtent;
            String pnPhysicalDiskMedia = this.getReference1PropertyName();
            CIMObjectPath opPhysicalDiskMedia = op.getKey(pnPhysicalDiskMedia) != null ? (CIMObjectPath)op.getKey(pnPhysicalDiskMedia).getValue() : null;
            String pnDiskExtent = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opDiskExtent = op.getKey(pnDiskExtent) != null ? (CIMObjectPath)op.getKey(pnDiskExtent).getValue() : null;
            if (null != opPhysicalDiskMedia && null != opDiskExtent && this.getReference1Instrumentation().instanceExists(opPhysicalDiskMedia) && this.getReference2Instrumentation().instanceExists(opDiskExtent)) {
                PDEVInfoEntry infoEntry;
                String tag;
                CIMProperty cpDiskExtentSystemName;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opDiskExtent, "SystemName");
                CIMProperty cpDiskExtentDeviceID = opDiskExtent.getKey("DeviceID");
                int[] diskExtentDeviceIDVals = null;
                if (null != cpDiskExtentDeviceID) {
                    diskExtentDeviceIDVals = PDEVInfoEntry.parseDeviceID((String)cpDiskExtentDeviceID.getValue());
                }
                String cvDiskExtentSystemName = null != (cpDiskExtentSystemName = opDiskExtent.getKey("SystemName")) ? (String)cpDiskExtentSystemName.getValue() : null;
                int[] physicalDiskMediaDeviceVals = null;
                String cvPhysicalDiskMediaSystemName = null;
                CIMProperty cpPhysicalDiskMediaTag = opPhysicalDiskMedia.getKey("Tag");
                String string = tag = null != cpPhysicalDiskMediaTag ? (String)cpPhysicalDiskMediaTag.getValue() : null;
                if (null != tag) {
                    String[] systemName = new String[1];
                    physicalDiskMediaDeviceVals = PDEVInfoEntry.parseTag(tag, systemName);
                    cvPhysicalDiskMediaSystemName = systemName[0];
                }
                if (null != cvPhysicalDiskMediaSystemName && null != cvDiskExtentSystemName && null != physicalDiskMediaDeviceVals && null != diskExtentDeviceIDVals && cvPhysicalDiskMediaSystemName.equals(cvDiskExtentSystemName) && cvPhysicalDiskMediaSystemName.equals(device.getStorageSystemName()) && physicalDiskMediaDeviceVals[0] == diskExtentDeviceIDVals[0] && physicalDiskMediaDeviceVals[1] == diskExtentDeviceIDVals[1] && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), diskExtentDeviceIDVals[0], diskExtentDeviceIDVals[1])) != null) {
                    opPhysicalDiskMedia = this.getReference1Instrumentation().generateObjectPath(op, infoEntry);
                    opDiskExtent = this.getReference2Instrumentation().generateObjectPath(op, infoEntry);
                    CIMInstance instAssoc = this.generateInstance(op, propertyList, opPhysicalDiskMedia, opDiskExtent);
                    return instAssoc.filterProperties(propertyList);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_PhysicalDiskMediaRealizesDiskExtent".equalsIgnoreCase(assocName.getObjectName())) {
                PDEVInfoEntry infoEntry;
                int[] deviceIDVals = null;
                String sysName = null;
                RMIObjectMapping device = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        String cvTag;
                        device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                        CIMProperty cpTag = objectName.getKey("Tag");
                        String string = cvTag = cpTag != null ? (String)cpTag.getValue() : null;
                        if (null != cvTag) {
                            String[] retSysName = new String[1];
                            deviceIDVals = PDEVInfoEntry.parseTag(cvTag, retSysName);
                            sysName = retSysName[0];
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                    CIMProperty cpSystemName = objectName.getKey("SystemName");
                    String deviceID = cpDeviceID != null ? (String)cpDeviceID.getValue() : null;
                    deviceIDVals = PDEVInfoEntry.parseDeviceID(deviceID);
                    String string = sysName = cpSystemName != null ? (String)cpSystemName.getValue() : null;
                }
                if (null == device) {
                    throw new WBEMException("Unable to get Connection to backend for system name: " + sysName);
                }
                if (null != deviceIDVals && null != sysName && sysName.equals(device.getStorageSystemName()) && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), (int)deviceIDVals[0], (int)deviceIDVals[1])) != null) {
                    CIMObjectPath opPhysicalDiskMedia = this.getReference1Instrumentation().generateObjectPath(objectName, infoEntry);
                    CIMObjectPath opDiskExtent = this.getReference2Instrumentation().generateObjectPath(objectName, infoEntry);
                    CIMInstance instAssoc = this.generateInstance(objectName, propertyList, opPhysicalDiskMedia, opDiskExtent);
                    if (isObjectPath) {
                        iter.add(instAssoc.getObjectPath());
                    } else {
                        iter.add(instAssoc.filterProperties(propertyList));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    public class CallbackIMPL<E extends PDEVInfoEntry>
    extends IteratorCallbackIMPL<E> {
        public CallbackIMPL(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block5: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E entry = item;
                        CIMObjectPath opPhysicalDiskMedia = PhysicalDiskMediaRealizesDiskExtentInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, entry);
                        CIMObjectPath opDiskExtent = PhysicalDiskMediaRealizesDiskExtentInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, entry);
                        CIMInstance instAssoc = PhysicalDiskMediaRealizesDiskExtentInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, opPhysicalDiskMedia, opDiskExtent);
                        if (this.mIsObjectPath) {
                            this.mIter.add(instAssoc.getObjectPath());
                            break block5;
                        }
                        this.mIter.add(instAssoc.filterProperties(this.mPropertyList));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                        ret = false;
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

