/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.LUPathObject;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class SCSIPCForSCSIArbitraryLogicalUnitInstrumentation
extends BaseAssocInstrumentation
implements CacheUpdateNotifier {
    protected SCSIPCForSCSIArbitraryLogicalUnitInstrumentation() {
        super("HITACHI_SCSIPCForSCSIArbitraryLogicalUnit", "HITACHI_SCSIProtocolController", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolControllerInstrumentation"), "HITACHI_SCSIArbitraryLogicalUnit", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIArbitraryLogicalUnitInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            String cnSCSIPC = this.getReference1ClassName();
            String cnSCSIArbitraryLogicalUnit = this.getReference2ClassName();
            String pnSCSIPC = this.getReference1PropertyName();
            String pnSCSIArbitraryLogicalUnit = this.getReference2PropertyName();
            if (null != assocName && "HITACHI_SCSIPCForSCSIArbitraryLogicalUnit".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(cnSCSIPC) && (null == role || role.equalsIgnoreCase(pnSCSIPC)) && (null == resultRole || resultRole.equalsIgnoreCase(pnSCSIArbitraryLogicalUnit))) {
                    if (!shouldTestInst || this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        short sPortID = -1;
                        short sHostGroupID = -1;
                        CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                        if (null != cpDeviceID) {
                            String cvDeviceID = (String)cpDeviceID.getValue();
                            String portID = ProviderLibs.getAllButEndString(cvDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                            String hostGroup = ProviderLibs.getEndString(cvDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                            try {
                                sPortID = Short.parseShort(portID);
                                sHostGroupID = Short.parseShort(hostGroup);
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                        }
                        if (-1 != sPortID && -1 != sHostGroupID) {
                            CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                            LUPathObject.getLUPaths(device.getRMIObject(), callback, sPortID);
                            LinkedList<LUPathObject> luPaths = callback.getReturnValue();
                            callback = null;
                            LUPathObject luPath = luPaths.poll();
                            while (luPath != null) {
                                if (sHostGroupID == luPath.getSHostGrp()) {
                                    short ldkc = luPath.getDKC();
                                    short cu = luPath.getCU();
                                    short ldev = luPath.getLDEV();
                                    long dn = BaseDeviceNumber.makeUniqueDN(ldkc, cu, ldev);
                                    Hashtable<String, Object> expectedValues = this.getReference2SearchProperties(objectName);
                                    String deviceID = String.valueOf(dn);
                                    expectedValues.put("DeviceID", deviceID);
                                    CustomCloseableIterator iterSCSIArbitraryLogicalUnit = isObjectPath ? new CustomCloseableIterator() : new CustomCloseableIterator();
                                    this.getReference2Instrumentation().enumerate(iterSCSIArbitraryLogicalUnit, objectName, propertyList, null, null, continueOnError, isObjectPath, expectedValues, null);
                                    while (iterSCSIArbitraryLogicalUnit.hasNext()) {
                                        if (isObjectPath) {
                                            iter.add((CIMObjectPath)iterSCSIArbitraryLogicalUnit.next());
                                            continue;
                                        }
                                        iter.add((CIMInstance)iterSCSIArbitraryLogicalUnit.next());
                                    }
                                }
                                luPath = luPaths.poll();
                            }
                        }
                    }
                } else if (!(!objectName.getObjectName().equalsIgnoreCase(cnSCSIArbitraryLogicalUnit) || null != role && !role.equalsIgnoreCase(pnSCSIArbitraryLogicalUnit) || null != resultRole && !resultRole.equalsIgnoreCase(pnSCSIPC) || shouldTestInst && !this.getReference2Instrumentation().instanceExists(objectName))) {
                    short[] deviceIDValues;
                    String deviceID;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                    if (null != cpDeviceID && null != (deviceID = (String)cpDeviceID.getValue()) && -1 != (deviceIDValues = BaseDeviceNumber.getDevIdStringValues(deviceID))[0] && -1 != deviceIDValues[1] && -1 != deviceIDValues[2]) {
                        CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                        LUPathObject.getLUPaths(device.getRMIObject(), callback, deviceIDValues[0], deviceIDValues[1], deviceIDValues[2]);
                        LinkedList<LUPathObject> luPaths = callback.getReturnValue();
                        LUPathObject luPath = luPaths.poll();
                        while (luPath != null) {
                            short portID = luPath.getSPort();
                            short domainID = luPath.getSHostGrp();
                            short ctrID = PortandHostGroupInfo.getCtrIDUsingPortID(portID, device.getSerialNumber());
                            String spcDeviceID = portID + "." + domainID;
                            String spcSystemName = device.getStorageSystemName() + "." + ctrID;
                            Hashtable<String, Object> expectedValues = new Hashtable<String, Object>();
                            expectedValues.put("DeviceID", spcDeviceID);
                            expectedValues.put("ElementName", spcSystemName);
                            CustomCloseableIterator iterSCSIPC = isObjectPath ? new CustomCloseableIterator() : new CustomCloseableIterator();
                            this.getReference1Instrumentation().enumerate(iterSCSIPC, objectName, propertyList, null, null, continueOnError, isObjectPath, expectedValues, null);
                            while (iterSCSIPC.hasNext()) {
                                if (isObjectPath) {
                                    iter.add((CIMObjectPath)iterSCSIPC.next());
                                    continue;
                                }
                                iter.add((CIMInstance)iterSCSIPC.next());
                            }
                            luPath = luPaths.poll();
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                LUPathObject luPath = (LUPathObject)pObj;
                DeviceNumber dn = luPath.getDeviceNumber();
                if (null != dn && dn.isCommandDevice()) {
                    CIMObjectPath opNamespace = new CIMObjectPath(null, null, null, ProviderLibs.getImplementationNamespace(), "", null);
                    short ctrID = PortandHostGroupInfo.getCtrIDUsingPortID(luPath.getSPort(), luPath.getSerialNumber());
                    PortandHostGroupInfo pghi = ProviderLibs.checkForPortNHostGrp(ctrID, luPath);
                    CIMObjectPath opSCSIPC = this.getReference1Instrumentation().generateObjectPath(opNamespace, pghi);
                    CIMObjectPath opSCSIArbitraryLU = this.getReference2Instrumentation().generateObjectPath(opNamespace, dn);
                    CIMInstance sourceInstance = this.generateInstance(opNamespace, opSCSIPC, opSCSIArbitraryLU, dn.getDNAsString());
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIPCForSCSIArbitraryLogicalUnit added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                LUPathObject luPath = (LUPathObject)pObj;
                DeviceNumber dn = luPath.getDeviceNumber();
                if (null != dn && dn.isCommandDevice()) {
                    CIMObjectPath opNamespace = new CIMObjectPath(null, null, null, ProviderLibs.getImplementationNamespace(), "", null);
                    short ctrID = PortandHostGroupInfo.getCtrIDUsingPortID(luPath.getSPort(), luPath.getSerialNumber());
                    PortandHostGroupInfo pghi = ProviderLibs.checkForPortNHostGrp(ctrID, luPath);
                    CIMObjectPath opSCSIPC = this.getReference1Instrumentation().generateObjectPath(opNamespace, pghi);
                    CIMObjectPath opSCSIArbitraryLU = this.getReference2Instrumentation().generateObjectPath(opNamespace, dn);
                    CIMInstance sourceInstance = this.generateInstance(opNamespace, opSCSIPC, opSCSIArbitraryLU, luPath.getLunString());
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIPCForSCSIArbitraryLogicalUnit deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            for (RMIObjectMapping device : devices) {
                CallbackHandler<PortandHostGroupInfo> callback = new CallbackHandler<PortandHostGroupInfo>(deviceIter, isObjectPath, refInfo, op, propertyList);
                PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), callback, device.getStorageSystemName(), false, continueOnError);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    public CIMInstance generateInstance(CIMObjectPath opObjectName, CIMObjectPath opSCSIPC, CIMObjectPath opSCSIArbitraryLogicalUnit, String lunDN) throws Exception {
        CIMObjectPath opAssoc = this.generateObjectPath(opObjectName, opSCSIPC, opSCSIArbitraryLogicalUnit);
        CIMProperty cpOpSCSIPC = opAssoc.getKey(this.getReference1PropertyName());
        CIMProperty cpOpSCSIArbitraryLogicalUnit = opAssoc.getKey(this.getReference2PropertyName());
        UnsignedInteger16 deviceAccess = ProviderConstants.UINT16_TWO;
        CIMProperty[] props = new CIMProperty[]{cpOpSCSIPC, cpOpSCSIArbitraryLogicalUnit, new CIMProperty("DeviceAccess", CIMDataType.UINT16_T, (Object)deviceAccess, false), new CIMProperty("DeviceNumber", CIMDataType.STRING_T, (Object)lunDN, false)};
        return new CIMInstance(opAssoc, props);
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block10: {
            try {
                String cvSCSIArbitraryLogicalUnitDeviceID;
                CIMObjectPath opSCSIArbitraryLogicalUnit;
                String pnSCSIPC = this.getReference1PropertyName();
                CIMObjectPath opSCSIPC = opObjectName.getKey(pnSCSIPC) != null ? (CIMObjectPath)opObjectName.getKey(pnSCSIPC).getValue() : null;
                String pnSCSIArbitraryLogicalUnit = this.getReference2PropertyName();
                CIMObjectPath cIMObjectPath = opSCSIArbitraryLogicalUnit = opObjectName.getKey(pnSCSIArbitraryLogicalUnit) != null ? (CIMObjectPath)opObjectName.getKey(pnSCSIArbitraryLogicalUnit).getValue() : null;
                if (null == opSCSIPC || null == opSCSIArbitraryLogicalUnit) break block10;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opSCSIPC, "SystemName");
                short sPort = -1;
                short sHostGroup = -1;
                CIMInstance instSCSIPC = this.getReference1Instrumentation().getInstance(opSCSIPC, null);
                CIMInstance instSCSIArbitraryLogicalUnit = this.getReference2Instrumentation().getInstance(opSCSIArbitraryLogicalUnit, null);
                CIMProperty cpSCSIPCDeviceID = opSCSIPC.getKey("DeviceID");
                CIMProperty cpSCSIPCSystemName = opSCSIPC.getKey("SystemName");
                CIMProperty cpSCSIArbitraryLogicalUnitDeviceID = opSCSIArbitraryLogicalUnit.getKey("DeviceID");
                String string = cvSCSIArbitraryLogicalUnitDeviceID = null != cpSCSIArbitraryLogicalUnitDeviceID ? (String)cpSCSIArbitraryLogicalUnitDeviceID.getValue() : null;
                if (null != cpSCSIPCDeviceID && null != cpSCSIPCSystemName) {
                    String cvSCSIPCDeviceID = (String)cpSCSIPCDeviceID.getValue();
                    String port = ProviderLibs.getAllButEndString(cvSCSIPCDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    String hostGroup = ProviderLibs.getEndString(cvSCSIPCDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    try {
                        sPort = Short.parseShort(port);
                        sHostGroup = Short.parseShort(hostGroup);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                if (-1 != sPort && -1 != sHostGroup) {
                    CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                    LUPathObject.getLUPaths(device.getRMIObject(), callback, sPort);
                    LinkedList<LUPathObject> luPaths = callback.getReturnValue();
                    callback = null;
                    LUPathObject luPath = luPaths.poll();
                    while (luPath != null) {
                        short ldev;
                        short cu;
                        short ldkc;
                        String dn;
                        if (sHostGroup == luPath.getSHostGrp() && (dn = String.valueOf(BaseDeviceNumber.makeUniqueDN(ldkc = luPath.getDKC(), cu = luPath.getCU(), ldev = luPath.getLDEV()))).equals(cvSCSIArbitraryLogicalUnitDeviceID)) {
                            String lunDN = luPath.getLunString();
                            CIMInstance instAssoc = this.generateInstance(opObjectName, instSCSIPC.getObjectPath(), instSCSIArbitraryLogicalUnit.getObjectPath(), lunDN);
                            return instAssoc.filterProperties(propertyList);
                        }
                        luPath = luPaths.poll();
                    }
                }
            }
            catch (WBEMException we) {
                if (we.getID() == 6) {
                    throw new WBEMException(6, opObjectName.toString());
                }
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opRef1) {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        CIMProperty cpSysName = opRef1.getKey("SystemName");
        ret.put("SystemName", null != cpSysName ? (String)cpSysName.getValue() : null);
        return ret;
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_ProtocolControllerForUnit".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_ProtocolControllerForUnit".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_ProtocolControllerForUnit".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM HITACHI_InstCreation WHERE SourceInstance ISA HITACHI_SCSIPCForSCSIArbitraryLogicalUnit".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM HITACHI_InstDeletion WHERE SourceInstance ISA HITACHI_SCSIPCForSCSIArbitraryLogicalUnit".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM HITACHI_InstModification WHERE SourceInstance ISA HITACHI_SCSIPCForSCSIArbitraryLogicalUnit".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.LUPATH, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.LUPATH, this, null);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            String cnSCSIPC = this.getReference1ClassName();
            String cnSCSIArbitraryLogicalUnit = this.getReference2ClassName();
            String pnSCSIPC = this.getReference1PropertyName();
            String pnSCSIArbitraryLogicalUnit = this.getReference2PropertyName();
            if (null != assocName && "HITACHI_SCSIPCForSCSIArbitraryLogicalUnit".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(cnSCSIPC) && (null == role || role.equalsIgnoreCase(pnSCSIPC))) {
                    CIMInstance instSCSIPC = null;
                    try {
                        instSCSIPC = this.getReference1Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException e) {
                        instSCSIPC = null;
                    }
                    if (null != instSCSIPC) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        short sPortID = -1;
                        short sHostGroupID = -1;
                        CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                        if (null != cpDeviceID) {
                            String cvDeviceID = (String)cpDeviceID.getValue();
                            String portID = ProviderLibs.getAllButEndString(cvDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                            String hostGroup = ProviderLibs.getEndString(cvDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                            try {
                                sPortID = Short.parseShort(portID);
                                sHostGroupID = Short.parseShort(hostGroup);
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                        }
                        if (-1 != sPortID && -1 != sHostGroupID) {
                            CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                            LUPathObject.getLUPaths(device.getRMIObject(), callback, sPortID);
                            LinkedList<LUPathObject> luPaths = callback.getReturnValue();
                            callback = null;
                            LUPathObject luPath = luPaths.poll();
                            while (luPath != null) {
                                if (sHostGroupID == luPath.getSHostGrp()) {
                                    short ldkc = luPath.getDKC();
                                    short cu = luPath.getCU();
                                    short ldev = luPath.getLDEV();
                                    long dn = BaseDeviceNumber.makeUniqueDN(ldkc, cu, ldev);
                                    String lunDN = luPath.getLunString();
                                    Hashtable<String, Object> expectedValues = this.getReference2SearchProperties(objectName);
                                    String deviceID = String.valueOf(dn);
                                    expectedValues.put("DeviceID", deviceID);
                                    CustomCloseableIterator iterSCSIArbitraryLogicalUnit = new CustomCloseableIterator();
                                    this.getReference2Instrumentation().enumerate(iterSCSIArbitraryLogicalUnit, objectName, null, null, null, continueOnError, true, expectedValues, null);
                                    while (iterSCSIArbitraryLogicalUnit.hasNext()) {
                                        if (isObjectPath) {
                                            iter.add(this.generateObjectPath(objectName, instSCSIPC.getObjectPath(), iterSCSIArbitraryLogicalUnit.next()));
                                            continue;
                                        }
                                        CIMInstance instAssoc = this.generateInstance(objectName, instSCSIPC.getObjectPath(), (CIMObjectPath)iterSCSIArbitraryLogicalUnit.next(), lunDN);
                                        iter.add(instAssoc.filterProperties(propertyList));
                                    }
                                }
                                luPath = luPaths.poll();
                            }
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(cnSCSIArbitraryLogicalUnit) && (null == role || role.equalsIgnoreCase(pnSCSIArbitraryLogicalUnit))) {
                    CIMInstance instSCSIArbitraryLogicalUnit = null;
                    try {
                        instSCSIArbitraryLogicalUnit = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException e) {
                        instSCSIArbitraryLogicalUnit = null;
                    }
                    if (null != instSCSIArbitraryLogicalUnit) {
                        short[] deviceIDValues;
                        String deviceID;
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                        if (null != cpDeviceID && null != (deviceID = (String)cpDeviceID.getValue()) && -1 != (deviceIDValues = BaseDeviceNumber.getDevIdStringValues(deviceID))[0] && -1 != deviceIDValues[1] && -1 != deviceIDValues[2]) {
                            CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                            LUPathObject.getLUPaths(device.getRMIObject(), callback, deviceIDValues[0], deviceIDValues[1], deviceIDValues[2]);
                            LinkedList<LUPathObject> luPaths = callback.getReturnValue();
                            LUPathObject luPath = luPaths.poll();
                            while (luPath != null) {
                                short portID = luPath.getSPort();
                                short domainID = luPath.getSHostGrp();
                                short ctrID = PortandHostGroupInfo.getCtrIDUsingPortID(portID, device.getSerialNumber());
                                String lunDN = luPath.getLunString();
                                String spcDeviceID = portID + "." + domainID;
                                String spcSystemName = device.getStorageSystemName() + "." + ctrID;
                                Hashtable<String, Object> expectedValues = new Hashtable<String, Object>();
                                expectedValues.put("DeviceID", spcDeviceID);
                                expectedValues.put("ElementName", spcSystemName);
                                CustomCloseableIterator iterSCSIPC = new CustomCloseableIterator();
                                this.getReference1Instrumentation().enumerate(iterSCSIPC, objectName, propertyList, null, null, continueOnError, true, expectedValues, null);
                                while (iterSCSIPC.hasNext()) {
                                    if (isObjectPath) {
                                        iter.add(this.generateObjectPath(objectName, iterSCSIPC.next(), instSCSIArbitraryLogicalUnit.getObjectPath()));
                                        continue;
                                    }
                                    CIMInstance instAssoc = this.generateInstance(objectName, (CIMObjectPath)iterSCSIPC.next(), instSCSIArbitraryLogicalUnit.getObjectPath(), lunDN);
                                    iter.add(instAssoc.filterProperties(propertyList));
                                }
                                luPath = luPaths.poll();
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
    }

    private class CallbackHandler<E extends PortandHostGroupInfo>
    extends IteratorCallbackIMPL<E> {
        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (!this.mIter.isClosed()) {
                try {
                    E hostGroupInfo = item;
                    RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(((AbstractBaseCommonObject)hostGroupInfo).getSerialNumber());
                    short port = ((PortandHostGroupInfo)hostGroupInfo).getPortID();
                    short hostGroup = ((PortandHostGroupInfo)hostGroupInfo).getHostgroupID();
                    BaseInstrumentation.mLogger.info("Looking up LUPath PortID:HostGroupID" + port + ":" + hostGroup);
                    CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                    LUPathObject.getLUPaths(device.getRMIObject(), callback, port);
                    LinkedList<LUPathObject> luPaths = callback.getReturnValue();
                    callback = null;
                    BaseInstrumentation.mLogger.info("Found " + luPaths.size() + " LUPaths for port");
                    LUPathObject luPath = luPaths.poll();
                    while (luPath != null) {
                        BaseInstrumentation.mLogger.info("Seeing if hostGroup(" + hostGroup + ") equal luPath hostGroup(" + luPath.getSHostGrp() + ")");
                        if (hostGroup == luPath.getSHostGrp()) {
                            short ldkc = luPath.getDKC();
                            short cu = luPath.getCU();
                            short ldev = luPath.getLDEV();
                            String lunDN = luPath.getLunString();
                            CIMObjectPath opSCSIpc = SCSIPCForSCSIArbitraryLogicalUnitInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, hostGroupInfo);
                            Hashtable<String, Object> expectedValues = SCSIPCForSCSIArbitraryLogicalUnitInstrumentation.this.getReference2SearchProperties(opSCSIpc);
                            long dn = BaseDeviceNumber.makeUniqueDN(ldkc, cu, ldev);
                            String deviceID = String.valueOf(dn);
                            expectedValues.put("DeviceID", deviceID);
                            CIMObjectPath opSCSIPC = SCSIPCForSCSIArbitraryLogicalUnitInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, hostGroupInfo);
                            CustomCloseableIterator iterSCSIArbitraryLogicalUnit = new CustomCloseableIterator();
                            BaseInstrumentation.mLogger.info("Calling " + SCSIPCForSCSIArbitraryLogicalUnitInstrumentation.this.getReference2ClassName() + " looking for DeviceNumber: " + deviceID);
                            SCSIPCForSCSIArbitraryLogicalUnitInstrumentation.this.getReference2Instrumentation().enumerate(iterSCSIArbitraryLogicalUnit, this.mOP, null, null, null, false, true, expectedValues, null);
                            BaseInstrumentation.mLogger.info((iterSCSIArbitraryLogicalUnit.hasNext() ? "Found" : "Did not find") + " instances of " + SCSIPCForSCSIArbitraryLogicalUnitInstrumentation.this.getReference2ClassName());
                            while (iterSCSIArbitraryLogicalUnit.hasNext()) {
                                CIMObjectPath opSCSIArbitraryLogicalUnit = (CIMObjectPath)iterSCSIArbitraryLogicalUnit.next();
                                if (this.mIsObjectPath) {
                                    this.mIter.add(SCSIPCForSCSIArbitraryLogicalUnitInstrumentation.this.generateObjectPath(this.mOP, opSCSIPC, opSCSIArbitraryLogicalUnit));
                                    continue;
                                }
                                CIMInstance ci = SCSIPCForSCSIArbitraryLogicalUnitInstrumentation.this.generateInstance(this.mOP, opSCSIPC, opSCSIArbitraryLogicalUnit, lunDN);
                                this.mIter.add(ci.filterProperties(this.mPropertyList));
                            }
                        } else {
                            BaseInstrumentation.mLogger.info("No match, getting next luPath");
                        }
                        luPath = luPaths.poll();
                    }
                }
                catch (Throwable thrown) {
                    WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
                finally {
                    if (!this.mIter.isDone()) {
                        this.mIter.done();
                    }
                }
            } else {
                ret = false;
            }
            return ret;
        }
    }
}

