/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.StorageCapabilitiesInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class StorageCapabilitiesOfImportedPrimordialPoolInstrumentation
extends StorageCapabilitiesInstrumentation {
    private static final String CV_GENERAL = "StorageCapabilitiesOfImportedPrimordialPool";

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
        try {
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                CIMInstance ci = this.generateInstance(op, propertyList, device.getRMIObject());
                iter.add(ci);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    protected Object extrinsic_GetSupportedStripeDepths(CIMObjectPath op, CIMArgument<?>[] outArgs) throws WBEMException {
        outArgs[0] = new CIMArgument("StripeDepths", CIMDataType.UINT64_ARRAY_T, (Object)new UnsignedInteger64[0]);
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        return ret;
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        UnsignedInteger16 cvDelta = new UnsignedInteger16(100);
        UnsignedInteger16 cvPackage = ProviderConstants.UINT16_ZED;
        UnsignedInteger16 cvData = ProviderConstants.UINT16_ONE;
        CIMProperty[] props = new CIMProperty[]{retOP.getKey("InstanceID"), new CIMProperty("ElementType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("NoSinglePointOfFailureDefault", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)cvData, false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)cvData, false), new CIMProperty("DataRedundancyDefault", CIMDataType.UINT16_T, (Object)cvData, false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)cvPackage, false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)cvPackage, false), new CIMProperty("PackageRedundancyDefault", CIMDataType.UINT16_T, (Object)cvPackage, false), new CIMProperty("DeltaReservationMax", CIMDataType.UINT16_T, (Object)cvDelta, false), new CIMProperty("DeltaReservationMin", CIMDataType.UINT16_T, (Object)cvDelta, false), new CIMProperty("DeltaReservationDefault", CIMDataType.UINT16_T, (Object)cvDelta, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)CV_GENERAL, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)CV_GENERAL, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)CV_GENERAL, false), new CIMProperty("SupportedDataOrganizations", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("SupportedExtentTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_StorageCapabilitiesOfImportedPrimordialPool");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String id = rmiObj.getSMISMappingContainer().getStorageSystemName() + ".ImportedPrimordial";
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)id, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageCapabilitiesOfImportedPrimordialPool", keys);
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            CIMInstance ci = this.generateInstance(op, propertyList, device.getRMIObject());
            if (op.equalsModelPath(ci.getObjectPath())) {
                return ci;
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    protected Object extrinsic_GetSupportedParityLayouts(CIMObjectPath op, CIMArgument<?>[] outArgs) throws WBEMException {
        outArgs[0] = new CIMArgument("ParityLayout", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0]);
        return ProviderConstants.UINT32_TWO;
    }

    @Override
    protected Object GetSupportedParityLengthsHelper(CIMObjectPath op, CIMArgument<?>[] outArgs, boolean doParity) throws WBEMException {
        outArgs[0] = new CIMArgument(doParity ? "ParityLayout" : "StripeLengths", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0]);
        return ProviderConstants.UINT32_TWO;
    }

    @Override
    protected UnsignedInteger32 GetSupportedStripeXXXRange(CIMObjectPath op, CIMArgument<?>[] outArgs, boolean doDepth) throws WBEMException {
        outArgs[0] = new CIMArgument("MinimumStripeDepth", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        outArgs[1] = new CIMArgument("MaximumStripeDepth", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        outArgs[2] = new CIMArgument("StripeDepthDivisor", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        UnsignedInteger32 ret = doDepth ? ProviderConstants.UINT32_TWO : ProviderConstants.UINT32_THREE;
        return ret;
    }
}

