/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.ProviderProperties;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageCapabilitiesIMPL;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.StorageCapabilitiesInstrumentation;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_PPKgetKeyLicenseStatus;
import sanproject.serverux.data.SANRmiException;

public class StorageCapabilitiesOfThinProvisioningPoolInstrumentation
extends StorageCapabilitiesInstrumentation {
    private static final String DEFAULT = "Default";
    private static final String CPN_NOSINGLEPOINTOFFAILURE_DEFAULT = "NoSinglePointOfFailureDefault";
    private static final String CPN_DATAREDUNDANCY_DEFAULT = "DataRedundancyDefault";
    private static final String CPN_PACKAGEREDUNDANCY_DEFAULT = "PackageRedundancyDefault";
    private static final String CPN_DELTARESERVATION_DEFAULT = "DeltaReservationDefault";
    private static final String CPN_EXTENTSTRIPELENGTH_DEFAULT = "ExtentStripeLengthDefault";
    private static final String CPN_PARITYLAYOUT_DEFAULT = "ParityLayoutDefault";
    private static UnsignedInteger16 UINT16_100 = new UnsignedInteger16(100);
    private static volatile Boolean isDedupActive = Boolean.FALSE;
    private static long lastLicenseChkTime = -1L;
    private static volatile long chkInterval = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StorageCapabilitiesOfThinProvisioningPoolInstrumentation() {
        long t = chkInterval;
        if (-1L != t) return;
        Class<StorageCapabilitiesOfThinProvisioningPoolInstrumentation> clazz = StorageCapabilitiesOfThinProvisioningPoolInstrumentation.class;
        synchronized (StorageCapabilitiesOfThinProvisioningPoolInstrumentation.class) {
            t = chkInterval;
            if (-1L == t) {
                try {
                    t = ProviderProperties.getLicenseCheckIntervalSeconds() * 1000;
                }
                catch (WBEMException e) {
                    mLogger.log(Level.SEVERE, "Failed to get license check interval, default to 30 seconds", e);
                    t = 30L;
                }
            }
            chkInterval = t;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
        try {
            String expVal;
            short poolID = -1;
            if (expectedValues != null && (expVal = (String)expectedValues.get("InstanceID")) != null) {
                String val = ProviderLibs.getEndString(expVal, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                poolID = Short.parseShort(val);
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ThinPool> callback = new CallbackHandler<ThinPool>(deviceIter, isObjectPath, refInfo, op, propertyList, poolID, device.getStorageSystemName());
                ThinPool.getThinPools(device.getRMIObject(), callback, poolID, true);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    protected Object extrinsic_GetSupportedParityLayouts(CIMObjectPath op, CIMArgument<?>[] outArgs) throws WBEMException {
        outArgs[0] = new CIMArgument("ParityLayout", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0]);
        return ProviderConstants.UINT32_TWO;
    }

    @Override
    protected Object extrinsic_GetSupportedStripeDepthRange(CIMObjectPath op, CIMArgument<?>[] outArgs) {
        outArgs[0] = new CIMArgument("MinimumStripeDepth", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        outArgs[1] = new CIMArgument("MaximumStripeDepth", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        outArgs[2] = new CIMArgument("StripeDepthDivisor", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        return ProviderConstants.UINT32_TWO;
    }

    @Override
    protected Object extrinsic_GetSupportedStripeDepths(CIMObjectPath op, CIMArgument<?>[] outArgs) {
        outArgs[0] = new CIMArgument("StripeDepths", CIMDataType.UINT64_ARRAY_T, (Object)new UnsignedInteger64[0]);
        return ProviderConstants.UINT32_ZED;
    }

    @Override
    protected UnsignedInteger32 extrinsic_GetSupportedStripeLengthRange(CIMObjectPath op, CIMArgument<?>[] outArgs) {
        outArgs[0] = new CIMArgument("MinimumStripeDepth", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        outArgs[1] = new CIMArgument("MaximumStripeDepth", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        outArgs[2] = new CIMArgument("StripeDepthDivisor", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        return ProviderConstants.UINT32_THREE;
    }

    @Override
    protected Object extrinsic_GetSupportedStripeLengths(CIMObjectPath op, CIMArgument<?>[] outArgs) throws WBEMException {
        outArgs[0] = new CIMArgument("StripeLengths", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0]);
        return ProviderConstants.UINT32_TWO;
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        StorageCapabilitiesIMPL storageCapabilitiesIMPL = (StorageCapabilitiesIMPL)o[0];
        CIMProperty[] keys = retOP.getKeys();
        String poolID = "StorageCapabilitiesOfThinProvisioningPool." + Integer.toString(storageCapabilitiesIMPL.getArrayGroup());
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(storageCapabilitiesIMPL.getSerialNumber()).getRMIObject();
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("ElementType", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getElementType(), false), new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)storageCapabilitiesIMPL.isNoSinglePointOfFailure(), false), new CIMProperty(CPN_NOSINGLEPOINTOFFAILURE_DEFAULT, CIMDataType.BOOLEAN_T, (Object)storageCapabilitiesIMPL.isNoSinglePointOfFailure(), false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getDataRedunMax(), false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getDataRedunMin(), false), new CIMProperty(CPN_DATAREDUNDANCY_DEFAULT, CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getDataRedun(), false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getPkgRedunMax(), false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getPkgRedunMin(), false), new CIMProperty(CPN_PACKAGEREDUNDANCY_DEFAULT, CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getPkgRedun(), false), new CIMProperty("DeltaReservationMax", CIMDataType.UINT16_T, (Object)UINT16_100, false), new CIMProperty("DeltaReservationMin", CIMDataType.UINT16_T, (Object)UINT16_100, false), new CIMProperty(CPN_DELTARESERVATION_DEFAULT, CIMDataType.UINT16_T, (Object)UINT16_100, false), new CIMProperty(CPN_EXTENTSTRIPELENGTH_DEFAULT, CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getExtentStripLength(), false), new CIMProperty(CPN_PARITYLAYOUT_DEFAULT, CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getParityLayout(), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)poolID, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)poolID, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)poolID, false), new CIMProperty("SupportedDataOrganizations", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("SupportedExtentTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("SupportedCompressionRates", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_FIVE}, false), new CIMProperty("DedupSupported", CIMDataType.BOOLEAN_T, (Object)this.isDedupSupported(rmiObj), false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{StorageCapabilitiesIMPL.class}, o, "HITACHI_StorageCapabilitiesOfThinProvisioningPool");
        StorageCapabilitiesIMPL storageCapabilitiesIMPL = (StorageCapabilitiesIMPL)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)storageCapabilitiesIMPL.getInstanceID(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageCapabilitiesOfThinProvisioningPool", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            StorageCapabilitiesIMPL storageCapabilitiesIMPL;
            ThinPool tp;
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == instID) {
                throw new WBEMException(6, op.toString());
            }
            String[] instanceIDParts = ProviderLibs.parseStorageCapabilitiesInstanceID(instID);
            String systemName = instanceIDParts[0];
            String chassisArrayID = instanceIDParts[1];
            if (null != systemName && null != chassisArrayID && systemName.equals(device.getStorageSystemName()) && null != (tp = ThinPool.find(device.getRMIObject(), Short.parseShort(chassisArrayID), ThinPool.ThinPoolType.AOU)) && null != (storageCapabilitiesIMPL = new StorageCapabilitiesIMPL(tp, systemName))) {
                return this.generateInstance(op, propertyList, storageCapabilitiesIMPL);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private synchronized Boolean isDedupSupported(RMIObjectCache rmiObj) {
        Boolean ret;
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - lastLicenseChkTime;
        if (-1L == lastLicenseChkTime || elapsed >= chkInterval) {
            lastLicenseChkTime = currentTime;
            mLogger.log(Level.FINE, "Checked license {0} seconds ago, getting new value", TimeUnit.MILLISECONDS.toSeconds(elapsed));
            try {
                Robj_interface_PPKgetKeyLicenseStatus[] licenses;
                for (Robj_interface_PPKgetKeyLicenseStatus license : licenses = rmiObj.getKeyLicenseStatus()) {
                    int ppID = Integer.parseInt(license.getStrPPID());
                    if (8582 != ppID && 8682 != ppID) continue;
                    mLogger.log(Level.FINE, "Found 'DeDup' license, checking status");
                    isDedupActive = 1 == license.getNDetailStatus() ? Boolean.TRUE : Boolean.FALSE;
                    mLogger.log(Level.FINE, "'DeDup' license: {0}", isDedupActive);
                    break;
                }
                ret = isDedupActive;
            }
            catch (RemoteException | SANRmiException e) {
                mLogger.log(Level.SEVERE, "Error getting license status!", e);
                ret = null;
            }
        } else {
            mLogger.log(Level.FINE, "Checked license {0} seconds ago, using current value", TimeUnit.MILLISECONDS.toSeconds(elapsed));
            ret = isDedupActive;
        }
        return ret;
    }

    private class CallbackHandler<E extends ThinPool>
    extends IteratorCallbackIMPL<E> {
        private int mPoolID;
        private final String mSystemName;

        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, short pPoolID, String systemName) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.mPoolID = -1;
            this.mPoolID = pPoolID;
            this.mSystemName = systemName;
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block7: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E tp = item;
                        if (this.mPoolID != -1) {
                            ret = ((ThinPool)tp).getPoolID() != this.mPoolID;
                        }
                        if (-1 != this.mPoolID && (this.mPoolID == -1 || ret)) break block7;
                        StorageCapabilitiesIMPL storageCapabilitiesIMPL = new StorageCapabilitiesIMPL((ThinPool)tp, this.mSystemName);
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, StorageCapabilitiesOfThinProvisioningPoolInstrumentation.this.generateObjectPath(this.mOP, storageCapabilitiesIMPL));
                            break block7;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(StorageCapabilitiesOfThinProvisioningPoolInstrumentation.this.generateObjectPath(this.mOP, storageCapabilitiesIMPL));
                            break block7;
                        }
                        this.mIter.add(StorageCapabilitiesOfThinProvisioningPoolInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, storageCapabilitiesIMPL));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

