/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CHAInfo;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class StorageProcessorSystemPackageInstrumentation
extends BaseAssocInstrumentation {
    protected StorageProcessorSystemPackageInstrumentation() {
        super("HITACHI_StorageProcessorSystemPackage", "HITACHI_StorageProcessorCard", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProcessorCardInstrumentation"), "HITACHI_StorageProcessorSystem", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProcessorSystemInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        block15: {
            try {
                RMIObjectMapping device;
                if (null == assocName || !"HITACHI_StorageProcessorSystemPackage".equalsIgnoreCase(assocName.getObjectName())) break block15;
                String antClass = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent")) && (null == resultRole || resultRole.equalsIgnoreCase("Dependent"))) {
                    antClass = this.getReference1ClassName();
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Dependent")) && (null == resultRole || resultRole.equalsIgnoreCase("Antecedent"))) {
                    antClass = this.getReference2ClassName();
                }
                if (antClass == null) break block15;
                String keyVal = null;
                if (antClass.equals(this.getReference1ClassName())) {
                    keyVal = objectName.getKey("Tag") != null ? (String)objectName.getKey("Tag").getValue() : null;
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                } else {
                    keyVal = objectName.getKey("Name") != null ? (String)objectName.getKey("Name").getValue() : null;
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                }
                if (null == keyVal) break block15;
                int ctrID = -1;
                try {
                    ctrID = Integer.parseInt(ProviderLibs.getEndString(keyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                    CHAInfo chaInfo = CHAInfo.find(ctrID, device.getRMIObject());
                    if (null == chaInfo) break block15;
                    if (antClass.equals(this.getReference1ClassName())) {
                        if (isObjectPath) {
                            iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, chaInfo));
                        } else {
                            iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, chaInfo));
                        }
                        break block15;
                    }
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, chaInfo));
                        break block15;
                    }
                    iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, chaInfo));
                }
                catch (Exception e) {}
            }
            catch (Throwable th) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                CommonClassAsList<CHAInfo> callback = new CommonClassAsList<CHAInfo>();
                CHAInfo.getCHAInfoByCtrID(device.getRMIObject(), callback, -1);
                LinkedList<CHAInfo> chaInfoList = callback.getReturnValue();
                callback = null;
                CHAInfo chaInfo = chaInfoList.poll();
                while (chaInfo != null) {
                    if (iter.isClosed()) {
                        chaInfoList.clear();
                        return;
                    }
                    CIMObjectPath opStorageProcessorCard = this.getReference1Instrumentation().generateObjectPath(op, chaInfo);
                    CIMObjectPath opStorageProcessorSystem = this.getReference2Instrumentation().generateObjectPath(op, chaInfo);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, opStorageProcessorCard, opStorageProcessorSystem));
                    } else {
                        iter.add(this.generateInstance(op, propertyList, opStorageProcessorCard, opStorageProcessorSystem));
                    }
                    chaInfo = chaInfoList.poll();
                }
            }
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.close();
                iter.setException(we);
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        block7: {
            try {
                String cpvStorageProcessorSystem;
                CIMObjectPath opStorageProcessorCard = op.getKey("Antecedent") != null ? (CIMObjectPath)op.getKey("Antecedent").getValue() : null;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageProcessorCard, "Tag");
                String cpvStorageProcessorCard = null != opStorageProcessorCard && null != opStorageProcessorCard.getKey("Tag") && null != opStorageProcessorCard.getKey("Tag").getValue() ? (String)opStorageProcessorCard.getKey("Tag").getValue() : null;
                CIMObjectPath opStorageProcessorSystem = op.getKey("Dependent") != null ? (CIMObjectPath)op.getKey("Dependent").getValue() : null;
                String string = cpvStorageProcessorSystem = null != opStorageProcessorSystem && null != opStorageProcessorSystem.getKey("Name") && null != opStorageProcessorSystem.getKey("Name").getValue() ? (String)opStorageProcessorSystem.getKey("Name").getValue() : null;
                if (null == opStorageProcessorCard || !opStorageProcessorCard.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) || null == opStorageProcessorSystem || !opStorageProcessorSystem.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) || null == cpvStorageProcessorCard || !cpvStorageProcessorCard.equals(cpvStorageProcessorSystem)) break block7;
                int ctrID = -1;
                try {
                    ctrID = Integer.parseInt(ProviderLibs.getEndString(cpvStorageProcessorCard, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (-1 == ctrID) break block7;
                try {
                    CHAInfo chaInfo = CHAInfo.find(ctrID, device.getRMIObject());
                    if (null != chaInfo) {
                        opStorageProcessorCard = this.getReference1Instrumentation().generateObjectPath(op, chaInfo);
                        opStorageProcessorSystem = this.getReference2Instrumentation().generateObjectPath(op, chaInfo);
                        return this.generateInstance(op, propertyList, opStorageProcessorCard, opStorageProcessorSystem);
                    }
                }
                catch (Exception e) {}
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        block11: {
            try {
                if (null == assocName || !"HITACHI_StorageProcessorSystemPackage".equalsIgnoreCase(assocName.getObjectName())) break block11;
                String keyVal = null;
                RMIObjectMapping device = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent"))) {
                    keyVal = objectName.getKey("Tag") != null ? (String)objectName.getKey("Tag").getValue() : null;
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Dependent"))) {
                    keyVal = objectName.getKey("Name") != null ? (String)objectName.getKey("Name").getValue() : null;
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                }
                if (null == device) {
                    throw new WBEMException("Unable to get Connection to backend for object: " + objectName);
                }
                if (null == keyVal) break block11;
                int ctrID = -1;
                try {
                    ctrID = Integer.parseInt(ProviderLibs.getEndString(keyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                    CHAInfo chaInfo = CHAInfo.find(ctrID, device.getRMIObject());
                    if (null == chaInfo) break block11;
                    CIMObjectPath opStorageProcessorCard = this.getReference1Instrumentation().generateObjectPath(objectName, chaInfo);
                    CIMObjectPath opStorageProcessorSystem = this.getReference2Instrumentation().generateObjectPath(objectName, chaInfo);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opStorageProcessorCard, opStorageProcessorSystem));
                        break block11;
                    }
                    iter.add(this.generateInstance(objectName, propertyList, opStorageProcessorCard, opStorageProcessorSystem));
                }
                catch (Exception e) {}
            }
            catch (Throwable th) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
        }
        if (null != iter) {
            iter.done();
        }
    }
}

