/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageSettingForSnapshotInstrumentation
extends BaseInstrumentation {
    private String createInstanceID(ChassisArrayGroup cag) throws Exception {
        StringBuilder keyValue = new StringBuilder("HITACHI_StorageSettingForSnapshot");
        keyValue.delete(0, "HITACHI_".length());
        keyValue.append(".");
        keyValue.append(RMIObjectMapping.getRMIObjectMapping(cag.getSerialNumber()).getStorageSystemName());
        keyValue.append(".");
        keyValue.append(cag.getChassis());
        keyValue.append(".");
        keyValue.append(cag.getArrayGroup());
        return keyValue.toString();
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, "InstanceID");
            int fb4 = -1;
            int ag = -1;
            if (null != expectedValues) {
                if (1 != devices.size()) {
                    throw new WBEMException("Found " + devices.size() + " managed devices, expected 1: " + op);
                }
                String expInstID = (String)expectedValues.get("InstanceID");
                if (expInstID != null) {
                    Integer[] rets = ProviderLibs.getStoragePoolChassisAndArrayGroup(expInstID);
                    fb4 = rets[0];
                    ag = rets[1];
                }
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ChassisArrayGroup> callback = new CallbackHandler<ChassisArrayGroup>(deviceIter, isObjectPath, refInfo, op, propertyList, ag);
                ChassisArrayGroup.getChassisArrayGroup(device.getRMIObject(), callback, isObjectPath, fb4, -1, -1, ag);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        ChassisArrayGroup cag = (ChassisArrayGroup)o[0];
        String rl = cag.getRaidLevel();
        boolean raid1Plus = true;
        if (rl.compareTo("UNKNOWN") == 0 || rl.equalsIgnoreCase("RAID0")) {
            raid1Plus = false;
        }
        int valDataRedundancy = ProviderLibs.getDataRedudancy(rl);
        UnsignedInteger16 cvDataRedundancy = new UnsignedInteger16(valDataRedundancy);
        int valPackageRedundancy = ProviderLibs.getPackageRedudancy(rl);
        UnsignedInteger16 cvPackageRedundancy = new UnsignedInteger16(valPackageRedundancy);
        int valExtentStripeLength = ProviderLibs.getExtentStripeLen(rl);
        UnsignedInteger16 cvExtentStripeLength = new UnsignedInteger16(valExtentStripeLength);
        UnsignedInteger16 parityLayout = ProviderLibs.getParityLayout(rl);
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("DataOrganization", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("CUImage", CIMDataType.STRING_T, null, false), new CIMProperty("SubsystemID", CIMDataType.STRING_T, null, false), new CIMProperty("EmulatedDevice", CIMDataType.STRING_T, null, false), new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)raid1Plus, false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)cvDataRedundancy, false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)cvDataRedundancy, false), new CIMProperty("DataRedundancyGoal", CIMDataType.UINT16_T, (Object)cvDataRedundancy, false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)cvPackageRedundancy, false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)cvPackageRedundancy, false), new CIMProperty("PackageRedundancyGoal", CIMDataType.UINT16_T, (Object)cvPackageRedundancy, false), new CIMProperty("DeltaReservationMax", CIMDataType.UINT8_T, null, false), new CIMProperty("DeltaReservationMin", CIMDataType.UINT8_T, null, false), new CIMProperty("DeltaReservationGoal", CIMDataType.UINT8_T, null, false), new CIMProperty("ChangeableType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("ExtentStripeLength", CIMDataType.UINT16_T, (Object)cvExtentStripeLength, false), new CIMProperty("ExtentStripeLengthMax", CIMDataType.UINT16_T, (Object)cvExtentStripeLength, false), new CIMProperty("ExtentStripeLengthMin", CIMDataType.UINT16_T, (Object)cvExtentStripeLength, false), new CIMProperty("UserDataStripeDepth", CIMDataType.UINT64_T, null, false), new CIMProperty("UserDataStripeDepthMax", CIMDataType.UINT64_T, null, false), new CIMProperty("UserDataStripeDepthMin", CIMDataType.UINT64_T, null, false), new CIMProperty("ParityLayout", CIMDataType.UINT16_T, (Object)parityLayout, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)rl, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)rl, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)rl, false), new CIMProperty("ExtentType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{ChassisArrayGroup.class}, o, "HITACHI_StorageSettingForSnapshot");
        ChassisArrayGroup cag = (ChassisArrayGroup)o[0];
        String instID = this.createInstanceID(cag);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instID, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageSettingForSnapshot", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID", ".", 2);
        try {
            String instIDVal;
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null != instID && instID.startsWith(instIDVal = "HITACHI_StorageSettingForSnapshot".substring("HITACHI_".length()) + "." + device.getStorageSystemName())) {
                Integer[] rets = ProviderLibs.getStoragePoolChassisAndArrayGroup(instID);
                int fb4 = rets[0];
                int ag = rets[1];
                ChassisArrayGroup cag = ChassisArrayGroup.find(device.getRMIObject(), null, fb4, ag, false);
                return this.generateInstance(op, propertyList, cag);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private class CallbackHandler<E extends ChassisArrayGroup>
    extends IteratorCallbackIMPL<E> {
        private int mArrayGroup;

        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, int ag) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.mArrayGroup = -1;
            this.mArrayGroup = ag;
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block7: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E cag = item;
                        if (this.mArrayGroup != -1) {
                            ret = ((ChassisArrayGroup)cag).getArrayGroup() != this.mArrayGroup;
                        }
                        if (-1 != this.mArrayGroup && (this.mArrayGroup == -1 || ret)) break block7;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, StorageSettingForSnapshotInstrumentation.this.generateObjectPath(this.mOP, cag));
                            break block7;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(StorageSettingForSnapshotInstrumentation.this.generateObjectPath(this.mOP, cag));
                            break block7;
                        }
                        this.mIter.add(StorageSettingForSnapshotInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, cag));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

