/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PairInfo;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.PollingIndicationManager;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.TargetVolumeInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageSynchronizedInstrumentation
extends BaseAssocInstrumentation {
    private PollingIndicationManager mPollingIndicationManager;

    private static UnsignedInteger16 getCopyState(int pairStatus) {
        UnsignedInteger16 ret = null;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        switch (pairStatus) {
            case 0: {
                logger.log(Level.WARNING, "Status ({0}) has no SyncState mapping", new Object[]{pairStatus});
                break;
            }
            case 1: 
            case 16: {
                ret = ProviderConstants.UINT16_THREE;
                break;
            }
            case 32: {
                ret = ProviderConstants.UINT16_FOUR;
                break;
            }
            case 48: {
                ret = ProviderConstants.UINT16_SEVEN;
                break;
            }
            case 64: {
                ret = ProviderConstants.UINT16_THREE;
                break;
            }
            case 72: {
                ret = ProviderConstants.UINT16_SEVEN;
                break;
            }
            case 80: {
                ret = ProviderConstants.UINT16_FIVE;
                break;
            }
            case 96: {
                ret = ProviderConstants.UINT16_THREE;
                break;
            }
            case 104: {
                ret = ProviderConstants.UINT16_SEVEN;
                break;
            }
            default: {
                logger.log(Level.WARNING, "Status ({0}) is an unknown SyncState", new Object[]{pairStatus});
            }
        }
        return ret;
    }

    private static UnsignedInteger16 getProgressStatus(int pairStatus) {
        UnsignedInteger16 ret = null;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        switch (pairStatus) {
            case 0: {
                logger.log(Level.WARNING, "Status ({0}) has no SyncState mapping", new Object[]{pairStatus});
                break;
            }
            case 1: {
                ret = new UnsignedInteger16(21);
                break;
            }
            case 16: {
                ret = ProviderConstants.UINT16_SIX;
                break;
            }
            case 32: 
            case 48: {
                ret = ProviderConstants.UINT16_TWO;
                break;
            }
            case 64: {
                ret = ProviderConstants.UINT16_SEVEN;
                break;
            }
            case 72: {
                ret = ProviderConstants.UINT16_EIGHT;
                break;
            }
            case 80: {
                ret = new UnsignedInteger16(15);
                break;
            }
            case 96: 
            case 104: {
                ret = ProviderConstants.UINT16_TEN;
                break;
            }
            default: {
                logger.log(Level.WARNING, "Status ({0}) is an unknown SyncState", new Object[]{pairStatus});
            }
        }
        return ret;
    }

    private static UnsignedInteger16 getRequestedCopyState(int pairStatus) {
        UnsignedInteger16 ret = null;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        switch (pairStatus) {
            case 0: {
                logger.log(Level.WARNING, "Status ({0}) has no SyncState mapping", new Object[]{pairStatus});
                break;
            }
            case 1: {
                ret = new UnsignedInteger16(15);
                break;
            }
            case 16: {
                ret = ProviderConstants.UINT16_FOUR;
                break;
            }
            case 32: 
            case 48: {
                ret = new UnsignedInteger16(15);
                break;
            }
            case 64: 
            case 72: {
                ret = ProviderConstants.UINT16_FOUR;
                break;
            }
            case 80: {
                ret = new UnsignedInteger16(15);
                break;
            }
            case 96: 
            case 104: {
                ret = ProviderConstants.UINT16_SEVEN;
                break;
            }
            default: {
                logger.log(Level.WARNING, "Status ({0}) is an unknown SyncState", new Object[]{pairStatus});
            }
        }
        return ret;
    }

    private static UnsignedInteger16 getSyncState(int pairStatus) {
        UnsignedInteger16 ret = null;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        switch (pairStatus) {
            case 0: {
                logger.log(Level.WARNING, "Status ({0}) has no SyncState mapping", new Object[]{pairStatus});
                break;
            }
            case 1: {
                ret = new UnsignedInteger16(16);
                break;
            }
            case 16: {
                ret = ProviderConstants.UINT16_THREE;
                break;
            }
            case 32: {
                ret = ProviderConstants.UINT16_SIX;
                break;
            }
            case 48: {
                ret = new UnsignedInteger16(13);
                break;
            }
            case 64: {
                ret = ProviderConstants.UINT16_FIVE;
                break;
            }
            case 72: {
                ret = ProviderConstants.UINT16_TEN;
                break;
            }
            case 80: {
                ret = ProviderConstants.UINT16_TWELVE;
                break;
            }
            case 96: {
                ret = ProviderConstants.UINT16_SEVEN;
                break;
            }
            case 104: {
                ret = new UnsignedInteger16(13);
                break;
            }
            default: {
                logger.log(Level.WARNING, "Status ({0}) is an unknown SyncState", new Object[]{pairStatus});
            }
        }
        return ret;
    }

    private static Boolean isSyncMaintained(int pairStatus) {
        Boolean ret = Boolean.FALSE;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        switch (pairStatus) {
            case 0: {
                logger.log(Level.WARNING, "Status ({0}) has no SyncState mapping", new Object[]{pairStatus});
                break;
            }
            case 1: {
                ret = Boolean.FALSE;
                break;
            }
            case 16: 
            case 32: {
                ret = Boolean.TRUE;
                break;
            }
            case 48: {
                ret = Boolean.FALSE;
                break;
            }
            case 64: 
            case 72: {
                ret = Boolean.TRUE;
                break;
            }
            case 80: {
                ret = Boolean.FALSE;
                break;
            }
            case 96: {
                ret = Boolean.TRUE;
                break;
            }
            case 104: {
                ret = Boolean.FALSE;
                break;
            }
            default: {
                logger.log(Level.WARNING, "Status ({0}) is an unknown SyncState", new Object[]{pairStatus});
            }
        }
        return ret;
    }

    protected StorageSynchronizedInstrumentation() {
        super("HITACHI_StorageSynchronized", "HITACHI_StorageVolume", "SystemElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"), "HITACHI_StorageVolume", "SyncedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            RMIObjectMapping device;
            if (null == assocName || !"HITACHI_StorageSynchronized".equalsIgnoreCase(assocName.getObjectName())) {
                return;
            }
            if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageVolume") && null == role || role.equalsIgnoreCase("SystemElement") && (null == resultRole || resultRole.equalsIgnoreCase("SyncedElement") && this.getReference1Instrumentation().instanceExists(objectName))) {
                ArrayList<TargetVolumeInfo> targetInfoList;
                device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                String deviceNum = (String)cpDeviceID.getValue();
                DeviceNumber dn = DeviceNumber.find(deviceNum, device.getRMIObject());
                if (null != dn && !(targetInfoList = PairInfo.getTargetInfo(dn)).isEmpty()) {
                    RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber());
                    for (TargetVolumeInfo targetInfo : targetInfoList) {
                        DeviceNumber devNum = DeviceNumber.find(targetInfo.getDNString(), mapping.getRMIObject());
                        if (isObjectPath) {
                            iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, devNum));
                            continue;
                        }
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, devNum));
                    }
                }
            }
            if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageVolume") && (null == role || role.equalsIgnoreCase("SyncedElement")) && (null == resultRole || resultRole.equalsIgnoreCase("SystemElement")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                String sourceDNString;
                device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                RMIObjectMapping mapping = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                String deviceNum = (String)cpDeviceID.getValue();
                DeviceNumber targetDN = DeviceNumber.find(deviceNum, device.getRMIObject());
                if (null != targetDN && null != (sourceDNString = PairInfo.getSourceDeviceNumber(targetDN))) {
                    DeviceNumber dn = DeviceNumber.find(sourceDNString, mapping.getRMIObject());
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, dn));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, dn));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<DeviceNumber> callback = new CallbackHandler<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList);
                DeviceNumber.getDNs(device.getRMIObject(), callback, isObjectPath, null == propertyList || propertyList.length > 0, null, true);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath objectName, String[] propertyList, Object ... o) throws Exception {
        CIMObjectPath opAssoc = this.generateObjectPath(objectName, o);
        short pairStatus = (Short)o[2];
        CIMProperty[] props = new CIMProperty[]{opAssoc.getKey("SystemElement"), opAssoc.getKey("SyncedElement"), new CIMProperty("CopyType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_THREE, false), new CIMProperty("SyncMaintained", CIMDataType.BOOLEAN_T, (Object)StorageSynchronizedInstrumentation.isSyncMaintained(pairStatus), false), new CIMProperty("CopyState", CIMDataType.UINT16_T, (Object)StorageSynchronizedInstrumentation.getCopyState(pairStatus), false), new CIMProperty("Mode", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("SyncType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_SIX, false), new CIMProperty("RequestedCopyState", CIMDataType.UINT16_T, (Object)StorageSynchronizedInstrumentation.getRequestedCopyState(pairStatus), false), new CIMProperty("SyncState", CIMDataType.UINT16_T, (Object)StorageSynchronizedInstrumentation.getSyncState(pairStatus), false), new CIMProperty("ProgressStatus", CIMDataType.UINT16_T, (Object)StorageSynchronizedInstrumentation.getProgressStatus(pairStatus), false)};
        return new CIMInstance(opAssoc, props).filterProperties(propertyList);
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block9: {
            try {
                String pnSystemElement = this.getReference1PropertyName();
                CIMObjectPath opSystemElement = opObjectName.getKey(pnSystemElement) != null ? (CIMObjectPath)opObjectName.getKey(pnSystemElement).getValue() : null;
                CIMInstance instSystemElement = null;
                try {
                    instSystemElement = this.getReference1Instrumentation().getInstance(opSystemElement, new String[0]);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null == instSystemElement) break block9;
                String pnSyncedElement = this.getReference2PropertyName();
                CIMObjectPath opSyncedElement = opObjectName.getKey(pnSyncedElement) != null ? (CIMObjectPath)opObjectName.getKey(pnSyncedElement).getValue() : null;
                CIMInstance instSyncedElement = null;
                try {
                    instSyncedElement = this.getReference2Instrumentation().getInstance(opSyncedElement, new String[0]);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null != instSyncedElement) {
                    DeviceNumber dnSyncedElement;
                    DeviceNumber dnSystemElement;
                    TargetVolumeInfo targetInfo;
                    String dnStringSyncedElement;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opSystemElement, "SystemName");
                    opSystemElement = instSystemElement.getObjectPath();
                    opSyncedElement = instSyncedElement.getObjectPath();
                    String dnStringSystemElement = null != opSystemElement.getKey("DeviceID") ? (String)opSystemElement.getKey("DeviceID").getValue() : null;
                    String string = dnStringSyncedElement = null != opSyncedElement.getKey("DeviceID") ? (String)opSyncedElement.getKey("DeviceID").getValue() : null;
                    if (null != dnStringSystemElement && null != dnStringSyncedElement && null != (targetInfo = PairInfo.getTargetInfo(dnSystemElement = DeviceNumber.find(dnStringSystemElement, device.getRMIObject()), dnSyncedElement = DeviceNumber.find(dnStringSyncedElement, device.getRMIObject())))) {
                        return this.generateInstance(opObjectName, propertyList, instSystemElement.getObjectPath(), instSyncedElement.getObjectPath(), targetInfo.getStatus(), targetInfo.getKind());
                    }
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        if (null == this.mPollingIndicationManager) {
            this.mPollingIndicationManager = PollingIndicationManager.getInstance(mHandle);
        }
        CIMObjectPath op = new CIMObjectPath(null, null, null, ProviderLibs.getImplementationNamespace(), "HITACHI_StorageSynchronized", null);
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_StorageSynchronized".equalsIgnoreCase(query)) {
            this.setListen4InstAdd(startListening);
            this.mPollingIndicationManager.activate(op, PollingIndicationManager.Operation.InstCreation, startListening);
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_StorageSynchronized".equalsIgnoreCase(query)) {
            this.setListen4InstDel(startListening);
            this.mPollingIndicationManager.activate(op, PollingIndicationManager.Operation.InstDeletion, startListening);
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StorageSynchronized AND SourceInstance.SyncState <> PreviousInstance.SyncState".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
            this.mPollingIndicationManager.activate(op, PollingIndicationManager.Operation.InstModification, startListening);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null == assocName || !"HITACHI_StorageSynchronized".equalsIgnoreCase(assocName.getObjectName())) {
                return;
            }
            if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageVolume") && (null == role || role.equalsIgnoreCase("SystemElement")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                String deviceNum = (String)cpDeviceID.getValue();
                DeviceNumber sourceDN = DeviceNumber.find(deviceNum, device.getRMIObject());
                if (null != sourceDN) {
                    CIMObjectPath opSysElement = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ArrayList<TargetVolumeInfo> targetInfoList = PairInfo.getTargetInfo(sourceDN);
                    RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(sourceDN.getSerialNumber());
                    for (TargetVolumeInfo targetInfo : targetInfoList) {
                        DeviceNumber dn = DeviceNumber.find(targetInfo.getDNString(), mapping.getRMIObject());
                        CIMObjectPath opSyncedElement = this.getReference2Instrumentation().generateObjectPath(objectName, dn);
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(opSysElement, opSysElement, opSyncedElement));
                            continue;
                        }
                        short status = targetInfo.getStatus();
                        short kind = targetInfo.getKind();
                        iter.add(this.generateInstance(opSysElement, propertyList, opSysElement, opSyncedElement, status, kind));
                    }
                }
            } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageVolume") && (null == role || role.equalsIgnoreCase("SyncedElement")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                DeviceNumber sourceDN;
                String sourceDNString;
                CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                RMIObjectCache rmiObj = device.getRMIObject();
                String targetDNString = (String)cpDeviceID.getValue();
                DeviceNumber targetDN = DeviceNumber.find(targetDNString, rmiObj);
                if (null != targetDN && null != (sourceDNString = PairInfo.getSourceDeviceNumber(targetDN)) && null != (sourceDN = DeviceNumber.find(sourceDNString, rmiObj))) {
                    CIMObjectPath opSyncedElement = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    CIMObjectPath opSysElement = this.getReference1Instrumentation().generateObjectPath(objectName, sourceDN);
                    TargetVolumeInfo targetInfo = PairInfo.getTargetInfo(sourceDN, targetDN);
                    if (null != targetInfo) {
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(opSysElement, opSysElement, opSyncedElement));
                        } else {
                            short status = targetInfo.getStatus();
                            short kind = targetInfo.getKind();
                            if (status != -1 && kind != -1) {
                                iter.add(this.generateInstance(opSysElement, propertyList, opSysElement, opSyncedElement, status, kind));
                            }
                        }
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    private class CallbackHandler<E extends DeviceNumber>
    extends IteratorCallbackIMPL<E> {
        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (this.mIter.isClosed()) return false;
            try {
                E sourceDN = item;
                CIMObjectPath opSysElement = null;
                ArrayList<TargetVolumeInfo> targetInfoList = PairInfo.getTargetInfo(sourceDN);
                if (targetInfoList.isEmpty()) return ret;
                opSysElement = StorageSynchronizedInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, sourceDN);
                RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(((AbstractBaseCommonObject)sourceDN).getSerialNumber());
                Iterator<TargetVolumeInfo> i$ = targetInfoList.iterator();
                while (i$.hasNext()) {
                    TargetVolumeInfo targetInfo = i$.next();
                    DeviceNumber dn = DeviceNumber.find(targetInfo.getDNString(), mapping.getRMIObject());
                    CIMObjectPath opSyncedElement = StorageSynchronizedInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, dn);
                    if (this.mIsObjectPath) {
                        this.mIter.add(StorageSynchronizedInstrumentation.this.generateObjectPath(opSysElement, opSysElement, opSyncedElement));
                        continue;
                    }
                    short status = targetInfo.getStatus();
                    short kind = targetInfo.getKind();
                    this.mIter.add(StorageSynchronizedInstrumentation.this.generateInstance(opSysElement, this.mPropertyList, opSysElement, opSyncedElement, status, kind));
                }
                return ret;
            }
            catch (WBEMException we) {
                this.mIter.setException(we);
                return ret;
            }
            catch (Throwable thrown) {
                WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                this.mIter.setException(we);
                this.mIter.close();
                return ret;
            }
        }
    }
}

