/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class StorageSystemPackageDKCInstrumentation
extends BaseAssocInstrumentation {
    protected StorageSystemPackageDKCInstrumentation() {
        super("HITACHI_StorageSystemPackageDKC", "HITACHI_DKCChassis", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DKCChassisInstrumentation"), "HITACHI_StorageSystem", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_StorageSystemPackageDKC".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Dependent")) && (null == resultRole || resultRole.equalsIgnoreCase("Antecedent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    this.getReference1Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, this.createExpectedVals(device), null);
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent")) && (null == resultRole || resultRole.equalsIgnoreCase("Dependent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                    if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    private Hashtable<String, Object> createExpectedVals(RMIObjectMapping device) throws WBEMException {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        ret.put("SystemName", device.getStorageSystemName());
        return ret;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CIMObjectPath ssOP = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath dkcOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_DKCChassis", null);
                ReferenceInfo newRefInfo = new ReferenceInfo(null, ssOP, "Antecedent", "Dependent", propertyList, isObjectPath, this);
                this.getReference1Instrumentation().enumerate(deviceIter, dkcOP, new String[0], null, null, continueOnError, true, this.createExpectedVals(device), newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opDKCChassis;
            String cpnStorageSystem = this.getReference2PropertyName();
            CIMObjectPath opStorageSystem = op.getKey(cpnStorageSystem) != null ? (CIMObjectPath)op.getKey(cpnStorageSystem).getValue() : null;
            String cpnDKCChassis = this.getReference1PropertyName();
            CIMObjectPath cIMObjectPath = opDKCChassis = op.getKey(cpnDKCChassis) != null ? (CIMObjectPath)op.getKey(cpnDKCChassis).getValue() : null;
            if (null != opDKCChassis && null != opStorageSystem) {
                String cvDKCChassisTag;
                String ssName = opStorageSystem.getKey("Name") != null && opStorageSystem.getKey("Name").getValue() != null ? (String)opStorageSystem.getKey("Name").getValue() : null;
                String string = cvDKCChassisTag = opDKCChassis.getKey("Tag") != null && opDKCChassis.getKey("Tag").getValue() != null ? (String)opDKCChassis.getKey("Tag").getValue() : null;
                if (null != ssName && null != cvDKCChassisTag) {
                    String ssNameDKC;
                    String string2 = ssNameDKC = null != cvDKCChassisTag ? ProviderLibs.getAllButEndString(cvDKCChassisTag, ProviderConstants.ID_SEPERATOR_AS_CHAR) : null;
                    if (ssName.equalsIgnoreCase(ssNameDKC)) {
                        if (this.getReference1Instrumentation().instanceExists(opDKCChassis)) {
                            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageSystem, "Name");
                            String tag = ProviderLibs.getEndString(cvDKCChassisTag);
                            opDKCChassis = this.getReference1Instrumentation().generateObjectPath(opDKCChassis, tag, device.getRMIObject());
                            opStorageSystem = this.getReference2Instrumentation().generateObjectPath(opStorageSystem, device.getRMIObject());
                            return this.generateInstance(op, propertyList, opDKCChassis, opStorageSystem);
                        }
                        mLogger.log(Level.SEVERE, "{0} does not exists", opDKCChassis);
                    } else {
                        mLogger.log(Level.SEVERE, "StorageSystem name {0} != DKCChassis atg {1}", new Object[]{ssName, ssNameDKC});
                    }
                } else {
                    mLogger.log(Level.SEVERE, "Could not find {0} in property {1}", new Object[]{null == ssName ? "Name" : "Tag", null == ssName ? opStorageSystem : opDKCChassis});
                }
            } else {
                mLogger.log(Level.SEVERE, "Passed in objectpath({0}) is missing a key.", op);
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_StorageSystemPackageDKC".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageSystem") && (null == role || role.equalsIgnoreCase("Dependent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    CIMObjectPath dkcOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_DKCChassis", null, objectName.getXmlSchemaName());
                    CIMObjectPath newObjectName = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(null, newObjectName, "Antecedent", "Dependent", propertyList, isObjectPath, this);
                    this.getReference1Instrumentation().enumerate(iter, dkcOP, new String[0], null, null, continueOnError, true, this.createExpectedVals(device), newRefInfo);
                    needToCloseIter = false;
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_DKCChassis") && (null == role || role.equalsIgnoreCase("Antecedent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                    CIMObjectPath newObjectName = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    CIMObjectPath ssOP = this.getReference2Instrumentation().generateObjectPath(newObjectName, device.getRMIObject());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(newObjectName, newObjectName, ssOP));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, newObjectName, ssOP));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

