/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class UnpairedSnapshotVolumePoolSettingInstrumentation
extends BaseInstrumentation {
    private String createInstanceID(RMIObjectMapping device) throws Exception {
        StringBuilder ret = new StringBuilder("HITACHI_UnpairedSnapshotVolumePoolSetting".substring("HITACHI_".length()));
        ret.append(device.getStorageSystemName());
        return ret.toString();
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", ".", 2, expectedValues, "InstanceID", ".", 1);
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (iter != null && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("DataOrganization", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("CUImage", CIMDataType.STRING_T, null, false), new CIMProperty("SubsystemID", CIMDataType.STRING_T, null, false), new CIMProperty("EmulatedDevice", CIMDataType.STRING_T, null, false), new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("DataRedundancyGoal", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("PackageRedundancyGoal", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("DeltaReservationMax", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false), new CIMProperty("DeltaReservationMin", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false), new CIMProperty("DeltaReservationGoal", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false), new CIMProperty("ChangeableType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("ExtentStripeLength", CIMDataType.UINT16_T, null, false), new CIMProperty("ExtentStripeLengthMax", CIMDataType.UINT16_T, null, false), new CIMProperty("ExtentStripeLengthMin", CIMDataType.UINT16_T, null, false), new CIMProperty("ParityLayout", CIMDataType.UINT16_T, null, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"UNKNOWN", false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)"UNKNOWN", false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)"UNKNOWN", false), new CIMProperty("ExtentType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_UnpairedSnapshotVolumePoolSetting");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String instID = this.createInstanceID(rmiObj.getSMISMappingContainer());
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instID, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_UnpairedSnapshotVolumePoolSetting", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null != instID && instID.equals(this.createInstanceID(device))) {
                return this.generateInstance(op, propertyList, device.getRMIObject());
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

