/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation.iSCSI;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSIreadAllPortInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.iSCSI.ISCSIFCPortCallbackHandler;
import com.ws.wbem.CloseableAddableIterator;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class EthernetPortForIPProtocolEndpointImplementationInstrumentation
extends BaseAssocInstrumentation {
    public EthernetPortForIPProtocolEndpointImplementationInstrumentation() {
        super("HITACHI_EthernetPortForIPProtocolEndpointImplementation", "HITACHI_EthernetPort", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.iSCSI.EthernetPortInstrumentation"), "HITACHI_IPProtocolEndpoint", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.iSCSI.IPProtocolEndpointInstrumentation"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                CloseableAddableIterator portIter = new CloseableAddableIterator();
                ISCSIFCPortCallbackHandler callback = new ISCSIFCPortCallbackHandler((CloseableAddableIterator<FCPort>)portIter);
                FCPort.getFCPorts(device.getRMIObject(), callback, false, true, null, null);
                while (portIter.hasNext()) {
                    FCPort fcPort = (FCPort)portIter.next();
                    CIMObjectPath ePort = this.getReference1Instrumentation().generateObjectPath(op, fcPort);
                    ISCSIreadAllPortInfo targetPort = ISCSIreadAllPortInfo.find(device.getRMIObject(), fcPort.getPort());
                    if (null == targetPort) continue;
                    CIMObjectPath iSCSIPort = this.getReference2Instrumentation().generateObjectPath(op, fcPort, targetPort);
                    iter.add(this.generateInstance(op, propertyList, ePort, iSCSIPort));
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath ipProtocolEndpoint) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        hTable.put("SystemName", ipProtocolEndpoint.getKeyValue("SystemName"));
        hTable.put("PortID", ipProtocolEndpoint.getKeyValue("Name"));
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath ethernetPort) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String sysName = (String)ethernetPort.getKeyValue("SystemName");
        String name = (String)ethernetPort.getKeyValue("DeviceID");
        hTable.put("SystemName", ProviderLibs.getAllButEndString(sysName, ProviderConstants.ID_SEPERATOR_AS_CHAR));
        hTable.put("Name", ProviderLibs.getAllButEndString(name, ProviderConstants.ID_SEPERATOR_AS_CHAR));
        return hTable;
    }
}

