/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation.iSCSI;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSIreadAllPortInfo;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;

public class TCPProtocolEndpointInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    protected static String createSystemName(FCPort port) throws Exception {
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(port.getSerialNumber());
        String ret = device.getStorageSystemName() + "." + port.getControlID();
        return ret;
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_TCPProtocolEndpoint", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_TCPProtocolEndpoint added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_TCPProtocolEndpoint", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_TCPProtocolEndpoint deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_TCPProtocolEndpoint", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                FCPort port = (FCPort)pObj;
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(port.getSerialNumber());
                FCPort newInst = FCPort.find(port.getPortWWN(), FCPort.PortTypeRequested.iSCSI, device.getRMIObject());
                if (newInst != null) {
                    CIMInstance sourceInstance = this.generateInstance(op, null, newInst);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                    mHandle.deliverEvent(indication, null);
                } else {
                    mLogger.severe("Unable to find a fort that with WWN of: " + port.getPortWWN());
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_TCPProtocolEndpoint modified indication instance", t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues, new String[]{"ElementName", "SystemName"});
        try {
            String expName = null != expectedValues ? (String)expectedValues.get("Name") : null;
            for (final RMIObjectMapping device : devices) {
                for (int i = 0; i < 2; ++i) {
                    final ClosableAddableIteratorCB callback = new ClosableAddableIteratorCB();
                    final boolean uncached = i > 0;
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                mLogger.info("TCPProtocolEndpoint starting");
                                ISCSIreadAllPortInfo.getISCSIAllPortInfo(device.getRMIObject(), callback, -1, uncached);
                            }
                            catch (WBEMException e) {
                                callback.exceptionOccurred(e);
                            }
                            catch (Throwable e) {
                                WBEMException we = new WBEMException(1, e.toString(), null, e);
                                callback.exceptionOccurred(we);
                            }
                            finally {
                                mLogger.info("TCPProtocolEndpoint exiting");
                            }
                        }
                    };
                    Thread t = new Thread(r);
                    t.setDaemon(true);
                    t.setName("TCP ISCSIreadAllPortInfo processor");
                    t.start();
                    CloseableAddableIterator cbIter = callback.getWrappedCloseableAddableIter();
                    CustomCloseableIterator tmpIter = new CustomCloseableIterator();
                    if (!cbIter.hasNext()) continue;
                    try {
                        this.processTargets((CloseableIterator<ISCSIreadAllPortInfo>)cbIter, op, tmpIter, device, expName, propertyList, uncached);
                        while (tmpIter.hasNext()) {
                            CIMInstance inst = (CIMInstance)tmpIter.next();
                            if (null != refInfo) {
                                refInfo.addReference(iter, inst.getObjectPath());
                                continue;
                            }
                            if (isObjectPath) {
                                iter.add(inst.getObjectPath());
                                continue;
                            }
                            iter.add(inst);
                        }
                        i = 2;
                        continue;
                    }
                    catch (WBEMException we) {
                        if (null != tmpIter && !tmpIter.isClosed()) {
                            tmpIter.done();
                        }
                        if (i > 0) {
                            throw we;
                        }
                        mLogger.log(Level.FINEST, "Caught exception trying to get cached ISCSIreadAllPortInfo, will try getting uncached info", we);
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath pOP, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(pOP, o);
        ISCSIreadAllPortInfo port = (ISCSIreadAllPortInfo)o[1];
        CIMInstance ret = null;
        try {
            if (null != pOP) {
                ArrayList props = new ArrayList();
                CIMProperty[] keys = retOP.getKeys();
                ProviderLibs.addKeysToProperties(keys, props);
                props.add(new CIMProperty("PortNumber", CIMDataType.UINT32_T, (Object)new UnsignedInteger32((long)port.getTcpPortNumber()), false));
                props.add(new CIMProperty("ProtocolIFType", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(4111), false));
                props.add(new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false));
                props.add(new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
                props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false));
                props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
                StringBuilder capName = new StringBuilder("HITACHI_TCPProtocolEndpoint");
                capName = capName.append(" ");
                capName = capName.append(port.getId());
                props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)capName.toString(), false));
                props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)capName.toString(), false));
                ret = new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propList);
            }
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        return ret;
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath pOP, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{FCPort.class, ISCSIreadAllPortInfo.class}, o, "HITACHI_TCPProtocolEndpoint");
        FCPort port = (FCPort)o[0];
        CIMObjectPath ret = null;
        try {
            String systemName = TCPProtocolEndpointInstrumentation.createSystemName(port);
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_TCPProtocolEndpoint", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)Short.toString(port.getPort()), true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageProcessorSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true)};
            ret = new CIMObjectPath(pOP.getScheme(), pOP.getHost(), pOP.getPort(), pOP.getNamespace(), "HITACHI_TCPProtocolEndpoint", keys, pOP.getXmlSchemaName());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            FCPort fcPort;
            String nameKeyVal;
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String string = nameKeyVal = null != op.getKey("Name") ? (String)op.getKey("Name").getValue() : null;
            if (null != nameKeyVal && null != ccName && ccName.equals("HITACHI_TCPProtocolEndpoint") && null != sccName && sccName.equals("HITACHI_StorageProcessorSystem") && null != (fcPort = FCPort.find(Short.parseShort(nameKeyVal), FCPort.PortTypeRequested.iSCSI, device.getRMIObject()))) {
                if (!fcPort.isRequestedType(FCPort.PortTypeRequested.iSCSI)) {
                    mLogger.log(Level.SEVERE, "Requested FCPort is not an iSCSI port: {0}", fcPort);
                } else {
                    ISCSIreadAllPortInfo iSCSI = ISCSIreadAllPortInfo.find(device.getRMIObject(), fcPort.getPort());
                    if (null != iSCSI) {
                        return this.generateInstance(op, propertyList, fcPort, iSCSI);
                    }
                    mLogger.log(Level.SEVERE, "Requested iSCSI port, {0}, can't be found", fcPort);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTargets(CloseableIterator<ISCSIreadAllPortInfo> cbIter, CIMObjectPath op, CustomCloseableIterator<?> clientIter, RMIObjectMapping device, String expName, String[] propertyList, boolean uncached) throws Exception {
        try {
            while (cbIter.hasNext()) {
                ISCSIreadAllPortInfo port = (ISCSIreadAllPortInfo)cbIter.next();
                if (null != expName && !expName.equalsIgnoreCase(Integer.toString(port.getId()))) continue;
                mLogger.log(Level.FINE, "Processing iSCSIPort info with id: {0}", port.getId());
                FCPort fcPort = FCPort.find((short)port.getId(), FCPort.PortTypeRequested.iSCSI, device.getRMIObject(), uncached);
                if (null != fcPort) {
                    clientIter.add(this.generateInstance(op, propertyList, fcPort, port));
                    continue;
                }
                throw new WBEMException("ISCSIreadAllPortInfo with ID " + port.getId() + " has no matching FCPort");
            }
        }
        finally {
            if (null != clientIter) {
                clientIter.done();
            }
        }
    }
}

