/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.PoolNickname;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CreateModifyThinPool;
import com.hitachi.smi.jobs.ElementNameData;
import com.hitachi.smi.jobs.HitachiJobCallbackIF2;
import com.hitachi.smi.jobs.SetResourceNameHelper;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_AddPoolDataSx;
import sanproject.common.Robj_interface_POOLsetAddPoolSx_IN;
import sanproject.common.Robj_interface_PoolVolDataSx;
import sanproject.common.Robj_interface_RJiResourceName;
import sanproject.serverux.data.SANRmiException;

public class CoalescedCreateModifyThinPoolJob
extends Coalescable {
    List<Short> assignedPoolIDs = new ArrayList<Short>();
    private final List<Robj_interface_RJiResourceName> elementNames = new ArrayList<Robj_interface_RJiResourceName>();

    private void doElementNameStep() throws WBEMException {
        mLogger.log(Level.INFO, "Job {0} is setting the pool name(s).", this.getJob().getInstanceID());
        this.updateChildrenJobPercentComplete(75);
        ElementNameData.changeElementNames(this, this.elementNames);
    }

    private void doPoolCreationStep() throws WBEMException {
        Robj_interface_POOLsetAddPoolSx_IN rmiActions = this.getSetAddPoolObj();
        LinkedList<Robj_interface_POOLsetAddPoolSx_IN> q = new LinkedList<Robj_interface_POOLsetAddPoolSx_IN>();
        q.offer(rmiActions);
        this.setItemQueue(q);
        this.updateChildrenJobPercentComplete(25);
        mLogger.log(Level.INFO, "Job {0} creating pool(s).", this.getJob().getInstanceID());
        this.apply2(false);
        List<Integer> failedJobs = this.doStepCompleteNotification(HitachiJobCallbackIF2.StepCompleted.AFTER_STEP_1);
        if (0 != failedJobs.size()) {
            Collections.reverse(failedJobs);
            for (Integer index : failedJobs) {
                this.elementNames.remove(index);
            }
        }
    }

    @Override
    protected void executeJob(List<AbstractJobImpl> abstractItems) throws WBEMException {
        this.setAbstractJobImpls(abstractItems);
        this.createConcreteJobFromAbstractJobs();
        mLogger.log(Level.INFO, "CoalescedJob {0} starting", this.getJob().getInstanceID());
        this.markServerJobStarted(0);
        this.doPoolCreationStep();
        if (0 != this.elementNames.size()) {
            this.getHitachiJobServiceObject().updateServerJobPercentComplete(50, true);
            this.updateChildrenJobPercentComplete(50);
            this.doElementNameStep();
            this.markServerJobDone();
        } else {
            this.markServerJobComplete();
        }
    }

    private void getAssignedPoolIDs() throws WBEMException {
        CommonClassAsList<ThinPool> callback = new CommonClassAsList<ThinPool>();
        ThinPool.getThinPools(RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject(), callback, (short)-1, ThinPool.ThinPoolType.ALL);
        LinkedList<ThinPool> pools = callback.getReturnValue();
        callback = null;
        mLogger.log(Level.INFO, "Found {0} thin pools", pools.size());
        ThinPool pool = pools.poll();
        while (pool != null) {
            this.assignedPoolIDs.add(pool.getPoolID());
            pool = pools.poll();
        }
        Collections.sort(this.assignedPoolIDs);
    }

    private Robj_interface_RJiResourceName getElementNameInfo(SetResourceNameHelper helper, CreateModifyThinPool.CreateThinPoolData tpData) throws WBEMException {
        String emptyString = "";
        String elementName = tpData.getElementName();
        if (null == elementName) {
            ThinPool tp = tpData.getPool2Expand();
            if (null == tp) {
                elementName = String.valueOf(tpData.poolID);
            } else {
                try {
                    PoolNickname poolLabel = PoolNickname.find(helper.getRMIObject(), tp.getPoolID());
                    elementName = poolLabel != null ? poolLabel.getNickname() : String.valueOf(tp.getPoolID());
                }
                catch (WBEMException e) {
                    elementName = "";
                    mLogger.log(Level.SEVERE, "Error getting Label for pool " + tpData.getPoolID() + ", using default", e);
                }
            }
        }
        ElementNameData ld = new ElementNameData(Short.toString(tpData.getPoolID()), this.getDeviceSerialNumber(), SetResourceNameHelper.ResourceType.POOL, elementName);
        Robj_interface_RJiResourceName resourceName = helper.getResourceNameRMIobject(ld);
        return resourceName;
    }

    private Robj_interface_POOLsetAddPoolSx_IN getSetAddPoolObj() throws WBEMException {
        Robj_interface_POOLsetAddPoolSx_IN setAddPool_IN = null;
        try {
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber());
            RMIObjectCache rmiObj = device.getRMIObject();
            int numChildren = this.getAbstractJobImpls().size();
            ArrayList<CIMObjectPath> affectedElements = new ArrayList<CIMObjectPath>(numChildren);
            ArrayList<Robj_interface_AddPoolDataSx> poolDatas = new ArrayList<Robj_interface_AddPoolDataSx>(numChildren);
            this.getAssignedPoolIDs();
            SetResourceNameHelper helper = new SetResourceNameHelper(rmiObj);
            int x = 0;
            Iterator<AbstractJobImpl> iter = this.getAbstractJobImpls().iterator();
            while (iter.hasNext()) {
                AbstractJobImpl childJob = iter.next();
                if (!(childJob instanceof CreateModifyThinPool)) {
                    String msg = "Expected all elements of the list to contain instances of CreateModifyThinPool, however this instance contains a " + childJob.getClass().getSimpleName();
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                    continue;
                }
                CreateModifyThinPool.CreateThinPoolData tpData = (CreateModifyThinPool.CreateThinPoolData)childJob.getActionItem();
                ThinPool pool2Expand = tpData.getPool2Expand();
                short poolID = pool2Expand == null ? this.getThinPoolID(rmiObj) : pool2Expand.getPoolID();
                if (-1 == poolID) {
                    this.markAndRemoveChildJobWithError(iter, childJob, "Could not find pool ID for CreateModifyThinPool: " + tpData);
                    continue;
                }
                childJob.setResultIndex(x++);
                Robj_interface_AddPoolDataSx poolData = (Robj_interface_AddPoolDataSx)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.ADDPOOLDATA);
                tpData.setPoolID(poolID);
                this.setDefaultPoolValues(poolID, poolData);
                this.setPoolVolArray(rmiObj, tpData, pool2Expand, poolData);
                poolDatas.add(poolData);
                this.elementNames.add(this.getElementNameInfo(helper, tpData));
                affectedElements.add(childJob.getJob().getCIMObjectPath(this.getOwningElement()));
            }
            this.setAffectedElements(affectedElements);
            setAddPool_IN = (Robj_interface_POOLsetAddPoolSx_IN)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.POOLSETADDPOOL_IN);
            setAddPool_IN.setObjPoolData(poolDatas.toArray(new Robj_interface_AddPoolDataSx[poolDatas.size()]));
        }
        catch (RemoteException re) {
            throw new WBEMException(1, re.toString(), null, (Throwable)re);
        }
        catch (SANRmiException sre) {
            throw new WBEMException(1, sre.getErrMsgEn(), null, (Throwable)sre);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, t.toString(), null, t);
        }
        return setAddPool_IN;
    }

    private short getThinPoolID(RMIObjectCache rmiObj) throws WBEMException {
        short id = -1;
        mLogger.log(Level.INFO, "ThinPool used IDs: {0}", this.assignedPoolIDs);
        for (short count = ThinPool.maxThinPoolID(rmiObj); count > -1; count = (short)(count - 1)) {
            int IndexOfID = Collections.binarySearch(this.assignedPoolIDs, count);
            if (IndexOfID >= 0) continue;
            id = count;
            IndexOfID = Math.abs(IndexOfID) - 1;
            this.assignedPoolIDs.add(IndexOfID, id);
            mLogger.log(Level.INFO, "{0} is the first free ID found", id);
            break;
        }
        return id;
    }

    private void setDefaultPoolValues(short poolID, Robj_interface_AddPoolDataSx poolData) {
        poolData.setSPoolId(poolID);
        poolData.setSPoolThreshold((short)70);
        poolData.setSPoolThresholdMode((short)2);
        poolData.setSPoolFixThreshold((short)0);
        poolData.setSPoolGrainSize((short)168);
        poolData.setByPoolKind((byte)2);
        poolData.setByRelocationSpeed((byte)3);
        poolData.setIMaxSubscription(65535);
        poolData.setSTierControlInfo((short)32);
        poolData.setSExecutionCycle((short)129);
        poolData.setByRelocateStartPeriodHour((byte)0);
        poolData.setByRelocateStartPeriodMinute((byte)0);
        poolData.setByRelocateEndPeriodHour((byte)0);
        poolData.setByRelocateEndPeriodMinute((byte)0);
        poolData.setByMonitorStartPeriodHour((byte)0);
        poolData.setByMonitorStartPeriodMinute((byte)0);
        poolData.setByMonitorEndPeriodHour((byte)23);
        poolData.setByMonitorEndPeriodMinute((byte)59);
        poolData.setITierRelocatePolicy(0);
        poolData.setSPoolDepletionThreshold((short)80);
    }

    private void setPoolVolArray(RMIObjectCache rmiObj, CreateModifyThinPool.CreateThinPoolData tpData, ThinPool pool2Expand, Robj_interface_AddPoolDataSx poolData) throws RemoteException, SANRmiException {
        List<DeviceNumber> dns = tpData.getDns();
        Robj_interface_PoolVolDataSx[] poolVolArray = new Robj_interface_PoolVolDataSx[dns.size()];
        StringBuilder msg = new StringBuilder((pool2Expand == null ? "Creating a" : "Expanding") + " ThinPool w/ID: ");
        msg.append(tpData.getPoolID());
        msg.append(", ");
        msg.append(pool2Expand == null ? "Created from" : "Adding");
        msg.append(" the following LDEVs (DKC:CU:LDEV): \n");
        int index = 0;
        for (DeviceNumber dn : dns) {
            poolVolArray[index] = (Robj_interface_PoolVolDataSx)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.POOLVOLDATA);
            poolVolArray[index].setSLDKC(dn.getLdkc());
            poolVolArray[index].setSCU(dn.getCu());
            poolVolArray[index].setSLDEV(dn.getLdev());
            if (mLogger.isLoggable(Level.INFO)) {
                msg.append("\t");
                msg.append(index);
                msg.append(": ");
                msg.append(dn.getLdkc());
                msg.append(":");
                msg.append(dn.getCu());
                msg.append(":");
                msg.append(dn.getLdev());
                msg.append('\n');
            }
            ++index;
        }
        mLogger.info(msg.toString());
        poolData.setObjPoolVolData(poolVolArray);
    }
}

