/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedDeleteThinPool;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_POOLsetDeletePool_OUT;
import sanproject.common.Robj_interface_PoolData;

public class DeleteThinPool
extends AbstractJobImpl
implements HitachiJobCallbackIF {
    public DeleteThinPool(String pUserName, String pIPAddress, CIMObjectPath owningService, ThinPool tp) throws WBEMException {
        super(tp.getSerialNumber(), "DeleteStoragePool", pUserName, pIPAddress, owningService, "HITACHI_AffectedJobElementStorageVolume", "HITACHI_StorageCSOwningJobElement", null);
        if (tp.isSnapShotPool()) {
            throw new WBEMException("The passed in ThinPool (" + tp.getPoolID() + ") is a SnapShot pool and can not be deleted");
        }
        this.setCallback(this);
        this.setActionItem(tp);
        this.setAffectedElements(tp);
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedDeleteThinPool();
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted();
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                break;
            }
            case AFTER_TRANSACTION: {
                this.processResult();
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    private void processResult() {
        WBEMException we = null;
        try {
            Object t = this.getRMIResult();
            Robj_interface_POOLsetDeletePool_OUT jobRet = (Robj_interface_POOLsetDeletePool_OUT)t;
            Robj_interface_PoolData[] data = jobRet.getObjPoolData();
            long result = data[this.getResultIndex()].getLErrorCode();
            if (result != 0L) {
                String msg = "Job, " + this.getJobID() + ", received error: " + "3005 - " + result;
                mLogger.log(Level.SEVERE, msg);
                we = new WBEMException(msg);
            } else {
                this.verifyPoolDeleted();
            }
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (ClassCastException cce) {
            we = new WBEMException(1, cce.toString(), null, (Throwable)cce);
        }
        catch (Throwable t) {
            we = new WBEMException(1, t.toString(), null, t);
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    private void setAffectedElements(ThinPool tp) throws WBEMException {
        Set<String> containedDNs = tp.getContainingLDEVs();
        BaseInstrumentation bi = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation");
        CIMObjectPath[] affectedOPs = new CIMObjectPath[containedDNs.size()];
        int idx = 0;
        for (String dn : containedDNs) {
            try {
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerial());
                RMIObjectCache rmiObj = device.getRMIObject();
                DeviceNumber devNum = DeviceNumber.find(dn, rmiObj);
                affectedOPs[idx] = bi.generateObjectPath(this.getOwningElement(), devNum);
                ++idx;
            }
            catch (Exception e) {
                mLogger.log(Level.SEVERE, "Job, " + this.getJobID() + ", received exception trying to " + "get ObjectPath for dn: " + dn, e);
            }
        }
        super.setAffectedElements(affectedOPs);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeleteThinPool Parameters [");
        builder.append(this.getActionItem());
        builder.append("]");
        return builder.toString();
    }

    private void verifyPoolDeleted() throws WBEMException {
        ThinPool tp2Del = (ThinPool)this.getActionItem();
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerial());
        ThinPool tp = ThinPool.find(device.getRMIObject(), tp2Del.getPoolID(), ThinPool.ThinPoolType.AOU);
        for (int retryCount = -1; tp != null && retryCount < 20; ++retryCount) {
            try {
                this.getHitachiJobServiceObject().updateElapsedTime();
                mLogger.fine("Thin Pool(" + tp.getPoolID() + ") still in cache, will retry in " + 30 + " seconds.");
                Thread.sleep(30000L);
            }
            catch (InterruptedException ie) {
                mLogger.log(Level.FINEST, "transaction sleep interrupted - this is OK", ie);
            }
            tp = ThinPool.find(device.getRMIObject(), tp2Del.getPoolID(), ThinPool.ThinPoolType.AOU);
        }
        if (tp != null) {
            throw new WBEMException("ThinPool (" + tp.getPoolID() + ") was not removed from cache");
        }
    }
}

