/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedDeleteThinVolumeJob;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_EXDPGOperation;
import sanproject.common.Robj_interface_EXDsetAOUReleaseVvol_OUT;

public class DeleteThinVolume
extends AbstractJobImpl
implements HitachiJobCallbackIF {
    public DeleteThinVolume(String pUserName, String pIPAddress, CIMObjectPath owningService, DeviceNumber dn2Del) throws WBEMException {
        super(dn2Del.getSerialNumber(), "ReturnToStoragePool", pUserName, pIPAddress, owningService, "HITACHI_AffectedJobElementThinProvisioningPool", "HITACHI_StorageCSOwningJobElement", null);
        if (!dn2Del.isAOUVol()) {
            throw new WBEMException("Must pass in a DeviceNumber which represnts a Thin volume");
        }
        this.setCallback(this);
        this.setActionItem(dn2Del);
        this.setAffectedElements(dn2Del);
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedDeleteThinVolumeJob();
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted();
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                break;
            }
            case AFTER_TRANSACTION: {
                this.processResult();
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    private void processResult() {
        WBEMException we = null;
        try {
            Object t = this.getRMIResult();
            Robj_interface_EXDsetAOUReleaseVvol_OUT jobRet = (Robj_interface_EXDsetAOUReleaseVvol_OUT)t;
            Robj_interface_EXDPGOperation[] data = jobRet.getAllRobjPGOperation();
            long result = data[this.getResultIndex()].getResult();
            if (result != 0L) {
                String msg = "Job, " + this.getJobID() + ", received error 3205 - " + result;
                mLogger.log(Level.SEVERE, msg);
                we = new WBEMException(msg);
            } else {
                this.verifyVolumeDeleted();
            }
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (ClassCastException cce) {
            we = new WBEMException(1, cce.toString(), null, (Throwable)cce);
        }
        catch (Throwable t) {
            we = new WBEMException(1, t.toString(), null, t);
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    private void setAffectedElements(DeviceNumber dn) throws WBEMException {
        short poolID = dn.getThinPoolID();
        ThinPool tp = ThinPool.find(RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerial()).getRMIObject(), poolID, ThinPool.ThinPoolType.AOU);
        if (tp != null) {
            BaseInstrumentation bi = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ThinProvisioningPoolInstrumentation");
            try {
                CIMObjectPath path = bi.generateObjectPath(this.getOwningElement(), tp);
                super.setAffectedElements(new CIMObjectPath[]{path});
            }
            catch (Exception e) {
                mLogger.log(Level.SEVERE, "Job, " + this.getJobID() + ", received " + "error generating object path for affect element with poolID: " + poolID, e);
                super.setAffectedElements(new CIMObjectPath[0]);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeleteThinVolume Parameters [");
        builder.append(this.getActionItem());
        builder.append("]");
        return builder.toString();
    }

    private void verifyVolumeDeleted() throws WBEMException {
        DeviceNumber dn2Del = (DeviceNumber)this.getActionItem();
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerial());
        DeviceNumber dn = DeviceNumber.find(dn2Del.getDNAsString(), device.getRMIObject());
        for (int retryCount = 0; dn != null && retryCount < 20; ++retryCount) {
            try {
                this.getHitachiJobServiceObject().updateElapsedTime();
                mLogger.fine("Volume(" + dn2Del.getDNAsString() + ") still in cache, will retry in " + 30 + " seconds.");
                Thread.sleep(30000L);
            }
            catch (InterruptedException ie) {
                mLogger.log(Level.FINEST, "transaction sleep interrupted - this is OK", ie);
            }
            dn = DeviceNumber.find(dn2Del.getDNAsString(), device.getRMIObject());
        }
        if (dn != null) {
            throw new WBEMException("Volume (" + dn2Del.getDNAsString() + ") was not removed from cache");
        }
    }
}

