/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.LDevNickname;
import com.hitachi.smi.common.PoolNickname;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.SetResourceNameHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiResourceName;
import sanproject.common.Robj_interface_RJiSetResourceNameResult;
import sanproject.common.Robj_interface_RJiSetResourceName_IN;
import sanproject.common.Robj_interface_RJiSetResourceName_OUT;

public class ElementNameData {
    private final String elementName;
    private final SetResourceNameHelper.ResourceType elementType;
    private final int elementID;
    private final String serialNumber;

    public static void changeElementNames(Coalescable rmiJob, List<Robj_interface_RJiResourceName> resourceNames) throws WBEMException {
        if (!resourceNames.isEmpty()) {
            SetResourceNameHelper helper = new SetResourceNameHelper(Integer.parseInt(rmiJob.getDeviceSerialNumber()));
            LinkedList<Robj_interface_RJiSetResourceName_IN> elementNames = new LinkedList<Robj_interface_RJiSetResourceName_IN>();
            elementNames.offer(helper.getRMISetResourceInput(resourceNames));
            rmiJob.setItemQueue(elementNames);
            rmiJob.apply2(false);
        }
    }

    public ElementNameData(BaseDeviceNumber dn, String name) throws WBEMException {
        this(dn.getDNAsString(), dn.getSerialNumber(), SetResourceNameHelper.ResourceType.LDEV, name);
    }

    public ElementNameData(String elementID, String serialNumber, SetResourceNameHelper.ResourceType elementType, String name) throws WBEMException {
        if (null == serialNumber) {
            throw new WBEMException("Must pass in a non-NULL serial number");
        }
        this.serialNumber = serialNumber;
        if (null != elementID) {
            if (Long.parseLong(elementID) > Integer.MAX_VALUE) {
                throw new WBEMException(1, "Element ID(" + elementID + " is too big");
            }
            try {
                this.elementID = Integer.parseInt(elementID);
            }
            catch (NumberFormatException nfe) {
                throw new WBEMException(1, "Element ID is invalid", null, (Throwable)nfe);
            }
        } else {
            throw new WBEMException("Must pass in a non-NULL String");
        }
        this.elementName = null == name ? elementID : name;
        this.elementType = elementType;
    }

    public ElementNameData(ThinPool tp, String name) throws WBEMException {
        this(Short.toString(tp.getPoolID()), tp.getSerialNumber(), SetResourceNameHelper.ResourceType.POOL, name);
    }

    public void changeElementName() throws WBEMException {
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.serialNumber).getRMIObject();
        LinkedList<Robj_interface_RJiResourceName> resourceNames = new LinkedList<Robj_interface_RJiResourceName>();
        SetResourceNameHelper helper = new SetResourceNameHelper(rmiObj);
        Robj_interface_RJiResourceName resourceName = helper.getResourceNameRMIobject(this);
        resourceNames.add(resourceName);
        Coalescable t = new Coalescable(){

            @Override
            protected void executeJob(List<AbstractJobImpl> actionItems) throws WBEMException {
                throw new WBEMException("Function not usable");
            }
        };
        t.setDeviceSerialNumber(this.serialNumber);
        ElementNameData.changeElementNames(t, resourceNames);
        Robj_interface_RJiSetResourceName_OUT out = (Robj_interface_RJiSetResourceName_OUT)t.getResult();
        this.processResult(out, 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementNameData other = (ElementNameData)obj;
        if (this.elementID != other.elementID) {
            return false;
        }
        if (this.elementName == null ? other.elementName != null : !this.elementName.equals(other.elementName)) {
            return false;
        }
        return this.elementType == other.elementType;
    }

    protected int getElementID() {
        return this.elementID;
    }

    private String getElementIDAsString() {
        return Long.toString(this.elementID);
    }

    protected String getElementName() {
        return this.elementName;
    }

    protected int getElementType() {
        return this.elementType.getValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.elementID;
        result = 31 * result + (this.elementName == null ? 0 : this.elementName.hashCode());
        result = 31 * result + (this.elementType == null ? 0 : this.elementType.hashCode());
        return result;
    }

    protected void processResult(AbstractJobImpl job, int resultIndex) throws WBEMException {
        try {
            Robj_interface_RJiSetResourceName_OUT out = (Robj_interface_RJiSetResourceName_OUT)job.getRMIResult();
            this.processResult(out, resultIndex);
            this.verifyElementNameChanged(job);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (ClassCastException cce) {
            throw new WBEMException(1, cce.toString(), null, (Throwable)cce);
        }
        catch (Throwable e) {
            throw new WBEMException(1, "Exception getting transaction result: " + e, null, e);
        }
    }

    private void processResult(Robj_interface_RJiSetResourceName_OUT out, int resultIndex) throws WBEMException {
        Robj_interface_RJiSetResourceNameResult[] result = out.getResult();
        int[] retCodes = result[resultIndex].getError();
        if (retCodes[0] != 0 && retCodes[1] != 0) {
            String msg = "Received error from back end " + retCodes[0] + "-" + retCodes[1];
            throw new WBEMException(msg);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ElementNameData [elementName=");
        builder.append(this.elementName);
        builder.append(", elementType=");
        builder.append((Object)this.elementType);
        builder.append(", elementID=");
        builder.append(this.elementID);
        builder.append("]");
        return builder.toString();
    }

    private void verifyElementNameChanged(AbstractJobImpl job) throws WBEMException {
        switch (this.elementType) {
            case LDEV: {
                this.verifyLDEV(job);
                break;
            }
            case POOL: {
                this.verifyPool(job);
                break;
            }
            default: {
                AbstractJobImpl.mLogger.log(Level.SEVERE, "Element type, {0}, of resource name being changed is invalid", (Object)this.elementType);
            }
        }
    }

    private void verifyLDEV(AbstractJobImpl job) throws WBEMException {
        int retryCount = -1;
        DeviceNumber devNum = DeviceNumber.find(this.getElementIDAsString(), RMIObjectMapping.getRMIObjectMapping(this.serialNumber).getRMIObject());
        LDevNickname nickName = LDevNickname.find(devNum);
        while (!(null != nickName && this.getElementName().compareTo(nickName.getNickname()) == 0 || null == nickName && this.getElementName().isEmpty())) {
            try {
                job.getHitachiJobServiceObject().updateElapsedTime();
                AbstractJobImpl.mLogger.log(Level.INFO, "Job {0}: volume({1}) label is {2} but should have changed to {3}, will retry in {4} seconds.", new Object[]{job.getJobID(), this.getElementID(), nickName == null ? "null" : nickName.getNickname(), this.getElementName(), 30});
                Thread.sleep(30000L);
            }
            catch (InterruptedException ie) {
                AbstractJobImpl.mLogger.log(Level.FINEST, "transaction sleep interrupted - this is OK", ie);
            }
            if (++retryCount > 20) {
                throw new WBEMException("ElementName not updated in alloted time");
            }
            nickName = LDevNickname.find(devNum);
        }
    }

    private void verifyPool(AbstractJobImpl job) throws WBEMException {
        int retryCount = -1;
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.serialNumber).getRMIObject();
        ThinPool tp = ThinPool.find(rmiObj, (short)this.getElementID(), ThinPool.ThinPoolType.ALL);
        PoolNickname nickName = PoolNickname.find(rmiObj, tp.getPoolID());
        while (null != this.getElementName() && this.getElementName().length() > 0 && (nickName == null || this.getElementName().compareTo(nickName.getNickname()) != 0)) {
            try {
                job.getHitachiJobServiceObject().updateElapsedTime();
                AbstractJobImpl.mLogger.log(Level.INFO, "Job {0}: pool({1}) label is {2} but should have changed to {3}, will retry in {4} seconds.", new Object[]{job.getJobID(), this.getElementID(), nickName == null ? "null" : nickName.getNickname(), this.getElementName(), 30});
                Thread.sleep(30000L);
            }
            catch (InterruptedException ie) {
                AbstractJobImpl.mLogger.log(Level.FINEST, "transaction sleep interrupted - this is OK", ie);
            }
            if (++retryCount > 20) {
                throw new WBEMException("ElementName not updated in alloted time");
            }
            nickName = PoolNickname.find(rmiObj, tp.getPoolID());
        }
    }
}

