/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedProtectJob;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_ODGDsetGuardRetention;
import sanproject.common.Robj_interface_ODGDsetGuardRetention_OUT;

public class Protect
extends AbstractJobImpl
implements HitachiJobCallbackIF {
    private static final String METHOD_NAME = "Protect";
    private CIMObjectPath opLDEVExtent;
    private final int dnNumber;

    public Protect(String pUserName, String pIPAddress, CIMObjectPath owningService, DeviceNumber dn2Protect, byte guardVals, int retentionTerms, CIMObjectPath opLDEVExtent) throws WBEMException {
        super(dn2Protect.getSerialNumber(), METHOD_NAME, pUserName, pIPAddress, owningService, "HITACHI_AffectedJobElementStorageVolume", "HITACHI_StorageProtectionSOwningJobElement", null);
        if (!dn2Protect.isOpenVolume()) {
            throw new WBEMException("Must pass in a DeviceNumber which is OPEN");
        }
        ProtectData data = new ProtectData(dn2Protect, guardVals, retentionTerms);
        this.dnNumber = dn2Protect.getLdev();
        this.setActionItem(data);
        this.setCallback(this);
        this.setAffectedElements(dn2Protect, opLDEVExtent);
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedProtectJob();
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted();
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                break;
            }
            case AFTER_TRANSACTION: {
                this.processResult();
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    private void processResult() {
        WBEMException we = null;
        try {
            Object t = this.getRMIResult();
            Robj_interface_ODGDsetGuardRetention_OUT outObject = (Robj_interface_ODGDsetGuardRetention_OUT)t;
            Robj_interface_ODGDsetGuardRetention[] grResults = outObject.resultGuardRetention();
            int actionResult = grResults[this.getResultIndex()].getIErrorCode(this.dnNumber);
            if (actionResult != 0) {
                String msg = "Job, " + this.getJobID() + ", received error: " + actionResult;
                mLogger.log(Level.SEVERE, msg);
                we = new WBEMException(msg);
            }
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (ClassCastException cce) {
            we = new WBEMException(1, cce.toString(), null, (Throwable)cce);
        }
        catch (Throwable t) {
            we = new WBEMException(1, t.toString(), null, t);
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    private void setAffectedElements(DeviceNumber dn, CIMObjectPath pOPLDEVExtent) throws WBEMException {
        if (pOPLDEVExtent == null) {
            BaseInstrumentation bi = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation");
            try {
                this.opLDEVExtent = bi.generateObjectPath(this.getOwningElement(), dn);
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable e) {
                throw new WBEMException(1, "Error generating objectpath for volume: " + dn, null, e);
            }
        } else {
            this.opLDEVExtent = pOPLDEVExtent;
        }
        super.setAffectedElements(new CIMObjectPath[]{this.opLDEVExtent});
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Protect ");
        builder.append(this.getActionItem());
        return builder.toString();
    }

    class ProtectData {
        DeviceNumber dn;
        byte guardVals;
        int retentionTerms;

        public ProtectData(DeviceNumber dn, byte guardVals, int retentionTerms) {
            this.dn = dn;
            this.guardVals = guardVals;
            this.retentionTerms = retentionTerms;
        }

        protected DeviceNumber getDn() {
            return this.dn;
        }

        protected byte getGuardVals() {
            return this.guardVals;
        }

        protected int getRetentionTerms() {
            return this.retentionTerms;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Parameters [DeviceNumber=");
            builder.append(this.dn);
            builder.append(", guardVals=");
            builder.append(this.guardVals);
            builder.append(", retentionTerms=");
            builder.append(this.retentionTerms);
            builder.append("]");
            return builder.toString();
        }
    }
}

