/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.data;

import sanproject.serverux.data.MonitorElementInfo;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.data.PPCInfo;

public abstract class PPCAbilityBase
extends MonitorElementInfo
implements PPCInfo {
    private int plotLength = 0;
    private long totalMaxIOPerSec = -1L;
    private long totalMinIOPerSec = -1L;
    private long totalAvrIOPerSec = -1L;
    private long totalMaxTransRate = -1L;
    private long totalMinTransRate = -1L;
    private long totalAvrTransRate = -1L;
    private long totalResponseTime = -1L;
    private long[] maxIOPerSec;
    private long[] minIOPerSec;
    private long[] avrIOPerSec;
    private long[] maxTransRate;
    private long[] minTransRate;
    private long[] avrTransRate;
    private long[] responseTime;

    public PPCAbilityBase() {
        this.init(0);
    }

    public PPCAbilityBase(int n) {
        this.init(n);
    }

    private PPCAbilityBase nextAbility() {
        MonitorInfoCollection monitorInfoCollection;
        MonitorElementInfo monitorElementInfo;
        if (this.hasNextCollection() && (monitorElementInfo = (monitorInfoCollection = this.getParent().getNextCollection()).get(monitorInfoCollection.indexOf(this))) instanceof PPCAbilityBase) {
            return (PPCAbilityBase)monitorElementInfo;
        }
        return null;
    }

    public long[] getAvrIOPerSec() {
        PPCAbilityBase pPCAbilityBase = this.nextAbility();
        if (pPCAbilityBase != null) {
            return this.concatenate(this.avrIOPerSec, pPCAbilityBase.getAvrIOPerSec());
        }
        return this.avrIOPerSec;
    }

    public long[] getAvrTransRate() {
        PPCAbilityBase pPCAbilityBase = this.nextAbility();
        if (pPCAbilityBase != null) {
            return this.concatenate(this.avrTransRate, pPCAbilityBase.getAvrTransRate());
        }
        return this.avrTransRate;
    }

    public long[] getMaxIOPerSec() {
        PPCAbilityBase pPCAbilityBase = this.nextAbility();
        if (pPCAbilityBase != null) {
            return this.concatenate(this.maxIOPerSec, pPCAbilityBase.getMaxIOPerSec());
        }
        return this.maxIOPerSec;
    }

    public long[] getMaxTransRate() {
        PPCAbilityBase pPCAbilityBase = this.nextAbility();
        if (pPCAbilityBase != null) {
            return this.concatenate(this.maxTransRate, pPCAbilityBase.getMaxTransRate());
        }
        return this.maxTransRate;
    }

    public long[] getMinIOPerSec() {
        PPCAbilityBase pPCAbilityBase = this.nextAbility();
        if (pPCAbilityBase != null) {
            return this.concatenate(this.minIOPerSec, pPCAbilityBase.getMinIOPerSec());
        }
        return this.minIOPerSec;
    }

    public long[] getMinTransRate() {
        PPCAbilityBase pPCAbilityBase = this.nextAbility();
        if (pPCAbilityBase != null) {
            return this.concatenate(this.minTransRate, pPCAbilityBase.getMinTransRate());
        }
        return this.minTransRate;
    }

    public long[] getResponseTime() {
        PPCAbilityBase pPCAbilityBase = this.nextAbility();
        if (pPCAbilityBase != null) {
            return this.concatenate(this.responseTime, pPCAbilityBase.getResponseTime());
        }
        return this.responseTime;
    }

    public long getTotalAvrIOPerSec() {
        return this.totalAvrIOPerSec;
    }

    public long getTotalAvrTransRate() {
        return this.totalAvrTransRate;
    }

    public long getTotalMaxIOPerSec() {
        return this.totalMaxIOPerSec;
    }

    public long getTotalMaxTransRate() {
        return this.totalMaxTransRate;
    }

    public long getTotalMinIOPerSec() {
        return this.totalMinIOPerSec;
    }

    public long getTotalMinTransRate() {
        return this.totalMinTransRate;
    }

    public long getTotalResponseTime() {
        return this.totalResponseTime;
    }

    public void setAvrIOPerSec(long[] lArray) {
        this.avrIOPerSec = lArray;
    }

    public void setAvrTransRate(long[] lArray) {
        this.avrTransRate = lArray;
    }

    public void setMaxIOPerSec(long[] lArray) {
        this.maxIOPerSec = lArray;
    }

    public void setMaxTransRate(long[] lArray) {
        this.maxTransRate = lArray;
    }

    public void setMinIOPerSec(long[] lArray) {
        this.minIOPerSec = lArray;
    }

    public void setMinTransRate(long[] lArray) {
        this.minTransRate = lArray;
    }

    public void setResponseTime(long[] lArray) {
        this.responseTime = lArray;
    }

    public void setTotalAvrIOPerSec(long l) {
        this.totalAvrIOPerSec = l;
    }

    public void setTotalAvrTransRate(long l) {
        this.totalAvrTransRate = l;
    }

    public void setTotalMaxIOPerSec(long l) {
        this.totalMaxIOPerSec = l;
    }

    public void setTotalMaxTransRate(long l) {
        this.totalMaxTransRate = l;
    }

    public void setTotalMinIOPerSec(long l) {
        this.totalMinIOPerSec = l;
    }

    public void setTotalMinTransRate(long l) {
        this.totalMinTransRate = l;
    }

    public void setTotalResponseTime(long l) {
        this.totalResponseTime = l;
    }

    public void setAvrIOPerSec(int n, long l) {
        this.avrIOPerSec[n] = l;
    }

    public void setAvrTransRate(int n, long l) {
        this.avrTransRate[n] = l;
    }

    public void setMaxIOPerSec(int n, long l) {
        this.maxIOPerSec[n] = l;
    }

    public void setMaxTransRate(int n, long l) {
        this.maxTransRate[n] = l;
    }

    public void setMinIOPerSec(int n, long l) {
        this.minIOPerSec[n] = l;
    }

    public void setMinTransRate(int n, long l) {
        this.minTransRate[n] = l;
    }

    public void setResponseTime(int n, long l) {
        this.responseTime[n] = l;
    }

    private void init(int n) {
        this.plotLength = n;
        this.setAvrIOPerSec(new long[n]);
        this.setAvrTransRate(new long[n]);
        this.setMaxIOPerSec(new long[n]);
        this.setMaxTransRate(new long[n]);
        this.setMinIOPerSec(new long[n]);
        this.setMinTransRate(new long[n]);
        this.setResponseTime(new long[n]);
    }

    public int getPlotLength() {
        return this.plotLength;
    }
}

