/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import sanproject.serverux.data.GetDataHead;
import sanproject.serverux.data.GetDataInput;
import sanproject.serverux.data.GetDataInputParam;
import sanproject.serverux.data.GetDataOutput;
import sanproject.serverux.data.SanRmiInterface;
import sanproject.serverux.data.SanRmiInterfaceException;
import sanproject.serverux.data.SanRmiInterfaceList;
import sanproject.serverux.data.SetDataHead;
import sanproject.serverux.data.SetDataInput;
import sanproject.serverux.data.SetDataInputParam;
import sanproject.serverux.data.SetDataOutput;
import sanproject.serverux.dataimpl.SanRmiInputInterface;
import sanproject.serverux.dataimpl.SanRmiOutputInterface;

public class SanRmiInterfaceManager {
    protected static final Comparator __InputToCodeComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object instanceof InputToCode) {
                object = ((InputToCode)object).mInputClass;
            }
            if (object2 instanceof InputToCode) {
                object2 = ((InputToCode)object2).mInputClass;
            }
            return object.toString().compareTo(object2.toString());
        }
    };
    protected static final Comparator __CodeToOutputComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object instanceof CodeToOutput) {
                object = new Integer(((CodeToOutput)object).miCode);
            }
            if (object2 instanceof CodeToOutput) {
                object2 = new Integer(((CodeToOutput)object2).miCode);
            }
            return ((Integer)object).compareTo((Integer)object2);
        }
    };
    protected static final Comparator __ClassComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }
    };
    protected Class[] SearchList_InputClass;
    protected int[] ExchangeList_InputCode;
    protected int[] SearchList_OutputCode;
    protected Class[] ExchangeList_OutputClass;
    private static final int CODE_MASK_ALL = 0xFF0000;
    private static final int CODE_MASK_DCR = 0x740000;
    private static final int CODE_MASK_LUNM = 0x750000;
    private static final int CODE_MASK_LUNM_APPLY2 = 7671808;
    private static final int CODE_MASK_CVS = 0x760000;
    private static int CODE_DCRsetQueStart = 7602192;
    private static int CODE_DCRsetQueExec = 7602193;
    private static int CODE_LUNMsetQueStart = 7667713;
    private static int CODE_LUNMsetQueExec = 7667714;
    private static int CODE_CVSsetQueStart = 7733249;
    private static int CODE_CVSsetQueExec = 7733250;

    public SanRmiInterfaceManager(SanRmiInterfaceList sanRmiInterfaceList) {
        int n;
        InputToCode[] inputToCodeArray = new InputToCode[sanRmiInterfaceList.size()];
        CodeToOutput[] codeToOutputArray = new CodeToOutput[sanRmiInterfaceList.size()];
        for (n = 0; n < sanRmiInterfaceList.size(); ++n) {
            SanRmiInterface sanRmiInterface = sanRmiInterfaceList.getInterface(n);
            inputToCodeArray[n] = new InputToCode(sanRmiInterface.getInputClass(), sanRmiInterface.getCode());
            codeToOutputArray[n] = new CodeToOutput(sanRmiInterface.getCode(), sanRmiInterface.getOutputClass());
        }
        Arrays.sort(inputToCodeArray, __InputToCodeComparator);
        Arrays.sort(codeToOutputArray, __CodeToOutputComparator);
        this.SearchList_InputClass = new Class[sanRmiInterfaceList.size()];
        this.ExchangeList_InputCode = new int[sanRmiInterfaceList.size()];
        this.SearchList_OutputCode = new int[sanRmiInterfaceList.size()];
        this.ExchangeList_OutputClass = new Class[sanRmiInterfaceList.size()];
        for (n = 0; n < sanRmiInterfaceList.size(); ++n) {
            this.SearchList_InputClass[n] = inputToCodeArray[n].mInputClass;
            this.ExchangeList_InputCode[n] = inputToCodeArray[n].miCode;
            this.SearchList_OutputCode[n] = codeToOutputArray[n].miCode;
            this.ExchangeList_OutputClass[n] = codeToOutputArray[n].mOutputClass;
        }
    }

    protected int toCode(SanRmiInputInterface sanRmiInputInterface) {
        int n = Arrays.binarySearch(this.SearchList_InputClass, sanRmiInputInterface.getClass(), __ClassComparator);
        return this.ExchangeList_InputCode[n];
    }

    protected Class toSanRmiOutputInterface(int n) {
        int n2 = Arrays.binarySearch(this.SearchList_OutputCode, n);
        Class clazz = null;
        if (n2 >= 0) {
            clazz = this.ExchangeList_OutputClass[n2];
        }
        return clazz;
    }

    public GetDataInput toGetDataInput(SanRmiInputInterface sanRmiInputInterface) {
        GetDataInput getDataInput = this.getEmptyDataInput();
        getDataInput.inputPrm[0].inputHead.iFuncCode = this.toCode(sanRmiInputInterface);
        byte[] byArray = sanRmiInputInterface.getInputByteArray();
        if (byArray.length != 0) {
            getDataInput.inputPrm[0].inputHead.iFuncSize += byArray.length;
            getDataInput.inputPrm[0].byData = byArray;
        }
        return getDataInput;
    }

    public SanRmiOutputInterface toSanRmiOutputInterface(GetDataOutput getDataOutput) throws InstantiationException, IllegalAccessException, SanRmiInterfaceException {
        SanRmiOutputInterface sanRmiOutputInterface = null;
        Class clazz = this.toSanRmiOutputInterface(getDataOutput.outputData[0].outputHead.iFuncCode);
        sanRmiOutputInterface = (SanRmiOutputInterface)clazz.newInstance();
        if (getDataOutput.outputData[0].byData != null) {
            sanRmiOutputInterface.setOutputByteArray(getDataOutput.outputData[0].byData);
        }
        return sanRmiOutputInterface;
    }

    protected GetDataInput getEmptyDataInput() {
        int n = 1;
        int n2 = 12;
        GetDataInput getDataInput = new GetDataInput();
        getDataInput.iFuncListCnt = n;
        getDataInput.inputPrm = new GetDataInputParam[n];
        for (int i = 0; i < n; ++i) {
            getDataInput.inputPrm[i] = new GetDataInputParam();
            getDataInput.inputPrm[i].inputHead = new GetDataHead();
            getDataInput.inputPrm[i].inputHead.iJikkousuu = 1;
            getDataInput.inputPrm[i].inputHead.iFuncSize = n2;
            getDataInput.inputPrm[i].inputHead.iFuncCode = 0;
            getDataInput.inputPrm[i].byData = null;
        }
        return getDataInput;
    }

    public ArrayList toSetDataInput(List list) {
        ParamListWrapper paramListWrapper = this.initStartList();
        ArrayList<SetDataInputParam> arrayList = new ArrayList<SetDataInputParam>();
        ParamListWrapper paramListWrapper2 = this.initExecList();
        for (int i = 0; i < list.size(); ++i) {
            SanRmiInputInterface sanRmiInputInterface = (SanRmiInputInterface)list.get(i);
            paramListWrapper.add(this.toCode(sanRmiInputInterface));
            arrayList.add(this.toSetDataInputParam(sanRmiInputInterface));
            paramListWrapper2.add(this.toCode(sanRmiInputInterface));
        }
        ParamListWrapper paramListWrapper3 = null;
        paramListWrapper3 = paramListWrapper;
        paramListWrapper3.addAll(arrayList);
        paramListWrapper3.addAll(paramListWrapper2);
        int n = paramListWrapper3.size();
        ArrayList<SetDataInput> arrayList2 = new ArrayList<SetDataInput>(1);
        SetDataInput setDataInput = this.setEmptyDataInput(n);
        setDataInput.inputPrm = paramListWrapper3.toArray(setDataInput.inputPrm);
        arrayList2.add(setDataInput);
        return arrayList2;
    }

    private ParamListWrapper initStartList() {
        ParamListWrapper paramListWrapper = null;
        paramListWrapper = new ParamListWrapper(){

            SetDataInputParam getSetDataInputParam(int n) {
                SetDataInputParam setDataInputParam = null;
                switch (n & 0xFF0000) {
                    case 0x740000: {
                        if (this.containsFuncCode(CODE_DCRsetQueStart)) break;
                        setDataInputParam = SanRmiInterfaceManager.this.toSetDataInputParam(CODE_DCRsetQueStart);
                        break;
                    }
                    case 0x750000: {
                        if ((n & 0x751000) == 7671808 || this.containsFuncCode(CODE_LUNMsetQueStart)) break;
                        setDataInputParam = SanRmiInterfaceManager.this.toSetDataInputParam(CODE_LUNMsetQueStart);
                        break;
                    }
                    case 0x760000: {
                        if (this.containsFuncCode(CODE_CVSsetQueStart)) break;
                        setDataInputParam = SanRmiInterfaceManager.this.toSetDataInputParam(CODE_CVSsetQueStart);
                        break;
                    }
                    default: {
                        setDataInputParam = null;
                    }
                }
                return setDataInputParam;
            }
        };
        return paramListWrapper;
    }

    private ParamListWrapper initExecList() {
        ParamListWrapper paramListWrapper = null;
        paramListWrapper = new ParamListWrapper(){

            SetDataInputParam getSetDataInputParam(int n) {
                SetDataInputParam setDataInputParam = null;
                switch (n & 0xFF0000) {
                    case 0x740000: {
                        if (this.containsFuncCode(CODE_DCRsetQueExec)) break;
                        setDataInputParam = SanRmiInterfaceManager.this.toSetDataInputParam(CODE_DCRsetQueExec);
                        break;
                    }
                    case 0x750000: {
                        if ((n & 0x751000) == 7671808 || this.containsFuncCode(CODE_LUNMsetQueExec)) break;
                        setDataInputParam = SanRmiInterfaceManager.this.toSetDataInputParam(CODE_LUNMsetQueExec);
                        break;
                    }
                    case 0x760000: {
                        if (this.containsFuncCode(CODE_CVSsetQueExec)) break;
                        setDataInputParam = SanRmiInterfaceManager.this.toSetDataInputParam(CODE_CVSsetQueExec);
                        break;
                    }
                    default: {
                        setDataInputParam = null;
                    }
                }
                return setDataInputParam;
            }
        };
        return paramListWrapper;
    }

    private SetDataInputParam toSetDataInputParam(SanRmiInputInterface sanRmiInputInterface) {
        SetDataInputParam setDataInputParam = this.setEmptyDataInputPrm();
        setDataInputParam.inputHead.iFuncCode = this.toCode(sanRmiInputInterface);
        byte[] byArray = sanRmiInputInterface.getInputByteArray();
        if (byArray.length != 0) {
            setDataInputParam.inputHead.iFuncSize += byArray.length;
            setDataInputParam.byData = byArray;
        }
        return setDataInputParam;
    }

    private SetDataInputParam toSetDataInputParam(int n) {
        SetDataInputParam setDataInputParam = this.setEmptyDataInputPrm();
        setDataInputParam.inputHead.iFuncCode = n;
        return setDataInputParam;
    }

    public SanRmiOutputInterface toSanRmiOutputInterface(SetDataOutput setDataOutput) throws InstantiationException, IllegalAccessException, SanRmiInterfaceException {
        SanRmiOutputInterface sanRmiOutputInterface = null;
        Class clazz = this.toSanRmiOutputInterface(setDataOutput.outputData[0].outputHead.iFuncCode);
        if (clazz != null && setDataOutput.outputData[0].byData != null) {
            sanRmiOutputInterface = (SanRmiOutputInterface)clazz.newInstance();
            sanRmiOutputInterface.setOutputByteArray(setDataOutput.outputData[0].byData);
        }
        return sanRmiOutputInterface;
    }

    private SetDataInput setEmptyDataInput(int n) {
        int n2 = n;
        SetDataInput setDataInput = new SetDataInput();
        setDataInput.iFuncListCnt = n2;
        setDataInput.inputPrm = new SetDataInputParam[n2];
        return setDataInput;
    }

    private SetDataInputParam setEmptyDataInputPrm() {
        int n = 12;
        SetDataInputParam setDataInputParam = null;
        setDataInputParam = new SetDataInputParam();
        setDataInputParam.inputHead = new SetDataHead();
        setDataInputParam.inputHead.iJikkousuu = 1;
        setDataInputParam.inputHead.iFuncSize = n;
        setDataInputParam.inputHead.iFuncCode = 0;
        setDataInputParam.byData = null;
        return setDataInputParam;
    }

    private abstract class ParamListWrapper
    extends ArrayList {
        private ParamListWrapper() {
        }

        void add(int n) {
            SetDataInputParam setDataInputParam = this.getSetDataInputParam(n);
            if (setDataInputParam != null) {
                super.add(setDataInputParam);
            }
        }

        abstract SetDataInputParam getSetDataInputParam(int var1);

        boolean containsFuncCode(int n) {
            boolean bl = false;
            for (int i = 0; i < super.size(); ++i) {
                SetDataInputParam setDataInputParam = (SetDataInputParam)super.get(i);
                if (n != setDataInputParam.inputHead.iFuncCode) continue;
                bl = true;
                break;
            }
            return bl;
        }
    }

    class CodeToOutput {
        public int miCode;
        public Class mOutputClass;

        public CodeToOutput(int n, Class clazz) {
            this.miCode = n;
            this.mOutputClass = clazz;
        }
    }

    class InputToCode {
        public Class mInputClass;
        public int miCode;

        public InputToCode(Class clazz, int n) {
            this.mInputClass = clazz;
            this.miCode = n;
        }
    }
}

