/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import sanproject.common.Robj_interface_LogonUserInfo;
import sanproject.serverux.data.ChgUserInfo;
import sanproject.serverux.data.DelUserEntry;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.JNIException;
import sanproject.serverux.data.MD5;
import sanproject.serverux.data.RmiConObjInFile;
import sanproject.serverux.data.RmiControlObjImpl;
import sanproject.serverux.data.RmiObjImpl;
import sanproject.serverux.data.RmiReturnObject;
import sanproject.serverux.data.SetUserEntry;
import sanproject.serverux.data.StringControl;
import sanproject.serverux.data.UserEntry;
import sanproject.serverux.data.UserEntryInfo;
import sanproject.serverux.data.UserPassword;
import sanproject.serverux.data.common_FileAccessor;

public class SetUserFileAccess
extends common_FileAccessor {
    public static final Object LOCK = new Object();
    public static final String[] HP_ADMINS = new String[]{"administrator", "user"};
    public static final String ROOT = "root";
    static final String FILE_DIR = "cgi-bin\\utility\\csv\\";
    static final String FILE = "userlist.csv";
    public static final String FILENAME = RmiControlObjImpl.getDocRoot() + "cgi-bin\\utility\\csv\\" + "userlist.csv";
    public static final String MODE_ALL = "";
    private static final int LINE_ELEMENT_MIN = 4;
    private static final int CERT_IDX_USER_ID = 0;
    private static final int CERT_IDX_PASSWORD = 1;
    private static final int CERT_IDX_PP_FLAG = 2;
    private static final int CERT_IDX_AUTH = 3;
    private static final int CERT_IDX_READ = 4;
    private static final int CERT_IDX_SLPR = 5;
    private static final int ENTRY_MAX = 500;
    private static final int ID_CHAR_MAX = 16;
    private static final int PASS_CHAR_MAX = 32;
    private static final int PASS_CHAR_MAX_NOENCODE = 16;
    private static final int PERMIT_CHAR_MAX = 128;
    private static final int NOT_CHANGE = -1;
    private static final int HP_OVERSEA_MASK = 1048320;
    private static final int HP_OVERSEA = 147456;
    protected static final int ON_DELETE = 1;
    protected static final int OFF_DELETE = 0;
    public static final String PERMIT_MATCH = "[0-9a-f]*";
    public static final String ID_MATCH = "[^,\";:*?<>|/]*";
    private static final int AUTHORITY_ADMIN = 1;
    private static final int KIND_ADD = 1;
    private static final int KIND_CHG = 2;
    private static final int KIND_DEL = 3;
    private static final int KIND_PAS = 4;
    private static String PERMIT_ADMIN = null;
    private static String PERMIT_USER = null;
    private int nAuthority;
    private int nSLPRno;
    static final int PR_ADMIN_SLPR = 65535;
    RmiObjImpl rmiobj;

    public SetUserFileAccess() {
        this.init();
    }

    public SetUserFileAccess(RmiObjImpl rmiObjImpl) {
        this.init();
        this.rmiobj = rmiObjImpl;
        this.nAuthority = rmiObjImpl.info.nAuthority;
        this.nSLPRno = rmiObjImpl.info.nSLPRno;
        System.out.println("SetUserFileAccess:Auth=" + this.nAuthority);
        System.out.println("SetUserFileAccess:SLPR=" + this.nSLPRno);
    }

    public SetUserFileAccess(Object object) throws JNIException {
        super(object, FILENAME);
        this.init();
    }

    public void init() {
        PERMIT_ADMIN = this.makePermitString("F");
        PERMIT_USER = this.makePermitString("0");
    }

    private String makePermitString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 128; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String getDefaultPermit(String string, int n, int n2, boolean bl) throws JNIException {
        if (string == null) {
            switch (n) {
                case 1: {
                    if (bl) {
                        if (n2 == 1) {
                            string = PERMIT_ADMIN;
                            break;
                        }
                        string = PERMIT_USER;
                        break;
                    }
                    string = PERMIT_ADMIN;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        string = this.adjustPermission(string, string);
        return string;
    }

    public Object accessFileStart(Object object) throws JNIException {
        return this.accessFileRetryer(object, FILENAME);
    }

    protected Object manage(Object object, String string) throws JNIException, IOException {
        Object object2 = null;
        if (object instanceof ArrayList) {
            if (this.nAuthority != 1) {
                System.out.println("SetUserFileAccess:Auth=" + this.nAuthority);
                throw this.newException("setUserEntryInfo() NG Authority :" + this.nAuthority, 56524);
            }
            ArrayList arrayList = (ArrayList)object;
            object2 = this.setUserEntryInfo(arrayList);
        } else if (object instanceof String) {
            String string2 = (String)object;
            object2 = this.getUserEntryInfo(string2, false);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object setUserEntryInfo(ArrayList arrayList) throws JNIException, IOException {
        Object object = LOCK;
        synchronized (object) {
            int n = arrayList.size();
            HashMap hashMap = this.makeUserList(this.getUserEntryInfo(MODE_ALL, true));
            super.closeFile();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                if (e instanceof SetUserEntry) {
                    hashMap = this.addUserEntry((SetUserEntry)e, hashMap);
                    continue;
                }
                if (e instanceof DelUserEntry) {
                    hashMap = this.delUserEntry((DelUserEntry)e, hashMap);
                    continue;
                }
                if (e instanceof ChgUserInfo) {
                    hashMap = this.changeUserEntry((ChgUserInfo)e, hashMap);
                    continue;
                }
                if (!(e instanceof UserPassword)) continue;
                hashMap = this.changePassEntry((UserPassword)e, hashMap);
            }
            this.makeFile(hashMap);
            this.backupFile(RmiControlObjImpl.getDocRoot() + FILE_DIR, FILE);
        }
        return new RmiReturnObject();
    }

    private HashMap makeUserList(Object object) throws JNIException {
        HashMap<String, UserEntryInfo> hashMap = new HashMap<String, UserEntryInfo>();
        UserEntryInfo[] userEntryInfoArray = null;
        if (object instanceof UserEntryInfo[]) {
            userEntryInfoArray = (UserEntryInfo[])object;
            for (int i = userEntryInfoArray.length - 1; i >= 0; --i) {
                hashMap.put(userEntryInfoArray[i].strUserID, userEntryInfoArray[i]);
            }
        } else {
            throw this.newException("makeUserList() unexpected class:" + object.getClass(), 2005);
        }
        return hashMap;
    }

    private HashMap changePassEntry(UserPassword userPassword, HashMap hashMap) throws JNIException {
        UserEntry userEntry;
        if (this.checkUserID(userPassword.strUserID, hashMap)) {
            userEntry = (UserEntry)hashMap.get(userPassword.strUserID);
            if (this.nSLPRno != 65535 && userEntry.nSLPRno != this.nSLPRno) {
                throw this.newException(userPassword.strUserID + " is not exist.", 56524);
            }
        } else {
            throw this.newException(userPassword.strUserID + " is not exist.", 5553);
        }
        hashMap = this.changePassTarget(hashMap, userEntry, userPassword);
        return hashMap;
    }

    private HashMap changePassTarget(HashMap hashMap, UserEntry userEntry, UserPassword userPassword) throws JNIException {
        userEntry.password = this.adjustPassword(userPassword.strUserID, userPassword.strPassword, userPassword.nCryptType);
        return hashMap;
    }

    private HashMap changeUserEntry(ChgUserInfo chgUserInfo, HashMap hashMap) throws JNIException {
        if (!this.checkUserID(chgUserInfo.strUserID, hashMap)) {
            throw this.newException(chgUserInfo.strUserID + " is not exist.", 5553);
        }
        UserEntry userEntry = (UserEntry)hashMap.get(chgUserInfo.strUserID);
        hashMap = this.changeTarget(hashMap, userEntry, chgUserInfo);
        return hashMap;
    }

    private HashMap changeTarget(HashMap hashMap, UserEntry userEntry, ChgUserInfo chgUserInfo) throws JNIException {
        block5: {
            try {
                if (this.isHPOversea() && this.checkHPAdminUser(chgUserInfo.strUserID)) {
                    throw this.newException(chgUserInfo.strUserID + ":authority cannot change:", 5559);
                }
                if (this.nSLPRno != 65535 && userEntry.nSLPRno != this.nSLPRno) {
                    throw this.newException(chgUserInfo.strUserID + ":authority cannot change:", 56524);
                }
                if (chgUserInfo.nAuthority == -1) break block5;
                if (this.checkAuthority(chgUserInfo.nAuthority)) {
                    userEntry.nAuthority = chgUserInfo.nAuthority;
                    break block5;
                }
                throw this.newException("changeTarget() NG Authority :" + chgUserInfo.nAuthority, 5559);
            }
            catch (GetRmiException getRmiException) {
                throw this.newException(getRmiException.getMessage(), getRmiException.nErrData);
            }
        }
        userEntry.strPermission = this.adjustPermission(chgUserInfo.strPermission, userEntry.strPermission);
        userEntry.strWritePermission = this.adjustPermission(chgUserInfo.strWritePermission, userEntry.strWritePermission);
        return hashMap;
    }

    private HashMap delUserEntry(DelUserEntry delUserEntry, HashMap hashMap) throws JNIException {
        if (this.checkUserID(delUserEntry.strUserID, hashMap)) {
            if (this.checkAdminUser(delUserEntry.strUserID)) {
                throw this.newException("\"" + delUserEntry.strUserID + "\" cannot delete.", 5554);
            }
            if (this.checkLoginUser(delUserEntry.strUserID)) {
                throw this.newException("\"" + delUserEntry.strUserID + "\" cannot delete.", 55260);
            }
            UserEntry userEntry = (UserEntry)hashMap.get(delUserEntry.strUserID);
            if (this.nSLPRno != 65535 && userEntry.nSLPRno != this.nSLPRno) {
                throw this.newException("\"" + delUserEntry.strUserID + "\" cannot delete.", 5554);
            }
        } else {
            throw this.newException(delUserEntry.strUserID + " is not exist.", 5553);
        }
        hashMap.remove(delUserEntry.strUserID);
        return hashMap;
    }

    private HashMap addUserEntry(SetUserEntry setUserEntry, HashMap hashMap) throws JNIException {
        if (this.checkUserID(setUserEntry.UserPasswd.strUserID, hashMap)) {
            throw this.newException(setUserEntry.UserPasswd.strUserID + " is duplicate.", 5550);
        }
        if (this.checkAdminUser(setUserEntry.UserPasswd.strUserID)) {
            throw this.newException("\"" + setUserEntry.UserPasswd.strUserID + "\" cannot add.", 5554);
        }
        if (hashMap.size() >= 500) {
            throw this.newException("Entry count Max", 6540);
        }
        hashMap = this.addTarget(hashMap, setUserEntry);
        return hashMap;
    }

    private HashMap addTarget(HashMap hashMap, SetUserEntry setUserEntry) throws JNIException {
        UserEntry userEntry = new UserEntry();
        if (!this.checkAuthority(setUserEntry.nAuthority)) {
            throw this.newException("addTarget() NG Authority", 5559);
        }
        setUserEntry.UserPasswd.strPassword = this.adjustPassword(setUserEntry.UserPasswd.strUserID, setUserEntry.UserPasswd.strPassword, setUserEntry.UserPasswd.nCryptType);
        setUserEntry.strPermission = this.getDefaultPermit(setUserEntry.strPermission, 1, setUserEntry.nAuthority, false);
        setUserEntry.strWritePermission = this.getDefaultPermit(setUserEntry.strWritePermission, 1, setUserEntry.nAuthority, true);
        userEntry.nAuthority = setUserEntry.nAuthority;
        userEntry.strUserID = setUserEntry.UserPasswd.strUserID;
        userEntry.password = setUserEntry.UserPasswd.strPassword;
        userEntry.strPermission = setUserEntry.strPermission;
        userEntry.strWritePermission = setUserEntry.strWritePermission;
        userEntry.nSLPRno = this.nSLPRno;
        hashMap.put(userEntry.strUserID, userEntry);
        return hashMap;
    }

    private String adjustPermission(String string, String string2) throws JNIException {
        if (string == null) {
            if (string2 == null) {
                throw this.newException("adjustPermission() target null", 5557);
            }
        } else {
            if (string.length() > 128) {
                throw this.newException("adjustPermission() len err:" + string.length(), 5557);
            }
            if (!(string = string.toLowerCase()).matches(PERMIT_MATCH)) {
                throw this.newException("adjustPermission() prohibit err", 5557);
            }
            string2 = string;
        }
        return string2;
    }

    private String adjustPassword(String string, String string2, int n) throws JNIException {
        if (string2 == null) {
            string2 = MODE_ALL;
        } else if (!string2.matches(ID_MATCH) || string2.indexOf("\\") != -1) {
            throw this.newException("Password use prohibition char.", 5556);
        }
        if (n == 0) {
            if (string2.length() > 16) {
                throw this.newException("adjustPassword() length err", 5556);
            }
            MD5 mD5 = new MD5();
            string2 = mD5.encode(string, string2);
            mD5 = null;
        } else {
            if (n != 1) {
                throw this.newException("adjustPassword() crypt err", 5555);
            }
            if (n == 1 && string2.length() != 32) {
                throw this.newException("adjustPassword() length err", 5556);
            }
        }
        if (!string2.toLowerCase().matches(PERMIT_MATCH)) {
            throw this.newException("adjustPassword() prohibit err", 5556);
        }
        return string2;
    }

    private boolean checkAuthority(int n) {
        return n == 0 || n == 1;
    }

    private boolean isHPOversea() throws GetRmiException {
        return (RmiConObjInFile.getOEMType() & 0xFFF00) == 147456;
    }

    private boolean checkHPAdminUser(String string) {
        boolean bl = false;
        int n = HP_ADMINS.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(HP_ADMINS[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean checkAdminUser(String string) throws JNIException {
        boolean bl = false;
        try {
            bl = this.isHPOversea() ? this.checkHPAdminUser(string) : string.equals(ROOT);
        }
        catch (GetRmiException getRmiException) {
            System.out.println(StringControl.getErrStack(getRmiException));
            throw this.newException("Config File Access Failed ", getRmiException.nErrData);
        }
        return bl;
    }

    private boolean checkUserID(String string, HashMap hashMap) throws JNIException {
        boolean bl = false;
        if (string == null) {
            throw this.newException("userID null", 5551);
        }
        if (string.equals(MODE_ALL)) {
            throw this.newException("userID empty", 5551);
        }
        if (string.length() > 16) {
            throw this.newException("userID length over", 5552);
        }
        if (!string.matches(ID_MATCH) || string.indexOf("\\") != -1) {
            throw this.newException("userID use prohibition char", 5552);
        }
        bl = hashMap.containsKey(string);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUserEntryInfo(String string, boolean bl) throws JNIException {
        Object object = LOCK;
        synchronized (object) {
            Object object2 = null;
            String string2 = null;
            if (string.equals(MODE_ALL)) {
                String[] stringArray = this.getLineArrayWithoutClose();
                ArrayList<UserEntryInfo> arrayList = new ArrayList<UserEntryInfo>();
                while (stringArray != null) {
                    if (stringArray.length >= 4) {
                        string2 = stringArray.length > 4 ? stringArray[4] : MODE_ALL;
                        if (bl) {
                            if (stringArray.length > 5) {
                                arrayList.add(new UserEntry(stringArray[0], stringArray[1], string2, stringArray[2], stringArray[3], Integer.parseInt(stringArray[5])));
                            } else {
                                arrayList.add(new UserEntry(stringArray[0], stringArray[1], string2, stringArray[2], stringArray[3], this.nSLPRno));
                            }
                        } else if (stringArray.length > 5) {
                            if (this.nSLPRno == 65535 || this.nSLPRno == Integer.parseInt(stringArray[5])) {
                                arrayList.add(new UserEntryInfo(stringArray[0], string2, stringArray[2], stringArray[3]));
                            }
                        } else if (this.nSLPRno == 65535) {
                            arrayList.add(new UserEntryInfo(stringArray[0], string2, stringArray[2], stringArray[3]));
                        }
                    } else {
                        throw this.newException("File fomat error", 5560);
                    }
                    stringArray = this.getLineArrayWithoutClose();
                }
                int n = arrayList.size();
                UserEntryInfo[] userEntryInfoArray = new UserEntryInfo[n];
                for (int i = 0; i < n; ++i) {
                    userEntryInfoArray[i] = (UserEntryInfo)arrayList.get(i);
                }
                object2 = userEntryInfoArray;
            } else {
                String[] stringArray = this.getLineArrayWithoutClose();
                while (stringArray != null) {
                    if (stringArray.length >= 4) {
                        if (stringArray[0].equals(string)) {
                            string2 = stringArray.length > 4 ? stringArray[4] : MODE_ALL;
                            if (stringArray.length > 5) {
                                if (this.nSLPRno == 65535 || this.nSLPRno == Integer.parseInt(stringArray[5])) {
                                    object2 = new UserEntryInfo(stringArray[0], string2, stringArray[2], stringArray[3]);
                                }
                            } else if (this.nSLPRno == 65535) {
                                object2 = new UserEntryInfo(stringArray[0], string2, stringArray[2], stringArray[3]);
                            }
                        }
                    } else {
                        throw this.newException("File fomat error", 5560);
                    }
                    stringArray = this.getLineArrayWithoutClose();
                }
                if (object2 == null) {
                    throw this.newException(string + " is not exist.", 5553);
                }
            }
            return object2;
        }
    }

    protected void createFile(int n, String string) throws JNIException {
        boolean bl = false;
        int n2 = 4;
        for (int i = 0; i < n2; ++i) {
            try {
                File file = new File(string);
                if (n == 1) {
                    file.delete();
                }
                if (!file.createNewFile()) continue;
                bl = true;
                break;
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
                if (i < 3) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                throw this.newException("createFile() FileAccessError", 4001);
            }
        }
        if (!bl) {
            throw this.newException("createFile() FileAccessError", 4001);
        }
    }

    private void makeFile(HashMap hashMap) throws JNIException, IOException {
        UserEntry userEntry;
        this.createFile(1, FILENAME);
        super.openFile(FILENAME);
        String[] stringArray = null;
        try {
            stringArray = this.isHPOversea() ? HP_ADMINS : new String[]{ROOT, "administrator"};
        }
        catch (GetRmiException getRmiException) {
            this.newException(getRmiException.getMessage(), getRmiException.nErrData);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            Object v = hashMap.get(stringArray[i]);
            if (v == null || !(v instanceof UserEntry)) continue;
            userEntry = (UserEntry)v;
            stringBuffer.append(userEntry.toDump());
            hashMap.remove(stringArray[i]);
        }
        Object[] objectArray = hashMap.values().toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            if (!(objectArray[i] instanceof UserEntry)) continue;
            userEntry = (UserEntry)objectArray[i];
            stringBuffer.append(userEntry.toDump());
        }
        super.putOneLineWithoutClose(stringBuffer.toString());
    }

    private boolean checkLoginUser(String string) throws JNIException {
        boolean bl = false;
        try {
            Robj_interface_LogonUserInfo[] robj_interface_LogonUserInfoArray = this.rmiobj.getLogonUserList();
            for (int i = 0; i < robj_interface_LogonUserInfoArray.length; ++i) {
                if (!robj_interface_LogonUserInfoArray[i].getUserID().equals(string)) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            throw this.newException("userlist error", 4011);
        }
        return bl;
    }
}

