/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.dataimpl;

import java.io.ByteArrayOutputStream;
import java.nio.ByteOrder;
import sanproject.serverux.dataimpl.SanRmiByteArrayInterface;

public class SanRmiByteArrayOutputStream
extends ByteArrayOutputStream
implements SanRmiByteArrayInterface {
    protected ByteOrder _ByteOrder;

    public SanRmiByteArrayOutputStream() {
        this(1024);
    }

    public SanRmiByteArrayOutputStream(int n) {
        super(n);
        this.setLittleEndian();
    }

    public void setLittleEndian() {
        this._ByteOrder = ByteOrder.LITTLE_ENDIAN;
    }

    public void setBigEndian() {
        this._ByteOrder = ByteOrder.BIG_ENDIAN;
    }

    public ByteOrder nativeOrder() {
        return this._ByteOrder;
    }

    public void setUCHAR(byte by) {
        byte[] byArray = new byte[]{by};
        this.write(byArray, 0, byArray.length);
    }

    public void setUCHAR(short s) {
        byte[] byArray = new byte[]{(byte)(s & 0xFF)};
        this.write(byArray, 0, byArray.length);
    }

    public void setUCHAR(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray, 0, byArray.length);
    }

    public void setUSHORT(int n) {
        byte[] byArray = new byte[2];
        if (this._ByteOrder == ByteOrder.LITTLE_ENDIAN) {
            for (int i = 0; i < 2; ++i) {
                byArray[i] = (byte)((n & 255 << 8 * i) >>> 8 * i);
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                byArray[i] = (byte)((n & 65280 >>> 8 * i) >>> 8 * (2 - (i + 1)));
            }
        }
        this.write(byArray, 0, byArray.length);
    }

    public void setINT(int n) {
        byte[] byArray = new byte[4];
        if (this._ByteOrder == ByteOrder.LITTLE_ENDIAN) {
            for (int i = 0; i < 4; ++i) {
                byArray[i] = (byte)((n & 255 << 8 * i) >>> 8 * i);
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                byArray[i] = (byte)((n & -16777216 >>> 8 * i) >>> 8 * (4 - (i + 1)));
            }
        }
        this.write(byArray, 0, byArray.length);
    }

    public void setULONG(long l) {
        byte[] byArray = new byte[4];
        if (this._ByteOrder == ByteOrder.LITTLE_ENDIAN) {
            for (int i = 0; i < 4; ++i) {
                byArray[i] = (byte)((l & 255L << 8 * i) >>> 8 * i);
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                byArray[i] = (byte)((l & 0xFF000000L >>> 8 * i) >>> 8 * (4 - (i + 1)));
            }
        }
        this.write(byArray, 0, byArray.length);
    }

    public void setINT64(long l) {
        byte[] byArray = new byte[8];
        if (this._ByteOrder == ByteOrder.LITTLE_ENDIAN) {
            for (int i = 0; i < 8; ++i) {
                byArray[i] = (byte)((l & 255L << 8 * i) >>> 8 * i);
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                byArray[i] = (byte)((l & -72057594037927936L >>> 8 * i) >>> 8 * (8 - (i + 1)));
            }
        }
        this.write(byArray, 0, byArray.length);
    }

    public void setByteArray(String string, int n) {
        byte[] byArray = new byte[n];
        byte[] byArray2 = string.getBytes();
        for (int i = 0; i < n - 1; ++i) {
            byArray[i] = i < byArray2.length ? byArray2[i] : (byte)0;
        }
        byArray[n - 1] = 0;
        this.write(byArray, 0, byArray.length);
    }

    protected void skip(long l) {
        byte[] byArray = new byte[]{0};
        for (long i = 0L; i < l; ++i) {
            this.write(byArray, 0, 1);
        }
    }
}

