/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import com.ws.cim.mof.MOFStyle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.cim.CIMDataType;
import javax.cim.CIMParameter;
import javax.cim.CIMQualifiedElementInterface;
import javax.cim.CIMQualifier;
import javax.cim.CIMTypedElement;
import javax.cim.SharedMethods;

public class CIMMethod<E>
extends CIMTypedElement<E>
implements CIMQualifiedElementInterface,
Serializable {
    private static final long serialVersionUID = -3920536802046705977L;
    private final boolean mIsPropagated;
    private final CIMParameter<?>[] mParameters;
    private final CIMQualifier<?>[] mQualifiers;

    public CIMMethod(String name, CIMDataType type, CIMQualifier<?>[] qualifiers, CIMParameter<?>[] parameters, boolean propagated) {
        super(name, type);
        this.mParameters = parameters != null ? parameters : new CIMParameter[]{};
        this.mQualifiers = qualifiers != null ? qualifiers : new CIMQualifier[]{};
        this.mIsPropagated = propagated;
    }

    @Override
    public boolean equals(Object o) {
        try {
            if (o instanceof CIMMethod && super.equals(o)) {
                CIMMethod m = (CIMMethod)o;
                if (this.mIsPropagated == m.mIsPropagated) {
                    Object[] quals = (CIMQualifier[])this.mQualifiers.clone();
                    Object[] mquals = (CIMQualifier[])m.mQualifiers.clone();
                    Arrays.sort(quals);
                    Arrays.sort(mquals);
                    if (Arrays.equals(quals, mquals)) {
                        Object[] params = (CIMParameter[])this.mParameters.clone();
                        Object[] mparams = (CIMParameter[])m.mParameters.clone();
                        Arrays.sort(params);
                        Arrays.sort(mparams);
                        if (Arrays.equals(params, mparams)) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public CIMMethod<E> filter(boolean includeQualifiers) {
        return this.filter(includeQualifiers, false);
    }

    public CIMMethod<E> filter(boolean includeQualifiers, boolean localOnly) {
        CIMParameter<?>[] paramList = this.getFilteredParameters(includeQualifiers, localOnly);
        CIMQualifier<?>[] qualList = includeQualifiers ? SharedMethods.getFilteredQualifiers(localOnly, this.mQualifiers) : null;
        return new CIMMethod<E>(this.getName(), this.getDataType(), qualList, paramList, this.isPropagated());
    }

    private CIMParameter<?>[] getFilteredParameters(boolean pIncludeQualifiers, boolean pLocalOnly) {
        if (pIncludeQualifiers && !pLocalOnly) {
            return this.mParameters;
        }
        ArrayList l = new ArrayList();
        for (CIMParameter<?> p : this.mParameters) {
            l.add(p.filter(pIncludeQualifiers, pLocalOnly));
        }
        return l.toArray(new CIMParameter[l.size()]);
    }

    public CIMParameter<?> getParameter(String name) {
        for (CIMParameter<?> param : this.mParameters) {
            if (param == null || param.getName() == null || !param.getName().equalsIgnoreCase(name)) continue;
            return param;
        }
        return null;
    }

    public CIMParameter<?>[] getParameters() {
        return this.mParameters;
    }

    @Override
    public CIMQualifier<?> getQualifier(int index) throws ArrayIndexOutOfBoundsException {
        return this.mQualifiers[index];
    }

    @Override
    public CIMQualifier<?> getQualifier(String name) {
        if (name != null) {
            for (CIMQualifier<?> mQualifier : this.mQualifiers) {
                if (!mQualifier.getName().equalsIgnoreCase(name)) continue;
                return mQualifier;
            }
        }
        return null;
    }

    @Override
    public int getQualifierCount() {
        return this.mQualifiers.length;
    }

    @Override
    public CIMQualifier<?>[] getQualifiers() {
        return this.mQualifiers;
    }

    @Override
    public Object getQualifierValue(String name) {
        CIMQualifier<?> q = this.getQualifier(name);
        if (q != null) {
            return q.getValue();
        }
        return null;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash ^= this.mIsPropagated ? 0 : 1;
        for (CIMParameter<?> cIMParameter : this.mParameters) {
            hash ^= cIMParameter.hashCode();
        }
        for (CIMTypedElement cIMTypedElement : this.mQualifiers) {
            hash ^= ((CIMQualifier)cIMTypedElement).hashCode();
        }
        return hash;
    }

    @Override
    public boolean hasQualifier(String name) {
        return this.getQualifier(name) != null;
    }

    @Override
    public boolean hasQualifierValue(String name, Object value) {
        CIMQualifier<?> q = this.getQualifier(name);
        return q != null && q.getValue() != null && q.getValue().equals(value);
    }

    public boolean isPropagated() {
        return this.mIsPropagated;
    }

    @Override
    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }
}

