/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.listener;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.wbem.listener.WBEMListener;

public class WBEMListenerFactory {
    private static final String FILE_NAME = "javax.wbem.listener.WBEMListenerFactory";
    private static final String NAME_KEY = "transport.listener.name.";
    private static final String CLASS_KEY = "transport.listener.class.";
    private static final String ERR_PROTOCOL_INVALID = "Invalid protocol name.";
    private static final String ERR_PROTOCOL_NOT_SUPPORTED = "Protocol not supported";
    private static final String ERR_PROTOCOL_NOT_LOADED = "listener class could not be loaded";

    public static WBEMListener getListener(String protocol) {
        String protocol_key;
        if (protocol == null || protocol.trim().length() == 0) {
            throw new IllegalArgumentException(ERR_PROTOCOL_INVALID);
        }
        Properties properties = WBEMListenerFactory.loadProperties(FILE_NAME);
        String protocol_value = properties.getProperty(protocol_key = NAME_KEY + protocol.toLowerCase());
        if (protocol_value == null) {
            throw new IllegalArgumentException(ERR_PROTOCOL_NOT_SUPPORTED);
        }
        String classname = properties.getProperty(CLASS_KEY + protocol.toLowerCase());
        Class<?> cl = null;
        try {
            cl = Class.forName(classname);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ERR_PROTOCOL_NOT_LOADED);
        }
        WBEMListener cc = null;
        try {
            Class[] paramTypes = new Class[]{};
            Object[] paramList = new Object[]{};
            Constructor<?> ctr = cl.getConstructor(paramTypes);
            cc = (WBEMListener)ctr.newInstance(paramList);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        return cc;
    }

    public static String[] getProtocols() {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Properties properties = WBEMListenerFactory.loadProperties(FILE_NAME);
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                if (!k.startsWith(NAME_KEY)) continue;
                String value = properties.getProperty(k);
                ret.add(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret.toArray(new String[ret.size()]);
    }

    private static Properties loadProperties(String bundle) {
        Properties props = new Properties();
        PropertyResourceBundle prb = (PropertyResourceBundle)ResourceBundle.getBundle(bundle, new Locale("", ""));
        if (prb != null) {
            Enumeration<String> en = prb.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                if (key == null) continue;
                try {
                    String val = prb.getString(key);
                    props.setProperty(key, val);
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }
}

