/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.wbem.jserver.JServerProperties;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DaemonThreadFactory
implements ThreadFactory {
    final ThreadFactory wrappedFactory;

    public DaemonThreadFactory() {
        String factoryClz = JServerProperties.getThreadFactory();
        if (null != factoryClz) {
            ThreadFactory tmp;
            try {
                Class<?> tf = Class.forName(factoryClz);
                tmp = (ThreadFactory)tf.newInstance();
            }
            catch (Throwable e) {
                Logger logger = Logger.getLogger("com.ws.wbem.jserver");
                logger.log(Level.SEVERE, "Error loading custom ThreadFactory, using default", e);
                tmp = null;
            }
            this.wrappedFactory = tmp;
        } else {
            this.wrappedFactory = null;
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t;
        if (null != this.wrappedFactory) {
            t = this.wrappedFactory.newThread(r);
        } else {
            t = new Thread(r);
            t.setDaemon(true);
        }
        return t;
    }
}

