/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.wbem.jserver.JServerEventService;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerService;
import com.ws.wbem.jserver.JServerServiceAdapterFactory;
import com.ws.wbem.jserver.WBEMServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.provider.ProviderHandle;

class JServerServices {
    private final ArrayList<JServerEventService> eventServiceList;
    private final HashMap<String, JServerService> mServices;
    private final Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");

    JServerServices() {
        this.mLogger.info("Starting the J WBEM Server Services Factory.");
        this.mServices = new HashMap();
        this.eventServiceList = new ArrayList();
    }

    public void close() {
        for (String key : this.mServices.keySet()) {
            try {
                this.mServices.get(key).close();
            }
            catch (Throwable e) {
                this.mLogger.log(Level.FINE, "Ignoring unexpeted Error During Service sutdown " + key, e);
            }
        }
    }

    protected JServerEventService[] getEventServices() {
        return this.eventServiceList.toArray(new JServerEventService[this.eventServiceList.size()]);
    }

    public void initialize(WBEMServer pServer, ProviderHandle pHandle, Logger pLogger) {
        List<String> l = JServerProperties.getServices();
        for (String s : l) {
            try {
                JServerService service = JServerServiceAdapterFactory.getService(s);
                this.mLogger.info("Loading Service: " + s);
                service.initialize(pServer, pHandle, pLogger);
                if (service instanceof JServerEventService) {
                    this.eventServiceList.add((JServerEventService)service);
                }
                this.mServices.put(s, service);
            }
            catch (Throwable th) {
                this.mLogger.log(Level.SEVERE, "Service load failed: " + s, th);
            }
        }
    }
}

