/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.wbem.jserver.OperationIteratorType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.cim.CIMInstance;
import javax.wbem.CloseableIterator;

class OperationInfo {
    private final CloseableIterator<CIMInstance> mInstIter;
    private long mEndTime;
    private final long mTimeout;
    private final OperationIteratorType mIteratorType;

    public OperationInfo(CloseableIterator<CIMInstance> pObjList, OperationIteratorType iteratorType, long pTimeout) {
        this.mTimeout = pTimeout * 1000L;
        long currentTime = System.currentTimeMillis();
        this.mEndTime = currentTime + this.mTimeout;
        this.mInstIter = pObjList;
        this.mIteratorType = iteratorType;
    }

    public void close() {
        if (null != this.mInstIter) {
            this.mInstIter.close();
        }
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public List<CIMInstance> getInstances(int maxObjects) {
        ArrayList<CIMInstance> tempHolder = new ArrayList<CIMInstance>(maxObjects);
        try {
            long timeout = (long)((double)(this.mEndTime - System.currentTimeMillis()) * 0.33);
            while (maxObjects-- > 0 && 2000L < timeout && this.mInstIter.hasNext(timeout)) {
                tempHolder.add((CIMInstance)this.mInstIter.next());
                timeout = (long)((double)(this.mEndTime - System.currentTimeMillis()) * 0.33);
            }
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return tempHolder;
    }

    public OperationIteratorType getIteratorType() {
        return this.mIteratorType;
    }

    public long getTimeout() {
        return this.mTimeout;
    }

    public boolean hasNext() {
        boolean ret = true;
        try {
            ret = this.mInstIter.hasNext(100L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return ret;
    }

    public boolean isDone() {
        return this.mInstIter.isDone();
    }

    public void refreshTimeout() {
        long currentTime = System.currentTimeMillis();
        this.mEndTime = currentTime + this.mTimeout;
    }
}

