/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.wbem.jserver.JServer;
import java.util.ArrayList;
import java.util.Locale;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifierType;
import javax.cim.UnsignedInteger32;
import javax.security.auth.Subject;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.EnumerateResponse;
import javax.wbem.provider.IndicationProvider;
import javax.wbem.provider.ProviderHandle;

public class ProviderClient
implements ProviderHandle {
    private final JServer mServer;
    private final boolean mCalled;
    private final InheritableThreadLocal<ThreadData> mThreadData;

    ProviderClient(JServer server) {
        this.mCalled = false;
        this.mServer = server;
        this.mThreadData = new InheritableThreadLocal();
    }

    public ProviderClient(String pRepositoryDir) throws WBEMException {
        try {
            this.mServer = new JServer(null, pRepositoryDir == null ? "." : pRepositoryDir, "10");
        }
        catch (Exception e) {
            throw new WBEMException(1, e.getMessage(), null, (Throwable)e);
        }
        this.mCalled = true;
        this.mThreadData = new InheritableThreadLocal();
    }

    public CloseableIterator<CIMClass> associatorClasses(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers) throws WBEMException {
        return this.mServer.intassociatorClasses(objectName, assocClass, resultClass, role, resultRole, includeQualifiers);
    }

    public CloseableIterator<CIMInstance> associatorInstances(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, String[] propertyList) throws WBEMException {
        return this.mServer.intassociatorInstances(objectName, assocClass, resultClass, role, resultRole, propertyList);
    }

    public EnumerateResponse<CIMInstance> associators(CIMObjectPath instancePath, String assocClass, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects) throws WBEMException {
        return this.mServer.intassociators(instancePath, assocClass, resultClass, role, resultRole, propertyList, filterQueryLanguage, filterQuery, timeout, continueOnError, maxObjects);
    }

    public void close() {
        if (this.mCalled) {
            this.mServer.close();
        }
    }

    public void closeEnumeration(CIMObjectPath target, String context) throws WBEMException {
        this.mServer.intCloseEnumeration(target, context);
    }

    public void createClass(CIMClass cc) throws WBEMException {
        this.mServer.intCreateClass(cc);
    }

    public CIMObjectPath createInstance(CIMInstance ci) throws WBEMException {
        return this.mServer.intCreateInstance(ci);
    }

    public void createQualifierType(CIMQualifierType<?> qt) throws WBEMException {
        this.mServer.intSetQualifierType(qt);
    }

    public void deleteClass(CIMObjectPath target) throws WBEMException {
        this.mServer.intdeleteClass(target);
    }

    public void deleteInstance(CIMObjectPath target) throws WBEMException {
        this.mServer.intdeleteInstance(target);
    }

    public void deleteQualifierType(CIMObjectPath target) throws WBEMException {
        this.mServer.intdeleteQualifierType(target);
    }

    public void deliverEvent(CIMInstance indication, CIMInstance[] indicationSubscriptions) {
        this.mServer.deliverEvent(indication, indicationSubscriptions);
    }

    public CloseableIterator<CIMClass> enumerateClasses(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers) throws WBEMException {
        return this.mServer.intenumClass(path, deep, localOnly, includeQualifiers);
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath path, String[] propertyList) throws WBEMException {
        return this.mServer.intenumInstances(path, true, propertyList);
    }

    public EnumerateResponse<CIMInstance> enumerateInstances(CIMObjectPath classPath, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects) throws WBEMException {
        return this.mServer.intenumInstances(classPath, true, propertyList, filterQueryLanguage, filterQuery, timeout, continueOnError, maxObjects);
    }

    public CloseableIterator<CIMQualifierType<?>> enumerateQualifierTypes(CIMObjectPath path) throws WBEMException {
        return this.mServer.intenumQualifierTypes(path);
    }

    public CloseableIterator<CIMInstance> execQuery(CIMObjectPath op, String query, String ql) throws WBEMException {
        return this.mServer.intexecQuery(op, query, ql);
    }

    public EnumerateResponse<CIMInstance> execQueryInstances(CIMObjectPath path, String filterQuery, String filterQueryLanguage, boolean returnQueryResultClass, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects, CIMClass queryResultClass) throws WBEMException {
        return this.mServer.intExecQueryInstances(path, filterQueryLanguage, filterQueryLanguage, returnQueryResultClass, timeout, continueOnError, maxObjects, queryResultClass);
    }

    public CIMClass getClass(CIMObjectPath path, boolean localOnly, boolean includeQualifiers) throws WBEMException {
        CIMClass cc = this.mServer.intgetClass(path, localOnly, includeQualifiers);
        return cc.filterProperties(localOnly, includeQualifiers);
    }

    private String getClient() {
        return null;
    }

    public IndicationProvider getIndicationProvider(CIMObjectPath pClass) throws WBEMException {
        return this.mServer.getIndicationProvider(pClass);
    }

    public CIMInstance getInstance(CIMObjectPath path, String[] propertyList) throws WBEMException {
        CIMInstance ci = this.mServer.intgetInstance(path, propertyList);
        return ci.filterProperties(propertyList);
    }

    public EnumerateResponse<CIMInstance> getInstances(CIMObjectPath path, String context, UnsignedInteger32 maxObjects) throws WBEMException {
        return this.mServer.intGetInstances(path, context, maxObjects);
    }

    public EnumerateResponse<CIMInstance> getInstancesWithPath(CIMObjectPath path, String context, UnsignedInteger32 maxObjects) throws WBEMException {
        return this.mServer.intGetInstancesWithPath(path, context, maxObjects);
    }

    public String getProperty(String name) {
        if (name.equals("javax.wbem.provider.Principal")) {
            return this.getUser();
        }
        if (name.equals("javax.wbem.provider.SessionID")) {
            return this.getSessionID();
        }
        if (name.equals("javax.wbem.provider.ClientHost")) {
            return this.getClient();
        }
        throw new IllegalArgumentException();
    }

    public CIMQualifierType<?> getQualifierType(CIMObjectPath name) throws WBEMException {
        return this.mServer.intgetQualifierType(name);
    }

    public Locale[] getRequestedLocales() {
        return null;
    }

    private String getSessionID() {
        ThreadData t = (ThreadData)this.mThreadData.get();
        String ret = t != null ? t.getSessionID() : null;
        return ret;
    }

    private String getUser() {
        ThreadData t = (ThreadData)this.mThreadData.get();
        String ret = t != null ? t.getUser() : null;
        return ret;
    }

    public void initialize(CIMObjectPath name, Subject subject, Locale[] locales) throws WBEMException {
    }

    public Object invokeMethod(CIMObjectPath name, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        try {
            ArrayList args = new ArrayList();
            Object result = this.mServer.intinvokeMethod(name, methodName, inArgs, args);
            CIMArgument[] oArgs = args.toArray(new CIMArgument[args.size()]);
            if (null != oArgs && null != outArgs) {
                System.arraycopy(oArgs, 0, outArgs, 0, outArgs.length);
            }
            return result;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.getMessage());
        }
    }

    public void modifyClass(CIMClass cc) throws WBEMException {
        this.mServer.intModifyClass(cc);
    }

    public void modifyInstance(CIMInstance ci, String[] propertyList) throws WBEMException {
        this.mServer.intModifyInstance(ci, propertyList, true);
    }

    public void modifyQualifierType(CIMQualifierType<?> qt) throws WBEMException {
        this.mServer.intSetQualifierType(qt);
    }

    public CloseableIterator<CIMClass> referenceClasses(CIMObjectPath objectName, String resultClass, String role, boolean includeQualifiers) throws WBEMException {
        return this.mServer.intreferenceClasses(objectName, resultClass, role, includeQualifiers);
    }

    public CloseableIterator<CIMInstance> referenceInstances(CIMObjectPath objectName, String resultClass, String role, String[] propertyList) throws WBEMException {
        return this.mServer.intreferenceInstances(objectName, resultClass, role, propertyList);
    }

    public EnumerateResponse<CIMInstance> references(CIMObjectPath instancePath, String ResultClass, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects) throws WBEMException {
        return this.mServer.intreferences(instancePath, ResultClass, role, propertyList, filterQueryLanguage, filterQuery, timeout, continueOnError, maxObjects);
    }

    public void setLocales(Locale[] pLocales) {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String name, String value) {
        throw new IllegalArgumentException();
    }

    protected void setThreadData(String name, String sessionID) {
        this.mThreadData.set(new ThreadData(name, sessionID));
    }

    class ThreadData {
        String user;
        String sessionID;

        ThreadData(String user, String sessionID) {
            this.user = user;
            this.sessionID = sessionID;
        }

        String getSessionID() {
            return this.sessionID;
        }

        String getUser() {
            return this.user;
        }
    }
}

