/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.common;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.profiles.common.BaseInstanceProvider;
import com.ws.wbem.query.fql.FQLParser;
import java.util.ArrayList;
import java.util.Arrays;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.client.EnumerateResponse;
import javax.wbem.provider.PullAssociatorProvider;

public abstract class GenericAssociationProvider
extends BaseInstanceProvider
implements PullAssociatorProvider {
    private final String mPropertyNameFirst;
    private final String mPropertyNameSecond;
    protected final String mClassNameFirst;
    protected final String mClassNameSecond;
    private final ArrayList<CIMProperty<?>> mAdditionalProperties;

    public GenericAssociationProvider(String className, String classNameFirst, String classNameSecond, String propNameFirst, String propNameSecond, CIMProperty<?>[] additionalProperties) {
        this(className, classNameFirst, classNameSecond, propNameFirst, propNameSecond, additionalProperties, false);
    }

    public GenericAssociationProvider(String className, String classNameFirst, String classNameSecond, String propNameFirst, String propNameSecond, CIMProperty<?>[] additionalProperties, boolean brand) {
        this.mClassName = brand ? JServerSettings.replaceSchemaClassName(className) : className;
        this.mClassNameFirst = brand ? JServerSettings.replaceSchemaClassName(classNameFirst) : classNameFirst;
        this.mClassNameSecond = brand ? JServerSettings.replaceSchemaClassName(classNameSecond) : classNameSecond;
        this.mPropertyNameFirst = propNameFirst;
        this.mPropertyNameSecond = propNameSecond;
        this.mAdditionalProperties = null == additionalProperties ? null : new ArrayList(Arrays.asList(additionalProperties));
    }

    public CloseableIterator<CIMInstance> associators(CIMObjectPath assocName, CIMObjectPath target, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        ArrayList<CIMInstance> l = new ArrayList<CIMInstance>();
        String objName = target.getObjectName();
        String clz2Enum = null;
        if (objName.equalsIgnoreCase(this.mClassNameFirst)) {
            if ((null == role || role.equalsIgnoreCase(this.mPropertyNameFirst)) && (null == resultRole || resultRole.equalsIgnoreCase(this.mPropertyNameSecond))) {
                clz2Enum = this.mClassNameSecond;
            }
        } else if (objName.equalsIgnoreCase(this.mClassNameSecond) && (null == role || role.equalsIgnoreCase(this.mPropertyNameSecond)) && (null == resultRole || resultRole.equalsIgnoreCase(this.mPropertyNameFirst))) {
            clz2Enum = this.mClassNameFirst;
        }
        if (null != clz2Enum) {
            FQLParser fqlParser = FQLParser.getFQLParser((String)filterQueryLanguage, (String)filterQuery, (CIMObjectPath)assocName, (WBEMOperation)WBEMOperation.OPENASSOCIATORS);
            CIMObjectPath enumOp = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), assocName.getNamespace(), clz2Enum, null);
            UnsignedInteger32 maxObjects = new UnsignedInteger32(100L);
            EnumerateResponse response = mHandle.enumerateInstances(enumOp, propertyList, null, null, null, false, maxObjects);
            boolean gotFirst = false;
            while (!gotFirst || !response.isEnd()) {
                if (gotFirst) {
                    response = mHandle.getInstancesWithPath(enumOp, response.getContext(), maxObjects);
                } else {
                    gotFirst = true;
                }
                CloseableIterator iter = response.getResponses();
                while (null != iter && iter.hasNext()) {
                    CIMInstance ci = (CIMInstance)iter.next();
                    if (this.filterInstance(target, ci) || !fqlParser.evaluate(ci)) continue;
                    l.add(ci.filterProperties(propertyList));
                }
            }
        }
        return new CloseableAddableIterator(l);
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath target, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        ArrayList<CIMInstance> l = new ArrayList<CIMInstance>();
        FQLParser fqlParser = FQLParser.getFQLParser((String)filterQueryLanguage, (String)filterQuery, (CIMObjectPath)target, (WBEMOperation)WBEMOperation.ENUMERATEINSTANCES);
        CIMObjectPath firstClassOP = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), target.getNamespace(), this.mClassNameFirst, null);
        CloseableIterator i = mHandle.enumerateInstances(firstClassOP, null);
        while (null != i && i.hasNext()) {
            CIMInstance firstClassInstance = (CIMInstance)i.next();
            CIMObjectPath systemOP = firstClassInstance.getObjectPath();
            CIMObjectPath dependentClassOP = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), target.getNamespace(), this.mClassNameSecond, null);
            CloseableIterator ii = mHandle.enumerateInstances(dependentClassOP, null);
            while (ii.hasNext()) {
                CIMInstance secondClassInstance = (CIMInstance)ii.next();
                CIMInstance retInst = this.generateInstance(this.generateObjectPath(target, systemOP, secondClassInstance.getObjectPath()));
                if (this.filterInstance(firstClassInstance, secondClassInstance) || !fqlParser.evaluate(retInst)) continue;
                l.add(retInst.filterProperties(propertyList));
            }
        }
        return new CloseableAddableIterator(l);
    }

    public boolean filterInstance(CIMInstance target, CIMInstance instance) {
        return false;
    }

    private boolean filterInstance(CIMObjectPath target, CIMInstance instance) throws WBEMException {
        CIMInstance ci = mHandle.getInstance(target, null);
        return this.filterInstance(ci, instance);
    }

    protected CIMInstance generateInstance(CIMObjectPath op) throws WBEMException {
        CIMProperty propFirst = op.getKey(this.mPropertyNameFirst);
        CIMProperty propSecond = op.getKey(this.mPropertyNameSecond);
        CIMObjectPath antecedentKey = (CIMObjectPath)propFirst.getValue();
        CIMObjectPath dependentKey = (CIMObjectPath)propSecond.getValue();
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(new CIMProperty(this.mPropertyNameFirst, new CIMDataType(this.mClassNameFirst), (Object)antecedentKey, true));
        l.add(new CIMProperty(this.mPropertyNameSecond, new CIMDataType(this.mClassNameSecond), (Object)dependentKey, true));
        if (null != this.mAdditionalProperties) {
            l.addAll(this.mAdditionalProperties);
        }
        return new CIMInstance(op, l.toArray(new CIMProperty[l.size()]));
    }

    private CIMObjectPath generateObjectPath(CIMObjectPath target, CIMObjectPath first, CIMObjectPath second) {
        CIMProperty[] cpArray = new CIMProperty[]{new CIMProperty(this.mPropertyNameFirst, new CIMDataType(this.mClassNameFirst), (Object)first, true), new CIMProperty(this.mPropertyNameSecond, new CIMDataType(this.mClassNameSecond), (Object)second, true)};
        return new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), target.getNamespace(), this.mClassName, cpArray);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        if (op == null || op.getKeys() == null || op.getKeys().length != 2) {
            throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)op, (WBEMOperation)WBEMOperation.GETINSTANCE, null);
        }
        CIMInstance ci = this.generateInstance(op);
        return ci.filterProperties(propertyList);
    }

    public CloseableIterator<CIMInstance> references(CIMObjectPath assocName, CIMObjectPath target, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        ArrayList<CIMInstance> returnList = new ArrayList<CIMInstance>();
        String objName = target.getObjectName();
        String clz2Enum = null;
        boolean findingClassnameSecond = true;
        if (objName.equalsIgnoreCase(this.mClassNameFirst) && (role == null || role.equalsIgnoreCase(this.mPropertyNameFirst))) {
            clz2Enum = this.mClassNameSecond;
        } else if (objName.equalsIgnoreCase(this.mClassNameSecond) && (role == null || role.equalsIgnoreCase(this.mPropertyNameSecond))) {
            clz2Enum = this.mClassNameFirst;
            findingClassnameSecond = false;
        }
        if (null != clz2Enum) {
            CIMInstance realTargetInst = mHandle.getInstance(target, null);
            CIMObjectPath realTargetOp = realTargetInst.getObjectPath();
            realTargetInst = null;
            CIMObjectPath opFirst = findingClassnameSecond ? realTargetOp : null;
            CIMObjectPath opSecond = findingClassnameSecond ? null : realTargetOp;
            FQLParser fqlParser = FQLParser.getFQLParser((String)filterQueryLanguage, (String)filterQuery, (CIMObjectPath)assocName, (WBEMOperation)WBEMOperation.OPENREFERENCES);
            UnsignedInteger32 maxObjects = new UnsignedInteger32(100L);
            CIMObjectPath enumOp = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), assocName.getNamespace(), clz2Enum, null);
            EnumerateResponse response = mHandle.enumerateInstances(enumOp, null, null, null, null, false, maxObjects);
            boolean gotFirst = false;
            while (!gotFirst || !response.isEnd()) {
                if (gotFirst) {
                    response = mHandle.getInstancesWithPath(enumOp, response.getContext(), maxObjects);
                } else {
                    gotFirst = true;
                }
                CloseableIterator iter = response.getResponses();
                while (null != iter && iter.hasNext()) {
                    CIMInstance ci = (CIMInstance)iter.next();
                    if (this.filterInstance(target, ci) || !fqlParser.evaluate(ci)) continue;
                    if (findingClassnameSecond) {
                        opSecond = ci.getObjectPath();
                    } else {
                        opFirst = ci.getObjectPath();
                    }
                    CIMProperty[] cpArray = new CIMProperty[]{new CIMProperty(this.mPropertyNameFirst, new CIMDataType(this.mClassNameFirst), (Object)opFirst, true), new CIMProperty(this.mPropertyNameSecond, new CIMDataType(this.mClassNameSecond), (Object)opSecond, true)};
                    CIMInstance retInstance = this.generateInstance(new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), assocName.getNamespace(), this.mClassName, cpArray));
                    returnList.add(retInstance.filterProperties(propertyList));
                }
            }
        }
        return new CloseableAddableIterator(returnList);
    }
}

