/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.common;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.CIMRepository;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.query.WBEMQuery;
import com.ws.wbem.query.WBEMQueryLanguageFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;
import org.wbemservices.wbem.repository.PSRlogImpl;

public abstract class WSBaseProvider {
    private static final String CPN_INSTALLDATE = "InstallDate";
    private static final String CPN_SYSTEMNAME = "SystemName";
    private static boolean mInitialized = false;
    protected static final String UNKNOWN = "unknown";
    protected static CIMRepository mInternalProvider;
    protected static ProviderHandle mHandle;
    protected static Logger mLogger;

    protected void checkArguments(CIMObjectPath target, WBEMOperation operation, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        if (continueOnError) {
            throw WBEMOperationErrors.getContinuationOnErrorNotSupportedException((CIMObjectPath)target, (WBEMOperation)operation, null);
        }
    }

    public CIMInstance checkInstallDate(CIMInstance ci) {
        if (ci != null) {
            CIMDateTime installdatevalue = (CIMDateTime)ci.getPropertyValue(CPN_INSTALLDATE);
            String installdate = JServerProperties.getInstallDate();
            if (installdate != null && installdate.length() > 0 && installdatevalue == null) {
                try {
                    CIMDateTimeAbsolute dt = new CIMDateTimeAbsolute(installdate);
                    CIMProperty cpInstallDate = new CIMProperty(CPN_INSTALLDATE, CIMDataType.DATETIME_T, (Object)dt, false);
                    CIMProperty[] props = ci.getProperties();
                    List<CIMProperty> l = Arrays.asList(props);
                    ArrayList<CIMProperty> list = new ArrayList<CIMProperty>(l);
                    list.add(cpInstallDate);
                    props = list.toArray(new CIMProperty[list.size()]);
                    ci = new CIMInstance(ci.getObjectPath(), props);
                }
                catch (Throwable e) {
                    mLogger.warning("Received exception trying to set installdate: " + e.getLocalizedMessage());
                }
            }
        }
        return ci;
    }

    protected CIMInstance cleanAssociationSystemName(CIMInstance pInst) {
        CIMProperty[] keys;
        CIMInstance ret = pInst;
        if (pInst != null && (keys = pInst.getKeys()) != null && keys.length == 2 && keys[0] != null && keys[1] != null) {
            CIMObjectPath op = pInst.getObjectPath();
            CIMObjectPath ref1 = this.cleanSystemName((CIMObjectPath)keys[0].getValue());
            CIMObjectPath ref2 = this.cleanSystemName((CIMObjectPath)keys[1].getValue());
            CIMProperty[] newKeys = new CIMProperty[]{new CIMProperty(keys[0].getName(), keys[0].getDataType(), (Object)ref1, keys[0].isKey()), new CIMProperty(keys[1].getName(), keys[1].getDataType(), (Object)ref2, keys[1].isKey())};
            ret = pInst.deriveInstance(newKeys);
            if (op != null) {
                ret = ret.deriveInstance(new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), op.getObjectName(), newKeys));
            }
        }
        return ret;
    }

    protected CIMObjectPath cleanAssociationSystemName(CIMObjectPath pOP) {
        CIMProperty[] keys;
        CIMObjectPath ret = pOP;
        if (pOP != null && (keys = pOP.getKeys()) != null && keys.length == 2 && keys[0] != null && keys[1] != null) {
            CIMObjectPath ref1 = this.cleanSystemName((CIMObjectPath)keys[0].getValue());
            CIMObjectPath ref2 = this.cleanSystemName((CIMObjectPath)keys[1].getValue());
            if (ref1 != null && ref2 != null) {
                if (ref1.getNamespace() == null || ref1.getNamespace().length() == 0) {
                    ref1 = new CIMObjectPath(ref1.getScheme(), ref1.getHost(), ref1.getPort(), pOP.getNamespace(), ref1.getObjectName(), ref1.getKeys());
                }
                if (ref2.getNamespace() == null || ref2.getNamespace().length() == 0) {
                    ref2 = new CIMObjectPath(ref2.getScheme(), ref2.getHost(), ref2.getPort(), pOP.getNamespace(), ref2.getObjectName(), ref2.getKeys());
                }
                CIMProperty[] newKeys = new CIMProperty[]{new CIMProperty(keys[0].getName(), keys[0].getDataType(), (Object)ref1, keys[0].isKey()), new CIMProperty(keys[1].getName(), keys[1].getDataType(), (Object)ref2, keys[1].isKey())};
                ret = new CIMObjectPath(pOP.getScheme(), pOP.getHost(), pOP.getPort(), pOP.getNamespace(), pOP.getObjectName(), newKeys);
            }
        }
        return ret;
    }

    protected CIMInstance cleanInstance(CIMObjectPath opSpecified, CIMInstance pInstance) {
        ArrayList<CIMProperty> l = new ArrayList<CIMProperty>();
        CIMInstance ret = pInstance;
        if (pInstance != null && pInstance.getProperties() != null) {
            CIMProperty[] props;
            for (CIMProperty p : props = pInstance.getProperties()) {
                if (p != null && p.getValue() != null && p.getValue() instanceof CIMObjectPath) {
                    CIMObjectPath opPropValue = (CIMObjectPath)p.getValue();
                    CIMObjectPath opUpdated = new CIMObjectPath(opSpecified.getScheme(), opSpecified.getHost(), opSpecified.getPort(), opSpecified.getNamespace(), opPropValue.getObjectName(), opPropValue.getKeys());
                    l.add(new CIMProperty(p.getName(), p.getDataType(), (Object)opUpdated, p.isKey()));
                    continue;
                }
                l.add(p);
            }
            ret = new CIMInstance(this.cleanObjectPath(opSpecified, pInstance.getObjectPath()), l.toArray(new CIMProperty[l.size()]));
        }
        return ret;
    }

    protected CIMObjectPath cleanObjectPath(CIMObjectPath opSpecified, CIMObjectPath pPath) {
        ArrayList<CIMProperty> l = new ArrayList<CIMProperty>();
        if (pPath != null && pPath.getKeys() != null) {
            for (CIMProperty p : pPath.getKeys()) {
                if (p != null && p.getValue() != null && p.getValue() instanceof CIMObjectPath) {
                    CIMObjectPath opPropValue = (CIMObjectPath)p.getValue();
                    CIMObjectPath opUpdated = new CIMObjectPath(opSpecified.getScheme(), opSpecified.getHost(), opSpecified.getPort(), opSpecified.getNamespace(), opPropValue.getObjectName(), opPropValue.getKeys());
                    l.add(new CIMProperty(p.getName(), p.getDataType(), (Object)opUpdated, p.isKey()));
                    continue;
                }
                l.add(p);
            }
        }
        return pPath == null ? null : new CIMObjectPath(opSpecified.getScheme(), opSpecified.getHost(), opSpecified.getPort(), opSpecified.getNamespace(), pPath.getObjectName(), l.toArray(new CIMProperty[l.size()]));
    }

    protected CIMInstance cleanSystemName(CIMInstance pInst) {
        return this.modifyStringPropertyValue(pInst, CPN_SYSTEMNAME, UNKNOWN);
    }

    protected CIMObjectPath cleanSystemName(CIMObjectPath pOP) {
        return this.modifyStringPropertyValue(pOP, CPN_SYSTEMNAME, UNKNOWN);
    }

    public void close() throws WBEMException {
    }

    public CIMInstance deriveInstance(CIMInstance pInst, CIMProperty<?>[] pArray) {
        if (null == pInst || pArray == null || pArray.length == 0) {
            return pInst;
        }
        CIMProperty[] props = pInst.getProperties();
        ArrayList<Object> l = new ArrayList<Object>();
        HashSet<String> updatedProps = new HashSet<String>();
        if (null != props) {
            for (CIMProperty<?> cIMProperty : props) {
                CIMProperty<?> p = cIMProperty;
                if (p == null) continue;
                for (CIMProperty<?> cIMProperty2 : pArray) {
                    if (p.getName() == null || cIMProperty2 == null || cIMProperty2.getName() == null || !cIMProperty2.getName().equalsIgnoreCase(p.getName())) continue;
                    p = cIMProperty2;
                    updatedProps.add(p.getName());
                }
                l.add(p);
            }
        }
        for (CIMProperty cIMProperty : pArray) {
            if (updatedProps.contains(cIMProperty.getName())) continue;
            l.add(cIMProperty);
        }
        return new CIMInstance(pInst.getObjectPath(), l.toArray(new CIMProperty[l.size()]));
    }

    protected synchronized CloseableIterator<CIMInstance> execQuery(CIMObjectPath op, String query, String ql, Iterator<CIMInstance> ciArr) throws WBEMException {
        if (null == ciArr) {
            return new CloseableAddableIterator(Collections.emptyList());
        }
        WBEMQuery wq = null;
        try {
            wq = WBEMQueryLanguageFactory.getQuery((String)ql);
        }
        catch (Exception e) {
            throw WBEMOperationErrors.getUnknownQueryLanguageException((CIMObjectPath)op, (String)ql, null, (WBEMOperation)WBEMOperation.EXECUTEQUERY);
        }
        if (!wq.initialize(query)) {
            throw WBEMOperationErrors.getInvalidQueryException((CIMObjectPath)op, (String)ql, (String)query, (WBEMOperation)WBEMOperation.EXECUTEQUERY, null);
        }
        CloseableAddableIterator result = new CloseableAddableIterator();
        try {
            while (ciArr.hasNext()) {
                CIMInstance ci = ciArr.next();
                if (!wq.testWhereClause(ci)) continue;
                result.add((Object)wq.applySelectList(ci));
            }
        }
        catch (Exception ex) {
            if (ex instanceof WBEMException) {
                throw (WBEMException)((Object)ex);
            }
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)op, (Throwable)ex, (WBEMOperation)WBEMOperation.EXECUTEQUERY, null);
        }
        result.done();
        return result;
    }

    protected CIMInstance fixAssociationSystemName(CIMInstance pInst) {
        CIMProperty[] keys;
        CIMInstance ret = pInst;
        if (pInst != null && (keys = pInst.getKeys()) != null && keys.length == 2 && keys[0] != null && keys[1] != null) {
            CIMObjectPath ref1 = this.fixSystemName((CIMObjectPath)keys[0].getValue());
            CIMObjectPath ref2 = this.fixSystemName((CIMObjectPath)keys[1].getValue());
            CIMProperty[] newKeys = new CIMProperty[]{new CIMProperty(keys[0].getName(), keys[0].getDataType(), (Object)ref1, keys[0].isKey()), new CIMProperty(keys[1].getName(), keys[1].getDataType(), (Object)ref2, keys[1].isKey())};
            ret = pInst.deriveInstance(newKeys);
            CIMObjectPath op = pInst.getObjectPath();
            if (op != null) {
                ret = ret.deriveInstance(new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), op.getObjectName(), newKeys));
            }
        }
        return ret;
    }

    protected CIMObjectPath fixAssociationSystemName(CIMObjectPath pOP) {
        CIMProperty[] keys;
        CIMObjectPath ret = pOP;
        if (pOP != null && (keys = pOP.getKeys()) != null && keys.length == 2 && keys[0] != null && keys[1] != null) {
            CIMObjectPath ref1 = this.fixSystemName((CIMObjectPath)keys[0].getValue());
            CIMObjectPath ref2 = this.fixSystemName((CIMObjectPath)keys[1].getValue());
            CIMProperty[] newKeys = new CIMProperty[]{new CIMProperty(keys[0].getName(), keys[0].getDataType(), (Object)ref1, keys[0].isKey()), new CIMProperty(keys[1].getName(), keys[1].getDataType(), (Object)ref2, keys[1].isKey())};
            ret = new CIMObjectPath(pOP.getScheme(), pOP.getHost(), pOP.getPort(), pOP.getNamespace(), pOP.getObjectName(), newKeys);
        }
        return ret;
    }

    protected CloseableIterator<CIMInstance> fixAssociationSystemNameInstances(CloseableIterator<CIMInstance> pInstances) {
        CloseableAddableIterator ret = new CloseableAddableIterator();
        while (null != pInstances && pInstances.hasNext()) {
            ret.add((Object)this.fixAssociationSystemName((CIMInstance)pInstances.next()));
        }
        ret.done();
        return ret;
    }

    protected CloseableIterator<CIMObjectPath> fixAssociationSystemNameObjectPaths(CloseableIterator<CIMObjectPath> pObjectPaths) {
        CloseableAddableIterator ret = new CloseableAddableIterator();
        while (null != pObjectPaths && pObjectPaths.hasNext()) {
            ret.add((Object)this.fixAssociationSystemName((CIMObjectPath)pObjectPaths.next()));
        }
        ret.done();
        return ret;
    }

    protected CIMInstance fixInstanceOP(CIMInstance pInstance) {
        return pInstance == null ? null : new CIMInstance(pInstance.getObjectPath(), pInstance.getProperties());
    }

    protected CIMInstance fixSystemName(CIMInstance pInst) {
        return this.modifyStringPropertyValue(pInst, CPN_SYSTEMNAME, JServerProperties.getServerHost());
    }

    protected CIMObjectPath fixSystemName(CIMObjectPath pOP) {
        return this.modifyStringPropertyValue(pOP, CPN_SYSTEMNAME, JServerProperties.getServerHost());
    }

    protected CloseableIterator<CIMInstance> fixSystemNameInstances(CloseableIterator<CIMInstance> pInstances) {
        CloseableAddableIterator ret = new CloseableAddableIterator();
        while (null != pInstances && pInstances.hasNext()) {
            ret.add((Object)this.fixSystemName((CIMInstance)pInstances.next()));
        }
        ret.done();
        return ret;
    }

    protected CloseableIterator<CIMObjectPath> fixSystemNameObjectPaths(CloseableIterator<CIMObjectPath> pObjectPaths) {
        CloseableAddableIterator ret = new CloseableAddableIterator();
        while (null != pObjectPaths && pObjectPaths.hasNext()) {
            ret.add((Object)this.fixSystemName((CIMObjectPath)pObjectPaths.next()));
        }
        ret.done();
        return ret;
    }

    public String getHostName() {
        return JServerProperties.getServerHost();
    }

    protected String[] getListofChanges(CIMInstance pOriginal, CIMInstance pNew) {
        String[] ret = null;
        if (pOriginal != null && pNew != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (CIMProperty p : pOriginal.getProperties()) {
                CIMProperty nProp = pNew.getProperty(p.getName());
                if (this.isPropertyEqual(p, nProp, false)) continue;
                list.add(p.getName());
            }
            if (list.size() == 0) {
                ret = null;
            }
            ret = list.toArray(new String[list.size()]);
        }
        return ret;
    }

    public CIMObjectPath getModelPath(CIMObjectPath pOP) {
        CIMObjectPath ret = null;
        if (pOP != null) {
            ret = new CIMObjectPath(pOP.getScheme(), pOP.getHost(), pOP.getPort(), pOP.getNamespace(), pOP.getObjectName(), pOP.getKeys());
        }
        return ret;
    }

    public void initialize(ProviderHandle handle) throws WBEMException {
        WSBaseProvider.setHandle(handle);
        if (!mInitialized && !"true".equals(System.getProperty("com.ws.wbem.build"))) {
            mInternalProvider = PSRlogImpl.getRepository();
            mInitialized = true;
        }
    }

    private static void setHandle(ProviderHandle handle) {
        mHandle = handle;
    }

    protected boolean instanceExists(CIMObjectPath op) throws WBEMException {
        boolean ret;
        block2: {
            ret = false;
            try {
                mHandle.getInstance(op, new String[0]);
                ret = true;
            }
            catch (WBEMException we) {
                if (we.getID() == 6) break block2;
                throw we;
            }
        }
        return ret;
    }

    public Object invokeMethod(CIMObjectPath target, String methodName, CIMArgument<?>[] inputArguments, CIMArgument<?>[] outputArguments) throws WBEMException {
        throw WBEMOperationErrors.getNoSuchMethodException((CIMObjectPath)target, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
    }

    protected boolean isPropertyEqual(CIMProperty<?> p1, CIMProperty<?> p2, boolean matchArrayOrder) {
        boolean ret = true;
        if (p1 != null && p2 != null) {
            if (p1 == null || p2 == null) {
                ret = false;
            } else if (p1.getValue() != null && p2.getValue() != null) {
                if (p1.getValue() == null || p2.getValue() == null) {
                    ret = false;
                } else if (!p2.getDataType().isArray()) {
                    if (!p2.getValue().equals(p1.getValue())) {
                        ret = false;
                    }
                } else {
                    Object[] p1Val = (Object[])p1.getValue();
                    Object[] p2Val = (Object[])p2.getValue();
                    if (matchArrayOrder) {
                        ret = Arrays.equals(p1Val, p2Val);
                    } else {
                        List<Object> p1List = Arrays.asList(p1Val);
                        if (!p1List.containsAll(Arrays.asList(p2Val))) {
                            ret = false;
                        }
                    }
                }
            }
        }
        return ret;
    }

    protected boolean isTypeOf(String namespace, String className, String parentClassName) {
        if (className.equalsIgnoreCase(parentClassName)) {
            return true;
        }
        try {
            CloseableIterator<CIMObjectPath> iCOP = mInternalProvider.enumerateClassNames(new CIMObjectPath(null, null, null, namespace, parentClassName, null), true);
            while (iCOP.hasNext()) {
                CIMObjectPath cop = (CIMObjectPath)iCOP.next();
                if (!className.equalsIgnoreCase(cop.getObjectName())) continue;
                return true;
            }
        }
        catch (WBEMException e) {
            return false;
        }
        return false;
    }

    protected CIMInstance modifyPropertyValue(CIMInstance pInst, String pPropName, Object pPropValue) {
        CIMInstance ret = pInst;
        if (pInst != null) {
            CIMProperty[] props = pInst.getProperties();
            CIMProperty[] newProps = new CIMProperty[props.length];
            for (int i = 0; i < props.length; ++i) {
                CIMProperty prop = props[i];
                newProps[i] = pPropName.equals(prop.getName()) ? new CIMProperty(pPropName, prop.getDataType(), pPropValue, prop.isKey()) : (prop.getDataType().getType() == 14 ? new CIMProperty(prop.getName(), prop.getDataType(), (Object)this.modifyPropertyValue((CIMObjectPath)prop.getValue(), pPropName, pPropValue), prop.isKey()) : props[i]);
            }
            CIMObjectPath newOP = this.modifyPropertyValue(pInst.getObjectPath(), pPropName, pPropValue);
            ret = new CIMInstance(newOP, newProps);
        }
        return ret;
    }

    protected CIMObjectPath modifyPropertyValue(CIMObjectPath pOP, String pPropName, Object pPropValue) {
        CIMObjectPath ret = pOP;
        if (pOP != null && pOP.getKeys() != null) {
            CIMProperty[] keys = pOP.getKeys();
            CIMProperty[] newKeys = new CIMProperty[keys.length];
            CIMProperty prop = pOP.getKey(pPropName);
            for (int i = 0; i < keys.length; ++i) {
                newKeys[i] = keys[i].equals((Object)prop) ? new CIMProperty(pPropName, prop.getDataType(), pPropValue, true) : (keys[i].getDataType().getType() == 14 ? new CIMProperty(keys[i].getName(), keys[i].getDataType(), (Object)this.modifyPropertyValue((CIMObjectPath)keys[i].getValue(), pPropName, pPropValue), true) : keys[i]);
            }
            ret = new CIMObjectPath(pOP.getScheme(), pOP.getHost(), pOP.getPort(), pOP.getNamespace(), pOP.getObjectName(), newKeys);
        }
        return ret;
    }

    protected CIMInstance modifyStringPropertyValue(CIMInstance pInst, String pPropName, String pPropValue) {
        CIMInstance ret = pInst;
        if (pInst != null) {
            CIMProperty[] props = pInst.getProperties();
            CIMProperty[] newProps = new CIMProperty[props.length];
            for (int i = 0; i < props.length; ++i) {
                CIMProperty prop = props[i];
                newProps[i] = null != prop && pPropName.equals(prop.getName()) ? new CIMProperty(pPropName, CIMDataType.STRING_T, (Object)pPropValue, prop.isKey()) : prop;
            }
            CIMObjectPath newOP = this.modifyStringPropertyValue(pInst.getObjectPath(), pPropName, pPropValue);
            ret = new CIMInstance(newOP, newProps);
        }
        return ret;
    }

    protected CIMObjectPath modifyStringPropertyValue(CIMObjectPath pOP, String pPropName, String pPropValue) {
        CIMObjectPath ret = pOP;
        if (pOP != null && pOP.getKeys() != null) {
            CIMProperty[] keys = pOP.getKeys();
            CIMProperty[] newKeys = new CIMProperty[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                CIMProperty key = keys[i];
                newKeys[i] = null != key && pPropName.equals(key.getName()) ? new CIMProperty(pPropName, CIMDataType.STRING_T, (Object)pPropValue, true) : key;
            }
            ret = new CIMObjectPath(pOP.getScheme(), pOP.getHost(), pOP.getPort(), pOP.getNamespace(), pOP.getObjectName(), newKeys);
        }
        return ret;
    }

    protected CIMInstance setAssociationNamespace(CIMInstance pInst, String pNewNamespace) {
        CIMProperty[] keys;
        CIMInstance ret = pInst;
        if (pInst != null && (keys = pInst.getKeys()) != null && keys.length == 2 && keys[0] != null && keys[1] != null) {
            CIMObjectPath ref1 = this.setNamespace((CIMObjectPath)keys[0].getValue(), pNewNamespace);
            CIMObjectPath ref2 = this.setNamespace((CIMObjectPath)keys[1].getValue(), pNewNamespace);
            CIMProperty[] newKeys = new CIMProperty[]{new CIMProperty(keys[0].getName(), keys[0].getDataType(), (Object)ref1, keys[0].isKey()), new CIMProperty(keys[1].getName(), keys[1].getDataType(), (Object)ref2, keys[1].isKey())};
            ret = pInst.deriveInstance(newKeys);
            CIMObjectPath op = pInst.getObjectPath();
            if (op != null) {
                ret = ret.deriveInstance(new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), pNewNamespace, op.getObjectName(), newKeys));
            }
        }
        return ret;
    }

    protected CIMObjectPath setAssociationNamespace(CIMObjectPath pOP, String pNewNamespace) {
        CIMProperty[] keys;
        CIMObjectPath ret = pOP;
        if (pOP != null && (keys = pOP.getKeys()) != null && keys.length == 2 && keys[0] != null && keys[1] != null) {
            CIMObjectPath ref1 = this.setNamespace((CIMObjectPath)keys[0].getValue(), pNewNamespace);
            CIMObjectPath ref2 = this.setNamespace((CIMObjectPath)keys[1].getValue(), pNewNamespace);
            CIMProperty[] newKeys = new CIMProperty[]{new CIMProperty(keys[0].getName(), keys[0].getDataType(), (Object)ref1, keys[0].isKey()), new CIMProperty(keys[1].getName(), keys[1].getDataType(), (Object)ref2, keys[1].isKey())};
            ret = new CIMObjectPath(pOP.getScheme(), pOP.getHost(), pOP.getPort(), pNewNamespace, pOP.getObjectName(), newKeys);
        }
        return ret;
    }

    protected CloseableIterator<CIMInstance> setAssociationNamespaceInstances(CloseableIterator<CIMInstance> pInstances, String pNewNamespace) {
        CloseableAddableIterator ret = new CloseableAddableIterator();
        while (null != pInstances && pInstances.hasNext()) {
            ret.add((Object)this.setAssociationNamespace((CIMInstance)pInstances.next(), pNewNamespace));
        }
        ret.done();
        return ret;
    }

    protected CloseableIterator<CIMObjectPath> setAssociationNamespaceObjectPaths(CloseableIterator<CIMObjectPath> pObjectPaths, String pNewNamespace) {
        CloseableAddableIterator ret = new CloseableAddableIterator();
        while (null != pObjectPaths && pObjectPaths.hasNext()) {
            ret.add((Object)this.setAssociationNamespace((CIMObjectPath)pObjectPaths.next(), pNewNamespace));
        }
        ret.done();
        return ret;
    }

    public CIMObjectPath setDefaultNamespace(CIMObjectPath pOriginalOp, CIMObjectPath defaultPath) {
        if (pOriginalOp != null && (pOriginalOp.getNamespace() == null || pOriginalOp.getNamespace().length() == 0)) {
            if (null != defaultPath && null != defaultPath.getNamespace()) {
                return new CIMObjectPath(pOriginalOp.getScheme(), pOriginalOp.getHost(), pOriginalOp.getPort(), defaultPath.getNamespace(), pOriginalOp.getObjectName(), pOriginalOp.getKeys());
            }
            return new CIMObjectPath(pOriginalOp.getScheme(), pOriginalOp.getHost(), pOriginalOp.getPort(), "", pOriginalOp.getObjectName(), pOriginalOp.getKeys());
        }
        return pOriginalOp;
    }

    public CIMObjectPath setInteropNamespace(CIMObjectPath pOriginalOp) {
        return JServerProperties.getInteropNamespace().equalsIgnoreCase(pOriginalOp.getNamespace()) ? pOriginalOp : this.setNamespace(pOriginalOp, JServerProperties.getInteropNamespace());
    }

    public CIMInstance setNamespace(CIMInstance pOriginInstance, String pNewNamespace) {
        CIMObjectPath newOP = this.setNamespace(pOriginInstance.getObjectPath(), pNewNamespace);
        return new CIMInstance(newOP, pOriginInstance.getProperties());
    }

    public CIMObjectPath setNamespace(CIMObjectPath pOriginalOp, String pNewNamespace) {
        CIMObjectPath ret = pOriginalOp;
        if (pOriginalOp != null) {
            ret = new CIMObjectPath(pOriginalOp.getScheme(), pOriginalOp.getHost(), pOriginalOp.getPort(), pNewNamespace, pOriginalOp.getObjectName(), pOriginalOp.getKeys());
        }
        return ret;
    }

    public CloseableIterator<CIMInstance> setNamespaceInstances(CloseableIterator<CIMInstance> pOriginalIter, String pNewNamespace) {
        CloseableAddableIterator instanceList = new CloseableAddableIterator();
        while (null != pOriginalIter && pOriginalIter.hasNext()) {
            CIMInstance origInstance = (CIMInstance)pOriginalIter.next();
            CIMObjectPath newOP = this.setNamespace(origInstance.getObjectPath(), pNewNamespace);
            instanceList.add((Object)new CIMInstance(newOP, origInstance.getProperties()));
        }
        instanceList.done();
        return instanceList;
    }

    public CloseableIterator<CIMObjectPath> setNamespaceObjectPaths(CloseableIterator<CIMObjectPath> pOriginalIter, String pNewNamespace) {
        CloseableAddableIterator objectPathList = new CloseableAddableIterator();
        while (null != pOriginalIter && pOriginalIter.hasNext()) {
            objectPathList.add((Object)this.setNamespace((CIMObjectPath)pOriginalIter.next(), pNewNamespace));
        }
        objectPathList.done();
        return objectPathList;
    }

    static {
        mLogger = Logger.getLogger("com.ws.wbem.jserver");
    }
}

