/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.ws.wbemserver;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.JServerTrace;
import com.ws.wbem.jserver.JServerTraceProperties;
import com.ws.wbem.jserver.profiles.common.BaseInstanceProvider;
import com.ws.wbem.query.fql.FQLParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;

public class WBEMServerLogSettingDataProvider
extends BaseInstanceProvider {
    private static final String CPV_INSTANCEID = " WBEMServerLogSettingData:00001";
    private JServerTraceProperties mProperties;

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        Object ret = null != this.mProperties ? FQLParser.evaluate((CIMInstance)this.generateInstance(op, propertyList), (String)filterQueryLanguage, (String)filterQuery, (String[])propertyList, (WBEMOperation)WBEMOperation.ENUMERATEINSTANCES) : new CloseableAddableIterator(Collections.emptyList());
        return ret;
    }

    private CIMInstance generateInstance(CIMObjectPath op, String[] propertyList) {
        CIMObjectPath newOp = this.generateObjectPath(op);
        CIMProperty[] keyProps = newOp.getKeys();
        Level x = JServerTraceProperties.getLogLevel();
        CIMProperty[] props = new CIMProperty[]{keyProps[0], new CIMProperty("TraceFormat", CIMDataType.STRING_T, (Object)JServerTraceProperties.getLogFormat()), new CIMProperty("DebugLevel", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(x == Level.ALL ? 0 : (x == Level.OFF ? 10000 : x.intValue()))), new CIMProperty("Directory", CIMDataType.STRING_T, (Object)JServerTraceProperties.getLogFileDirectory()), new CIMProperty("FileName", CIMDataType.STRING_T, (Object)JServerTraceProperties.getLogFileName()), new CIMProperty("MaxLogSize", CIMDataType.STRING_T, (Object)JServerTraceProperties.getMaxLogFileSize()), new CIMProperty("NumberOfLogFiles", CIMDataType.STRING_T, (Object)JServerTraceProperties.getNumberOfLogs())};
        return new CIMInstance(newOp, props);
    }

    private CIMObjectPath generateObjectPath(CIMObjectPath op) {
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)CPV_INSTANCEID, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), JServerProperties.getInteropNamespace(), this.mClassName, keyProps);
    }

    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        if (null != this.mProperties && op.getKeyValue("InstanceID").equals(CPV_INSTANCEID)) {
            return this.fixInstanceOP(this.generateInstance(op, propertyList)).filterProperties(propertyList);
        }
        throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)op, (WBEMOperation)WBEMOperation.GETINSTANCE, null);
    }

    @Override
    public void initialize(ProviderHandle handle) throws WBEMException {
        super.initialize(handle);
        this.mClassName = JServerSettings.replaceSchemaClassName("WS_WBEMServerLogSettingData");
        try {
            this.mProperties = new JServerTraceProperties();
        }
        catch (Exception e) {
            this.mProperties = null;
        }
    }

    @Override
    public void modifyInstance(CIMInstance ci, String[] propertyList) throws WBEMException {
        if (null == ci) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)new CIMObjectPath("WS_WBEMServerLogSettingData"), (String)"The ModifiedInstance is invalid: null", (WBEMOperation)WBEMOperation.MODIFYINSTANCE, null);
        }
        if (null != this.mProperties && ci.getObjectPath().getKeyValue("InstanceID").equals(CPV_INSTANCEID)) {
            String numLogs;
            String size;
            String filename;
            String dir;
            Object[] propsToChange = propertyList;
            if (null == propertyList) {
                propsToChange = new String[]{"TraceFormat", "DebugLevel", "Directory", "FileName", "MaxLogSize", "NumberOfLogFiles"};
            }
            Arrays.sort(propsToChange);
            if (Arrays.binarySearch(propsToChange, "TraceFormat") > -1) {
                String traceFormat = (String)ci.getPropertyValue("TraceFormat");
                JServerTraceProperties.setLogFormat(traceFormat);
            }
            if (Arrays.binarySearch(propsToChange, "Directory") > -1 && null != (dir = (String)ci.getPropertyValue("Directory"))) {
                JServerTraceProperties.setLogFileDirectoy(dir);
            }
            if (Arrays.binarySearch(propsToChange, "FileName") > -1 && null != (filename = (String)ci.getPropertyValue("FileName"))) {
                JServerTraceProperties.setLogFileName(filename);
            }
            if (Arrays.binarySearch(propsToChange, "MaxLogSize") > -1 && null != (size = (String)ci.getPropertyValue("MaxLogSize"))) {
                JServerTraceProperties.setMaxLogFileSize(size);
            }
            if (Arrays.binarySearch(propsToChange, "NumberOfLogFiles") > -1 && null != (numLogs = (String)ci.getPropertyValue("NumberOfLogFiles"))) {
                JServerTraceProperties.setNumberOfLogs(numLogs);
            }
            if (Arrays.binarySearch(propsToChange, "DebugLevel") > -1) {
                Level newLevel = JServerTraceProperties.getLogLevel();
                UnsignedInteger16 debugLevel = (UnsignedInteger16)ci.getPropertyValue("DebugLevel");
                if (null != debugLevel) {
                    switch (debugLevel.intValue()) {
                        case 0: {
                            newLevel = Level.ALL;
                            break;
                        }
                        case 300: {
                            newLevel = Level.FINEST;
                            break;
                        }
                        case 400: {
                            newLevel = Level.FINER;
                            break;
                        }
                        case 500: {
                            newLevel = Level.FINE;
                            break;
                        }
                        case 700: {
                            newLevel = Level.CONFIG;
                            break;
                        }
                        case 800: {
                            newLevel = Level.INFO;
                            break;
                        }
                        case 900: {
                            newLevel = Level.WARNING;
                            break;
                        }
                        case 1000: {
                            newLevel = Level.SEVERE;
                            break;
                        }
                        case 10000: {
                            newLevel = Level.OFF;
                            break;
                        }
                        default: {
                            newLevel = Level.OFF;
                        }
                    }
                    JServerTraceProperties.setLogLevel(newLevel);
                }
            }
            try {
                this.mProperties.store();
            }
            catch (IOException e) {
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (Throwable)e, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, null);
            }
            JServerTrace.initTrace();
            return;
        }
        throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)ci.getObjectPath(), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, null);
    }
}

