/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.services;

import com.ws.logging.FailSafeLog;
import com.ws.utilities.WSIStandardMessages;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.services.ObjectManagerAdapterService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;
import javax.wbem.provider.PullInstanceProvider;

final class CIMOMServices {
    private final Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    private ObjectManagerAdapterService pch;
    private final ArrayList<CIMInstance> cpaList = new ArrayList();
    private final ArrayList<CIMInstance> ppaList = new ArrayList();
    private final ArrayList<CIMInstance> ihaList = new ArrayList();

    private CIMOMServices() {
    }

    public CIMOMServices(ProviderHandle handle, ObjectManagerAdapterService prov) {
        this();
        this.pch = prov;
        Iterator<CIMInstance> protocols = null;
        try {
            protocols = this.getAllProtocolAdapters(handle, prov);
        }
        catch (Throwable th) {
            this.mLogger.log(Level.SEVERE, "Received Exception trying to get Protocol Adapters", th);
        }
        if (null == protocols || !protocols.hasNext()) {
            FailSafeLog.failSafe((String)WSIStandardMessages.getMessage((String)"ERROR_NO_PROTOCOL_ADAPTERS", null), (Object[])null);
            System.exit(-1);
        }
        while (protocols.hasNext()) {
            CIMInstance ci = protocols.next();
            try {
                UnsignedInteger16 pType = null;
                UnsignedInteger16 cvEnabledDefault = null;
                try {
                    cvEnabledDefault = (UnsignedInteger16)ci.getProperty("EnabledDefault").getValue();
                }
                catch (Exception ex) {
                    continue;
                }
                if (!cvEnabledDefault.equals((Object)new UnsignedInteger16(2))) continue;
                try {
                    pType = (UnsignedInteger16)ci.getProperty("AdapterType").getValue();
                }
                catch (Exception ex) {
                    continue;
                }
                if (pType.equals((Object)new UnsignedInteger16(4))) {
                    this.ihaList.add(ci);
                }
                if (pType.equals((Object)new UnsignedInteger16(2))) {
                    this.cpaList.add(ci);
                }
                if (!pType.equals((Object)new UnsignedInteger16(3))) continue;
                this.ppaList.add(ci);
            }
            catch (Exception e) {
                this.mLogger.log(Level.WARNING, "Received Exception trying to initialize services", e);
            }
        }
    }

    private Iterator<CIMInstance> getAllProtocolAdapters(ProviderHandle handle, PullInstanceProvider prov) {
        ArrayList<CIMInstance> retVal = new ArrayList<CIMInstance>();
        CIMObjectPath path = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), JServerSettings.replaceSchemaClassName("CIM_ObjectManagerAdapter"), null);
        try {
            Iterator<CIMInstance> mcIter = this.getProtocolAdaptersByName(handle, prov, path);
            while (null != mcIter && mcIter.hasNext()) {
                retVal.add(mcIter.next());
            }
            CloseableIterator i = handle.enumerateClasses(path, true, false, true);
            while (i.hasNext()) {
                Iterator<CIMInstance> p = this.getProtocolAdaptersByName(handle, prov, ((CIMClass)i.next()).getObjectPath());
                while (null != p && p.hasNext()) {
                    retVal.add(p.next());
                }
            }
        }
        catch (WBEMException e) {
            this.mLogger.log(Level.WARNING, "Received Exception trying to initialize services", e);
        }
        return retVal.iterator();
    }

    private ArrayList<CIMInstance> getList(int type) {
        switch (type) {
            case 2: {
                return this.cpaList;
            }
            case 3: {
                return this.ppaList;
            }
            case 4: {
                return this.ihaList;
            }
        }
        return null;
    }

    private Iterator<CIMInstance> getProtocolAdaptersByName(ProviderHandle handle, PullInstanceProvider prov, CIMObjectPath name) {
        CloseableIterator protocols = null;
        try {
            prov.initialize(handle);
            protocols = prov.enumerateInstances(name, null, null, null, false);
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "Received Exception trying to initialize services", e);
        }
        return protocols;
    }

    public int startProtocolAdapters(int type) {
        ArrayList<CIMInstance> list = this.getList(type);
        Iterator<CIMInstance> itr = list.iterator();
        int adpatersStarted = 0;
        for (int i = 0; i < list.size(); ++i) {
            try {
                this.startService(itr.next());
                ++adpatersStarted;
                continue;
            }
            catch (Throwable e) {
                Throwable t = e;
                if (null != e.getCause()) {
                    t = e.getCause();
                }
                this.mLogger.log(Level.WARNING, "Received Exception trying to start service", t);
            }
        }
        return adpatersStarted;
    }

    private void startService(CIMInstance ci) throws WBEMException {
        CIMArgument[] outArgs;
        CIMArgument[] inArgs;
        CIMObjectPath op = ci.getObjectPath();
        UnsignedInteger32 ret = this.pch.invokeMethod(op, "StartService", (CIMArgument<?>[])(inArgs = new CIMArgument[0]), (CIMArgument<?>[])(outArgs = new CIMArgument[0]));
        if (ret instanceof UnsignedInteger32) {
            UnsignedInteger32 retVal = ret;
            int val = retVal.intValue();
            if (val != 0) {
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)("StartService for " + op.getObjectName() + " returned: " + val), (WBEMOperation)WBEMOperation.INVOKEMETHOD, (String)(ci.getClassName() + ".StartService"));
            }
        } else {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)("StartService did not return a valid value, expected a UnsignedInteger32 but received " + ret), (WBEMOperation)WBEMOperation.INVOKEMETHOD, (String)(ci.getClassName() + ".StartService"));
        }
    }

    public void stopProtocolAdapters(int type) {
        ArrayList<CIMInstance> list = this.getList(type);
        Iterator<CIMInstance> itr = list.iterator();
        for (int i = 0; i < list.size(); ++i) {
            try {
                this.stopService(itr.next());
                continue;
            }
            catch (WBEMException e) {
                this.mLogger.log(Level.WARNING, "Received Exception trying to stop service", e);
            }
        }
    }

    private void stopService(CIMInstance ci) throws WBEMException {
        CIMObjectPath op = ci.getObjectPath();
        CIMArgument[] outArgs = new CIMArgument[]{};
        CIMArgument[] inArgs = new CIMArgument[]{};
        this.pch.invokeMethod(op, "StopService", (CIMArgument<?>[])inArgs, (CIMArgument<?>[])outArgs);
    }
}

