/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.services;

import com.ws.wbem.jserver.JServerClassLoader;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerService;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.WBEMServer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;

public class JServerClasspathService
implements JServerService {
    private static final String URL = "url";
    private ClassLoader mClassLoader;

    @Override
    public void close() throws WBEMException {
    }

    @Override
    public void initialize(WBEMServer pServer, ProviderHandle pClient, Logger pLogger) {
        this.mClassLoader = pServer.getClass().getClassLoader();
        try {
            CloseableIterator e = pClient.enumerateInstances(new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), JServerSettings.replaceSchemaClassName("WS_WBEMServerLibraryPath"), null), null);
            while (e.hasNext()) {
                try {
                    CIMInstance ci = (CIMInstance)e.next();
                    String pURL = (String)ci.getProperty(URL).getValue();
                    if (!this.updateclasspath(pURL, true)) continue;
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean updateclasspath(String url, boolean add) {
        try {
            if (this.mClassLoader instanceof JServerClassLoader) {
                JServerClassLoader dcl = (JServerClassLoader)this.mClassLoader;
                if (add) {
                    dcl.addToClassPath(url);
                } else {
                    boolean found = false;
                    URL[] urls = dcl.getURLs();
                    ArrayList<URL> urlnew = new ArrayList<URL>();
                    for (URL url2 : urls) {
                        if (url.equalsIgnoreCase(url2.toString())) {
                            found = true;
                            continue;
                        }
                        urlnew.add(url2);
                    }
                    if (found) {
                        dcl = (JServerClassLoader)URLClassLoader.newInstance(urls);
                    } else {
                        return false;
                    }
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void reset() throws WBEMException {
    }
}

