/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.soma;

import java.util.Arrays;
import java.util.List;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;

class JServerRoleSupport {
    private static final String ROLE_ADMINISTRATOR = "Administrator";
    private static final String ROLE_OPERATOR = "Operator";
    private static final String ROLE_READONLY = "Read Only";
    private static final String[] SchemaOps = new String[]{WBEMOperation.ASSOCIATORCLASSES.getName(), WBEMOperation.ENUMERATECLASSES.getName(), WBEMOperation.ENUMERATECLASSNAMES.getName(), WBEMOperation.ENUMERATEQUALIFIERTYPES.getName(), WBEMOperation.GETCLASS.getName(), WBEMOperation.GETQUALIFIERTYPE.getName(), WBEMOperation.REFERENCECLASSES.getName()};
    private static final String[] SchemaOperatorOps = new String[]{WBEMOperation.CREATECLASS.getName(), WBEMOperation.CREATEQUALIFIERTYPE.getName(), WBEMOperation.DELETECLASS.getName(), WBEMOperation.DELETEQUALIFIERTYPE.getName(), WBEMOperation.MODIFYCLASS.getName(), WBEMOperation.MODIFYQUALIFIERTYPE.getName()};
    private static final String[] OperatorOps = new String[]{WBEMOperation.CREATEINSTANCE.getName(), WBEMOperation.DELETEINSTANCE.getName(), WBEMOperation.INVOKEMETHOD.getName(), WBEMOperation.INVOKESTATICMETHOD.getName(), WBEMOperation.MODIFYINSTANCE.getName()};
    private static final String[] ReadInstanceOps = new String[]{WBEMOperation.ASSOCIATORS.getName(), WBEMOperation.CLOSEENUMERATION.getName(), WBEMOperation.ENUMERATEINSTANCES.getName(), WBEMOperation.EXECUTEQUERY.getName(), WBEMOperation.GETINSTANCE.getName(), WBEMOperation.OPENASSOCIATORS.getName(), WBEMOperation.OPENENUMERATEINSTANCES.getName(), WBEMOperation.OPENQUERYINSTANCES.getName(), WBEMOperation.OPENREFERENCES.getName(), WBEMOperation.PULLINSTANCES.getName(), WBEMOperation.PULLINSTANCESWITHPATH.getName(), WBEMOperation.REFERENCES.getName()};
    private final List<String> mAdministratorRole = Arrays.asList(JServerRoleSupport.concatAll(SchemaOps, SchemaOperatorOps, OperatorOps, ReadInstanceOps));
    private final List<String> mOperatorRole = Arrays.asList(JServerRoleSupport.concatAll(SchemaOps, OperatorOps, ReadInstanceOps));
    private final List<String> mReadOnlyRole = Arrays.asList(JServerRoleSupport.concatAll(SchemaOps, new String[][]{ReadInstanceOps}));

    private static String[] concatAll(String[] first, String[] ... rest) {
        int totalLength = first.length;
        for (String[] array : rest) {
            totalLength += array.length;
        }
        String[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (String[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    protected void authorizeRole(String roleName, String operation) throws WBEMException {
        switch (roleName) {
            case "Administrator": {
                if (!this.mAdministratorRole.contains(operation)) break;
                return;
            }
            case "Operator": {
                if (!this.mOperatorRole.contains(operation)) break;
                return;
            }
            case "Read Only": {
                if (!this.mReadOnlyRole.contains(operation)) break;
                return;
            }
            default: {
                throw WBEMOperationErrors.getAccessDeniedException();
            }
        }
        throw WBEMOperationErrors.getAccessDeniedException();
    }
}

