/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import sanproject.sn2.base.authentication.inf.SJbaseAuthenticationModulePluginInterface;
import sanproject.sn2.base.authentication.lock.SJcAccountLock;
import sanproject.sn2.base.authentication.plugin.SJbaseGUMAuthentication;
import sanproject.sn2.base.property.SJbaseSystemPropertiesConst;
import sanproject.sn2.com.plugin.SJcPluginItem;
import sanproject.sn2.com.plugin.SJcPluginList;
import sanproject.sn2.com.utility.SJcAccountChkUty;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcInstanceCreateUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.com.utility.SJcUserUniqIDUty;

public class SJbaseAuthenticationSystem {
    private final String LOG_FUNCTION = "SJbaseAuthenticationSystem";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private static String szMsg;
    private String m_szUserName = null;
    private String m_SessionID = null;
    private String[] m_szGroupName = null;
    private String[] m_szRoleName = null;
    private boolean[] m_szRsgID = null;
    private boolean m_szAllRSG = false;
    private boolean[] m_szRoleMap = null;
    private String m_AuthSystemName = null;
    private String m_UserID = null;
    private SJbaseAuthenticationModulePluginInterface m_clsAuth = null;
    private String m_szPassword = null;
    private boolean bLoginBySN2user = false;
    public static final String SN2_REPOSITORY_UPDATE_PATH;

    public boolean authentication(String szUserName, String szPassword) {
        return this.authentication(szUserName, szPassword, 0) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int authentication(String szUserName, String szPassword, int iDammy) {
        String LOG_SUBTITLE = "authentication";
        try {
            if (iDammy == 1) {
                this.bLoginBySN2user = true;
            }
            szMsg = "<" + szUserName + ">Start.";
            SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
            szMsg = "Debug dataPath call";
            SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
            String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
            szMsg = "Debug dataPath:" + dataPath;
            SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
            String systemPath = SJcFileUty.concatFolderPath(dataPath, SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_ACCOUNT);
            szMsg = "Debug systemPath:" + systemPath;
            SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
            String filePath = SJcFileUty.concatFolderPath(systemPath, "AuthPluginList.properties");
            szMsg = "Debug filepath:" + filePath;
            SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
            SJcPluginList pluginList = new SJcPluginList();
            szMsg = "Debug SJcPluginList done";
            SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
            if (!pluginList.loadFile(filePath)) {
                szMsg = "<" + szUserName + ">Fail loadFile. filepath:" + filePath;
                SJcLogUty.getLogger().error("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
                int n = 11;
                return n;
            }
            szMsg = "Debug loadFile done";
            SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
            ListIterator<SJcPluginItem> iterator = pluginList.getPluginList().listIterator();
            szMsg = "Debug getPluginList done";
            SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
            int n = this.execAuthentication(szUserName, szPassword, iterator);
            return n;
        }
        catch (Exception e) {
            szMsg = "<" + szUserName + ">Exception.";
            SJcLogUty.getLogger().error("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg, e);
            int n = 11;
            return n;
        }
        finally {
            szMsg = "<" + szUserName + ">End.";
            SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
        }
    }

    public boolean authentication(String szUserName, String szPassword, String[] szAuthName) {
        return this.authentication(szUserName, szPassword, szAuthName, 0) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int authentication(String szUserName, String szPassword, String[] szAuthName, int iDammy) {
        String LOG_SUBTITLE = "authentication";
        try {
            if (iDammy == 1) {
                this.bLoginBySN2user = true;
            }
            szMsg = "<" + szUserName + ">Start.";
            SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
            String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
            String systemPath = SJcFileUty.concatFolderPath(dataPath, SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_ACCOUNT);
            String filePath = SJcFileUty.concatFolderPath(systemPath, "AuthPluginList.properties");
            SJcPluginList pluginList = new SJcPluginList();
            if (!pluginList.loadFile(filePath)) {
                szMsg = "<" + szUserName + ">Fail loadFile. filepath:" + filePath;
                SJcLogUty.getLogger().error("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
                int n = 11;
                return n;
            }
            ListIterator<SJcPluginItem> iterator = pluginList.getPluginList().listIterator();
            ArrayList<SJcPluginItem> alClass = new ArrayList<SJcPluginItem>();
            block9: while (iterator.hasNext()) {
                SJcPluginItem item = null;
                try {
                    item = iterator.next();
                    for (int i = 0; i < szAuthName.length; ++i) {
                        if (!item.getName().equals(szAuthName[i])) continue;
                        alClass.add(item);
                        continue block9;
                    }
                }
                catch (ClassCastException cce) {
                    szMsg = "<" + szUserName + ">Item class is invald.";
                    SJcLogUty.getLogger().error("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
                }
            }
            if (alClass.isEmpty()) {
                szMsg = "<" + szUserName + ">No match class." + " System:" + SJcAccountChkUty.chgArray2Str(szAuthName);
                SJcLogUty.getLogger().error("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
                int n = 11;
                return n;
            }
            int n = this.execAuthentication(szUserName, szPassword, alClass.listIterator());
            return n;
        }
        catch (Exception e) {
            szMsg = "<" + szUserName + ">Exception.";
            SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
            int n = 11;
            return n;
        }
        finally {
            szMsg = "<" + szUserName + ">End.";
            SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "authentication", szMsg);
        }
    }

    private int execAuthentication(String szUserName, String szPassword, ListIterator<SJcPluginItem> iterator) {
        String LOG_SUBTITLE = "execAuthentication";
        int iRet = 11;
        SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "execAuthentication", "Start");
        try {
            int authResult = -1;
            this.updateRepository();
            if (SJcAccountLock.isLock(szUserName)) {
                szMsg = "<" + szUserName + ">Now Locking.";
                SJcLogUty.getLogger().warn("SJbaseAuthenticationSystem", this.LOG_TITLE, "execAuthentication", szMsg);
                return iRet;
            }
            while (iterator.hasNext()) {
                SJcPluginItem item = iterator.next();
                SJbaseAuthenticationModulePluginInterface authModule = null;
                try {
                    authModule = (SJbaseAuthenticationModulePluginInterface)SJcInstanceCreateUty.newInstance(item.getClassName());
                    if (authModule instanceof SJbaseGUMAuthentication) {
                        SJbaseGUMAuthentication GUMauthModule = (SJbaseGUMAuthentication)authModule;
                        GUMauthModule.setLoginBySN2user(this.bLoginBySN2user);
                        authResult = GUMauthModule.authentication(szUserName, szPassword);
                    } else {
                        authResult = authModule.authentication(szUserName, szPassword);
                    }
                }
                catch (Exception ex) {
                    szMsg = "<" + szUserName + ">Exception AuthSystem. System:" + item.getClassName();
                    SJcLogUty.getLogger().error("SJbaseAuthenticationSystem", this.LOG_TITLE, "execAuthentication", szMsg);
                    authResult = 11;
                }
                boolean bBreak = false;
                switch (authResult) {
                    case 0: {
                        szMsg = "<" + szUserName + ">Success authentication.";
                        SJcLogUty.getLogger().info("SJbaseAuthenticationSystem", this.LOG_TITLE, "execAuthentication", szMsg);
                        this.m_szUserName = authModule.getUserName();
                        this.m_szGroupName = authModule.getGroupID();
                        this.m_szRoleName = authModule.getRoleID();
                        this.m_szRsgID = authModule.getResourceGrpMap();
                        this.m_szAllRSG = authModule.isAllRSG();
                        this.m_szRoleMap = authModule.getRoleMap();
                        this.m_szPassword = authModule.getPassword();
                        this.m_AuthSystemName = authModule.getAuthSystemName(item.getName());
                        this.m_clsAuth = authModule;
                        this.m_SessionID = authModule.getSessionID();
                        if (this.m_SessionID == null) {
                            szMsg = "<" + szUserName + ">Fail Get SessionID.";
                            SJcLogUty.getLogger().error("SJbaseAuthenticationSystem", this.LOG_TITLE, "execAuthentication", szMsg);
                            break;
                        }
                        this.m_UserID = SJcUserUniqIDUty.getUserUniqID(this.m_szUserName, this.m_AuthSystemName);
                        if (this.m_UserID == null) {
                            szMsg = "<" + szUserName + ">Fail Get UserID." + " SystemName:" + this.m_AuthSystemName;
                            SJcLogUty.getLogger().error("SJbaseAuthenticationSystem", this.LOG_TITLE, "execAuthentication", szMsg);
                            break;
                        }
                        SJcAccountLock.delete(szUserName);
                        iRet = authResult;
                        bBreak = true;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        szMsg = "<" + szUserName + ">Fail AuthSystem. Status:" + authResult;
                        SJcLogUty.getLogger().warn("SJbaseAuthenticationSystem", this.LOG_TITLE, "execAuthentication", szMsg);
                        iRet = authResult;
                        bBreak = true;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: {
                        szMsg = "<" + szUserName + ">Fail AuthSystem. Status:" + authResult;
                        SJcLogUty.getLogger().warn("SJbaseAuthenticationSystem", this.LOG_TITLE, "execAuthentication", szMsg);
                        iRet = authResult;
                        bBreak = false;
                        break;
                    }
                    default: {
                        szMsg = "<" + szUserName + ">unKnown authResult. Status:" + authResult;
                        SJcLogUty.getLogger().error("SJbaseAuthenticationSystem", this.LOG_TITLE, "execAuthentication", szMsg);
                        iRet = 11;
                        bBreak = true;
                    }
                }
                if (!bBreak) continue;
                break;
            }
            if (iRet != 0) {
                szMsg = "<" + szUserName + ">Fail authentication. Status:" + authResult;
                SJcLogUty.getLogger().warn("SJbaseAuthenticationSystem", this.LOG_TITLE, "execAuthentication", szMsg);
            }
            return iRet;
        }
        catch (Exception e) {
            szMsg = "<" + szUserName + ">Exception.";
            SJcLogUty.getLogger().error("SJbaseAuthenticationSystem", this.LOG_TITLE, "execAuthentication", szMsg, e);
            return 11;
        }
    }

    private synchronized void updateRepository() {
        try {
            Runtime runtime = Runtime.getRuntime();
            String type = SJcProductUty.getVenderID().equals("HPE") ? "hp" : "other";
            String cmd = SN2_REPOSITORY_UPDATE_PATH + " " + type;
            Process process = runtime.exec(cmd);
            process.waitFor();
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJbaseAuthenticationSystem", this.LOG_TITLE, "updateRepository", "", e);
        }
    }

    public String getUserName() {
        if (this.m_clsAuth != null) {
            return this.m_clsAuth.getUserName();
        }
        return null;
    }

    public String[] getGroupID() {
        return this.m_szGroupName;
    }

    public String[] getRoleID() {
        return this.m_szRoleName;
    }

    public boolean[] getResourceGrpMap() {
        return this.m_szRsgID;
    }

    public boolean isAllRSG() {
        return this.m_szAllRSG;
    }

    public boolean[] getRoleMap() {
        return this.m_szRoleMap;
    }

    public String getSessionID() {
        return this.m_SessionID;
    }

    public Object getPermission() {
        return null;
    }

    public SJbaseAuthenticationModulePluginInterface getAuthSystem() {
        return this.m_clsAuth;
    }

    public String getAuthSystemName() {
        return this.m_AuthSystemName;
    }

    public String getUserID() {
        return this.m_UserID;
    }

    public HashMap getAuthObject() {
        if (this.m_clsAuth != null) {
            return this.m_clsAuth.getAuthObject();
        }
        return null;
    }

    public String getPassword() {
        return this.m_szPassword;
    }

    static {
        SN2_REPOSITORY_UPDATE_PATH = SJcEnvUty.getSnBasePath() + "san\\sn2\\sn2files\\configure\\update.bat";
    }
}

