/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.common;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalGroupBooleanInfo;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.ldapcheckgroup.SJbaseLdapCheckGroupModule;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseCheckExternalGroupModule {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseCheckExternalGroupModule";
    private Properties checkGroupProperties = new Properties();
    SJbaseExternalGroupBooleanInfo groupInfo;

    public SJbaseCheckExternalGroupModule() throws SJbaseExCommunicationException {
        String method = "constructor";
        logger.info(module, method, "", "start");
        String dataPath = System.getProperty("SN_DataPath");
        try {
            SJcFileUty.decryptFile("base\\setting\\extAuth\\", "ExtarnalAuth_Config.properties", "base\\setting\\extAuth\\", "ExtarnalAuth_Config_dec.properties");
        }
        catch (Exception ex) {
            logger.error(module, method, "ExtarnalAuth_Config.properties decrypt", "failed", ex);
            throw new SJbaseExCommunicationException();
        }
        String confFileName = SJcFileUty.setEndPathSeparator(dataPath) + SJcFileUty.setEndPathSeparator("data") + "base\\setting\\extAuth\\" + "ExtarnalAuth_Config_dec.properties";
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(confFileName);
            this.checkGroupProperties.load(stream);
        }
        catch (IOException e) {
            logger.info(module, method, "load a configuration file", "failed", e);
            throw new SJbaseExCommunicationException();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ex) {}
            }
            try {
                SJcFileUty.deleteFile("base\\setting\\extAuth\\", "ExtarnalAuth_Config_dec.properties");
            }
            catch (Exception ex) {}
        }
        logger.info(module, method, "", "end");
    }

    public SJbaseExternalGroupBooleanInfo checkGroup(String groupDN) throws SJbaseExAuthenticationException, SJbaseExCommunicationException {
        String method = "checkGroup";
        logger.info(module, method, "", "start");
        if (this.checkGroupProperties == null) {
            logger.info(module, method, "check the configuration object field", "object field is null");
            throw new SJbaseExCommunicationException();
        }
        String serverType = this.checkGroupProperties.getProperty("auth.server.type");
        if (serverType == null) {
            logger.info(module, method, "check the server type", "server type is invaild");
            throw new SJbaseExCommunicationException();
        }
        String groupMapping = this.checkGroupProperties.getProperty("auth.group.mapping");
        if (groupMapping == null || groupMapping.length() == 0 || !groupMapping.equalsIgnoreCase("true")) {
            logger.info(module, method, "check the group mapping", "group maping is not set");
            throw new SJbaseExCommunicationException();
        }
        this.groupInfo = new SJbaseLdapCheckGroupModule(this.checkGroupProperties, groupDN).inquire();
        logger.info(module, method, "", "end");
        return this.groupInfo;
    }
}

