/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.comparator.SJctrArrayGroupIndexComparator;
import sanproject.sn2.controller.topwindow.pool.poolvol.SJctrPoolLdevDetail;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrDriveTypeColumnFromPoolLdevDetail
extends SJctrColumn {
    private List pdevDetailList = null;
    private List<SJmoPoolVolInfo> selPoolVolInfoList = null;

    public SJctrDriveTypeColumnFromPoolLdevDetail(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("DRVTYPERPM"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        alList.add(SJctrPoolUtility.KEY_CLASS_PDEV_DETAIL);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Object> retList = new ArrayList<Object>();
        ArrayList pdevDtlList = null;
        SJmoPoolVolInfo poolVolInfo = new SJmoPoolVolInfo();
        if (null != index && index instanceof SJctrPoolLdevDetail) {
            int iLdevIdx;
            SJctrPoolLdevDetail idxPoolLdevDtl = (SJctrPoolLdevDetail)index;
            SJmoLdevDetail ldevDtl = idxPoolLdevDtl.getLdevDetail();
            retList.add(ldevDtl);
            if (this.pdevDetailList == null) {
                pdevDtlList = new ArrayList(modelData.get(SJctrPoolUtility.KEY_CLASS_PDEV_DETAIL));
                SJctrArrayGroupIndexComparator aGComparator = new SJctrArrayGroupIndexComparator();
                Collections.sort(pdevDtlList, aGComparator);
                this.pdevDetailList = pdevDtlList;
            } else {
                pdevDtlList = this.pdevDetailList;
            }
            if (null != pdevDtlList && 0 != pdevDtlList.size()) {
                retList.addAll(pdevDtlList);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoPdevDetail List is null or size 0");
            }
            if (this.selPoolVolInfoList == null) {
                this.selPoolVolInfoList = new ArrayList(modelData.get(SJctrPoolUtility.KEY_CLASS_POOLVOL_INFO));
            }
            if (this.selPoolVolInfoList != null && this.selPoolVolInfoList.size() != 0 && (iLdevIdx = Collections.binarySearch(this.selPoolVolInfoList, ldevDtl.getIndexKey())) >= 0) {
                poolVolInfo = this.selPoolVolInfoList.get(iLdevIdx);
                retList.add(poolVolInfo);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "index is null or Class Error");
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "";
        SJmoLdevDetail ldevDtl = new SJmoLdevDetail();
        ArrayList<SJmoPdevDetail> pdevDtlList = new ArrayList<SJmoPdevDetail>();
        SJmoPoolVolInfo poolVolInfo = new SJmoPoolVolInfo();
        if (null != dataList && 0 != dataList.size()) {
            for (int iListCnt = 0; iListCnt < dataList.size(); ++iListCnt) {
                Object obj = dataList.get(iListCnt);
                if (null != obj && obj instanceof SJmoLdevDetail) {
                    ldevDtl = (SJmoLdevDetail)obj;
                    continue;
                }
                if (null != obj && obj instanceof SJmoPdevDetail) {
                    SJmoPdevDetail pdevDtl = (SJmoPdevDetail)obj;
                    pdevDtlList.add(pdevDtl);
                    continue;
                }
                if (null == obj || !(obj instanceof SJmoPoolVolInfo)) continue;
                poolVolInfo = (SJmoPoolVolInfo)obj;
            }
            SJctrPoolUtility poolUtl = this.getTable().getComUtility().getPoolUtility();
            strRtn = poolUtl.toDriveTypeRpmDisplay(ldevDtl, pdevDtlList, poolVolInfo, true);
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is null or size 0");
            strRtn = "?/?";
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 3;
    }
}

