/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolUsedCapacity;

public class SJctrEffectSavingRateColumnFromPoolDetail
extends SJctrColumn {
    private Map<String, Integer> savingRateMap = Collections.emptyMap();
    protected byte effectType = (byte)-1;

    public SJctrEffectSavingRateColumnFromPoolDetail(String key) {
        super(key);
        this.setColumnInfo();
    }

    protected void setColumnInfo() {
        this.setPartsId("SAVING_RATE");
        this.effectType = (byte)-1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> retList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        retList.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        retList.add(SJctrPoolUtility.KEY_CLASS_POOL_USED_CAPACITY);
        return retList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        List<?> retList = super.getNeedModelData(index, basicData);
        List<SJmoPoolUsedCapacity> poolUseCapInfoList = basicData.get(SJctrPoolUtility.KEY_CLASS_POOL_USED_CAPACITY);
        SJmoPoolUsedCapacity poolUseCapInfo = SJctrPoolUtility.getPoolUsedCapacityInfo((SJmoPoolIndex)index, poolUseCapInfoList);
        if (poolUseCapInfo != null) {
            retList.add(poolUseCapInfo);
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        if (this.savingRateMap == Collections.EMPTY_MAP) {
            int rowCount = this.getTable().getRowCount();
            this.savingRateMap = new HashMap<String, Integer>(rowCount);
            this.savingRateMap.put("?", -2);
            this.savingRateMap.put(SJctrPoolUtility.HAIFUN_STR, SJctrPoolUtility.HAIFUN_NUM);
        }
        if (dataList == null || dataList.size() < 2) {
            return "?";
        }
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)dataList.get(0);
        String strClmUnit = this.getTable().getUnitMenu();
        if (strClmUnit != null && strClmUnit.equals(SJctrCapacityUtility.UNIT.CYL.name()) && poolDtl.getEmulationType() == 0) {
            return SJctrPoolUtility.HAIFUN_STR;
        }
        SJmoPoolUsedCapacity poolUseCap = (SJmoPoolUsedCapacity)dataList.get(1);
        int savingRate = SJctrPoolUtility.getSavingEffectRate(poolUseCap, this.effectType, poolDtl);
        String strSavingRate = SJctrComUtility.toDecString(savingRate);
        this.savingRateMap.put(strSavingRate, savingRate);
        return strSavingRate;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long ret = -2L;
        String strSavingRate = this.getString(dat);
        Integer getValue = this.savingRateMap.get(strSavingRate);
        if (getValue != null) {
            ret = getValue.longValue();
        }
        return ret;
    }
}

