/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPoolTieringPolicy;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoPoolTieringPolicy;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrVVolTierLevelColumnFromLdevDetail
extends SJctrColumn {
    private ArrayList<SJmoPoolTieringPolicy> policyList = null;

    public SJctrVVolTierLevelColumnFromLdevDetail(String key) {
        super(key);
        this.setPartsId("TIERPOLICY");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_HDP_RELATION);
        alList.add(SJmoGetPoolTieringPolicy.class);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Object> retList = new ArrayList<Object>();
        if (null != index && index instanceof SJmoLdevDetail) {
            SJmoLdevDetail ldevDtl = (SJmoLdevDetail)index;
            retList.add(ldevDtl);
            ArrayList hdpRelList = new ArrayList(modelData.get(SJctrPoolUtility.KEY_CLASS_HDP_RELATION));
            int iHdpRelIdx = Collections.binarySearch(hdpRelList, ldevDtl);
            if (0 <= iHdpRelIdx) {
                SJmoHDPRelation hdpRel = (SJmoHDPRelation)hdpRelList.get(iHdpRelIdx);
                retList.add(hdpRel);
            }
            if (this.policyList == null) {
                this.policyList = new ArrayList(modelData.get(SJmoGetPoolTieringPolicy.class));
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "index is null or Class Error");
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        SJmoLdevDetail ldevDtl = null;
        SJmoHDPRelation hdpRel = null;
        if (null != dataList && 0 != dataList.size()) {
            for (int iListCnt = 0; iListCnt < dataList.size(); ++iListCnt) {
                Object obj = dataList.get(iListCnt);
                if (null != obj && obj instanceof SJmoLdevDetail) {
                    ldevDtl = (SJmoLdevDetail)obj;
                    continue;
                }
                if (null == obj || !(obj instanceof SJmoHDPRelation)) continue;
                hdpRel = (SJmoHDPRelation)obj;
            }
            if (null != ldevDtl && null != hdpRel) {
                SJctrComCVSUtility cvsUtl = this.getTable().getComUtility().getCVSUtility();
                strRtn = cvsUtl.getTierLevelDisplay(ldevDtl, hdpRel, this.policyList);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "Paramater Error");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is null or size 0");
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 3;
    }
}

