/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrVVolTotalCapacityColumnFromLdevDetailColumn
extends SJctrCapacityColumn {
    public SJctrVVolTotalCapacityColumnFromLdevDetailColumn(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("TOTAL"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_HDP_RELATION);
        return alList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoHDPRelation hdpRelData = null;
        String strCapaUnit = "";
        SJctrComUtility comUtil = null;
        String strRtn = "?";
        if (dataList.size() != 0) {
            hdpRelData = (SJmoHDPRelation)dataList.get(0);
            strCapaUnit = this.getUnitSelect();
            comUtil = this.getTable().getComUtility();
            strRtn = this.getTable().getComUtility().getPoolUtility().toVVollTotalCapacityDisplay(hdpRelData, strCapaUnit, comUtil);
        }
        return strRtn;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoHDPRelation> dataList = new ArrayList<SJmoHDPRelation>();
        List<Object> dpvolList = new ArrayList();
        SJmoHDPRelation hdpRelData = null;
        int iIndex = 0;
        dpvolList = modelData.get(SJctrPoolUtility.KEY_CLASS_HDP_RELATION);
        iIndex = Collections.binarySearch(dpvolList, index);
        if (iIndex >= 0) {
            hdpRelData = (SJmoHDPRelation)dpvolList.get(iIndex);
            dataList.add(hdpRelData);
        }
        return dataList;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        List<?> dpVolList = null;
        SJmoHDPRelation dpVolDetail = null;
        long lDPVolBlock = 0L;
        Map<Class<?>, List<?>> basicMap = null;
        SJmoLdevDetail ldevDetail = (SJmoLdevDetail)this.getPrimaryKeyObject(dat);
        basicMap = this.getTable().getBasicDataMap();
        dpVolList = this.getNeedModelData(ldevDetail, basicMap);
        dpVolDetail = (SJmoHDPRelation)dpVolList.get(0);
        lDPVolBlock = dpVolDetail.getLTotalCapaLBA();
        return lDPVolBlock;
    }

    @Override
    public int getFilterType() {
        return 4;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        Map<Class<?>, List<?>> basicMap;
        long retValue = 0L;
        SJctrComUtility comUtil = this.getTable().getComUtility();
        SJctrPoolUtility poolUtil = comUtil.getPoolUtility();
        SJmoLdevDetail ldevDetail = (SJmoLdevDetail)this.getPrimaryKeyObject(dat);
        List<?> dpVolList = this.getNeedModelData(ldevDetail, basicMap = this.getTable().getBasicDataMap());
        if (!dpVolList.isEmpty()) {
            SJmoHDPRelation dpVolDetail = (SJmoHDPRelation)dpVolList.get(0);
            long dpVolBlock = dpVolDetail.getLTotalCapaLBA();
            int emulationType = dpVolDetail.getIEmulationType();
            emulationType = poolUtil.changeEmulationType(emulationType);
            retValue = poolUtil.getPages(emulationType, dpVolBlock, comUtil);
        }
        return retValue;
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        SJctrComUtility comUtil = this.getTable().getComUtility();
        long cylinder = 0L;
        SJmoLdevDetail ldevDetail = (SJmoLdevDetail)this.getPrimaryKeyObject(dat);
        Map<Class<?>, List<?>> basicMap = this.getTable().getBasicDataMap();
        List<?> dpVolList = this.getNeedModelData(ldevDetail, basicMap);
        SJmoHDPRelation dpVolDetail = (SJmoHDPRelation)dpVolList.get(0);
        int emuType = dpVolDetail.getIEmulationType();
        int ldevEmuType = comUtil.getPoolUtility().changeEmulationType(emuType);
        long block = this.getNumber(dat);
        SJctrCapacityUtility capaUtil = comUtil.getCapacityUtility();
        cylinder = capaUtil.toCylValue(block, ldevEmuType);
        return cylinder;
    }
}

