/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.rsg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrRsgColumnFromPortHostGroupTableKey
extends SJctrColumn {
    public static final String DEFAULT_STR = "";
    public static final int NOT_RSG_ID = -1;
    static final String NAME_ID_RSG = "RES_GRP_NAME_ID";
    private boolean bInitiator = false;

    public SJctrRsgColumnFromPortHostGroupTableKey(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance(NAME_ID_RSG));
    }

    @Override
    public int getFilterType() {
        return 1;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortHostGroupInfo.class);
        list.add(SJmoGetRSGgetAllRsgs.class);
        list.add(SJmoGetPortAttributeInfo.class);
        list.add(SJmoGetPortIscsiTargetInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoRSGgetRsg> list = new ArrayList<SJmoRSGgetRsg>();
        SJctrPortHostGroupTableKey ptHginfo = (SJctrPortHostGroupTableKey)index;
        SJmoHostGroupIndex hostGroupIndex = new SJmoHostGroupIndex();
        if (ptHginfo.isFibre()) {
            SJmoHostGroupInfo hostGroupInfo = ptHginfo.getHostGroupInfo();
            hostGroupIndex.setSHostGroup(hostGroupInfo.getSHostGroup());
            hostGroupIndex.setSPort(hostGroupInfo.getSPort());
        } else {
            SJmoIscsiTargetInfo iscsiTargetInfo = ptHginfo.getIscsiTargetInfo();
            hostGroupIndex.setSHostGroup(iscsiTargetInfo.getSIscsiTarget());
            hostGroupIndex.setSPort(iscsiTargetInfo.getSPort());
        }
        this.bInitiator = false;
        List<?> portAttrList = modelData.get(SJmoGetPortAttributeInfo.class);
        if (portAttrList != null && !portAttrList.isEmpty()) {
            SJmoPortAttributeInfo portAttr;
            int search = -1;
            search = ptHginfo.isFibre() ? Collections.binarySearch(portAttrList, ptHginfo.getPortHostGroupInfo()) : Collections.binarySearch(portAttrList, ptHginfo.getPortIscsiTargetInfo());
            if (search >= 0 && (portAttr = (SJmoPortAttributeInfo)portAttrList.get(search)).getByPortKind() == 5) {
                this.bInitiator = true;
            }
        }
        List<?> allRsgsList = modelData.get(SJmoGetRSGgetAllRsgs.class);
        SJmoRSGgetRsg rtnRsg = null;
        if (allRsgsList != null && allRsgsList.size() > 0) {
            ArrayList rsglist = ((SJmoRSGgetAllRsgs)allRsgsList.get(0)).getRsgs();
            for (SJmoRSGgetRsg rsg : rsglist) {
                ArrayList hgList = rsg.getHostGrps();
                int rsgIndex = Collections.binarySearch(hgList, hostGroupIndex);
                if (rsgIndex < 0) continue;
                rtnRsg = rsg;
            }
        }
        list.add(rtnRsg);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        if (this.bInitiator) {
            return SJctrPortUtility.STR_HYPHEN;
        }
        String dispString = DEFAULT_STR;
        SJmoRSGgetRsg rtnRsg = (SJmoRSGgetRsg)dataList.get(0);
        SJctrComUtility comUtil = this.getTable().getComUtility();
        if (rtnRsg != null) {
            SJmoRSGInfo rsgInfo = rtnRsg.getRsgInfo();
            dispString = SJctrRsgUtility.toRsgIdDisplay(comUtil, rsgInfo);
        } else {
            dispString = "?";
        }
        return dispString;
    }
}

